/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.Utils;
import ru.bitel.common.io.IOUtils;

public class ActionGenerateInvoices
extends ActionBase {
    public void doAction() throws Exception {
        InputStream is;
        String billsxml;
        int yy = this.getIntParameter("y", 0);
        int mm = this.getIntParameter("m", -1);
        Date date = this.getDateParameter("date");
        if (this.mid <= 0 || yy <= 0 || mm < 0 || date == null) {
            throw new BGIllegalArgumentException();
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionGenerateInvoices", (int)this.mid, (int)this.userId);
        if (closedDate != null) {
            LocalDate month = LocalDate.of(yy, mm + 1, 1);
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (LocalDate)month, (LocalDate)month);
        }
        if (Utils.notEmptyString((String)(billsxml = this.getParameter("bills_x", "")))) {
            is = new GZIPInputStream(IOUtils.urlDecode((InputStream)new ByteArrayInputStream(billsxml.getBytes("UTF-8"))), 2048);
        } else {
            billsxml = this.getParameter("bills", "");
            is = new ByteArrayInputStream(billsxml.getBytes("UTF-8"));
        }
        new InvoiceManager(this.con, this.mid).addBillDocs(this.userId, is, yy, mm, date);
    }
}

