/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server;

import bitel.billing.server.ApplicationModule;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.MenuItem;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractServiceDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMethod;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMode;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ModuleEntity;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.server.WebMenu;
import ru.bitel.bgbilling.server.WebMenuBase;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public abstract class ModuleBase
extends WebMenuBase
implements ApplicationModule {
    @Override
    public void serializeContract(Connection con, int contractId, int moduleId, XMLStreamWriter tables, boolean onlyCurrent) throws Exception {
    }

    @Override
    public String getStatus(Connection con, int moduleId, int contractId) throws BGException {
        return "";
    }

    @Override
    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
    }

    @Override
    public List<ModuleEntity> getObjectEntities(Connection con, int moduleId, int objectId) throws Exception {
        return null;
    }

    @Override
    public void lockServiceNow(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
    }

    @Override
    public void lockService(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
    }

    @Override
    public void unlockService(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
    }

    @Override
    public void unlockServiceNow(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
    }

    @Override
    public List<URL> getDeployment() {
        return Collections.emptyList();
    }

    @Override
    public void start(Connection con, BGModule module) throws Exception {
    }

    public void deleteContractServices(Connection con, int contractId, int moduleId) throws Exception {
        new ContractServiceDao(con).deleteContractService(contractId, moduleId);
    }

    @Override
    public List<MenuItem> getWebMenuItems(Connection con, String module, int moduleId, boolean all) throws Exception {
        ArrayList<MenuItem> list = new ArrayList<MenuItem>();
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(moduleId);
        Element extension = ModuleCache.getInstance().getInstalledModule(module).getServerExtensionMap().get(WebMenu.class.getName());
        if (extension == null) {
            return list;
        }
        for (Element itemElement : XMLUtils.selectElements((Node)extension, (String)"item")) {
            int id = Utils.parseInt((String)itemElement.getAttribute("id"));
            String title = itemElement.getAttribute("titleDefault");
            if (!all) {
                String webMenuItemTitle = moduleSetup.get("web.menuItem" + id, null);
                if (webMenuItemTitle != null) {
                    if ("none".equals(webMenuItemTitle)) continue;
                    title = webMenuItemTitle;
                } else if ("0".equals(itemElement.getAttribute("defaultVisible"))) continue;
            }
            list.add(new MenuItem().setId(id).setTitle(title).setModule(module).setModuleId(moduleId).setIcon(itemElement.getAttribute("icon")).setAction(itemElement.getAttribute("action")).setDescription(itemElement.getAttribute("description")));
        }
        return list;
    }

    protected void enableAutopayment(Document dataDoc, String moduleName, int moduleId, int contractId, Connection con, int userId) throws Exception {
        Element moduleElement;
        if (dataDoc != null && (moduleElement = XMLUtils.selectElement((Node)dataDoc, (String)("data/modules/" + moduleName + "[@mid=" + moduleId + "]"))) != null) {
            try (ContractAutopaymentManager contractAutopaymentManager = new ContractAutopaymentManager(con, moduleId);){
                contractAutopaymentManager.setEnabled(contractId, "on".equals(moduleElement.getAttribute("enabled")), userId);
            }
        }
    }

    protected void removeAutopayment(int moduleId, int contractId, Connection con) throws Exception {
        try (ContractAutopaymentManager contractAutopaymentManager = new ContractAutopaymentManager(con, moduleId);){
            contractAutopaymentManager.cleanForContract(contractId);
        }
    }

    public List<PaymentMethod> getPaymentMethods(int moduleId) {
        return null;
    }

    public PaymentMode getPaymentMode() {
        return PaymentMode.REDIRECT;
    }
}

