/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.uniteller.server.event.worker;

import java.math.BigDecimal;
import java.util.Optional;
import org.slf4j.MDC;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.uniteller.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.uniteller.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.uniteller.server.event.UnitellerAutopaymentEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class UnitellerAutopaymentEventWorker
extends EventWorker {
    private final int moduleId;
    private TransactionManager transactionManager;
    private AutopaymentManager autopaymentManager;

    public UnitellerAutopaymentEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), UnitellerAutopaymentEvent.class, moduleId, -1, null);
        this.moduleId = moduleId;
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 60000L;
        this.getLogger().info("Starting UnitellerAutopaymentEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "uniteller-autopayment-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.autopaymentManager = new AutopaymentManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        return this.doTasks();
    }

    public Object doTask(Object task) throws BGException {
        try {
            UnitellerAutopaymentEvent event = (UnitellerAutopaymentEvent)((Object)task);
            int contractId = event.getContractId();
            Autopayment autopayment = this.autopaymentManager.getCurrentAutopayment(contractId);
            BigDecimal sum = Optional.ofNullable(event.getSum()).orElse(autopayment.getSum());
            MDC.put((String)"module", (String)"uniteller");
            MDC.put((String)"moduleId", (String)String.valueOf(this.moduleId));
            MDC.put((String)"contractId", (String)String.valueOf(contractId));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("sum = " + String.valueOf(sum));
                this.getLogger().debug("autopayment = " + String.valueOf(autopayment));
            }
            if (autopayment != null && autopayment.getMode() == event.getMode()) {
                this.transactionManager.doRecurrentRequest(contractId, sum, autopayment.getAccessToken());
            }
            Object var6_7 = null;
            return var6_7;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            MDC.remove((String)"module");
            MDC.remove((String)"moduleId");
            MDC.remove((String)"contractId");
        }
    }
}

