/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.apps.voice.accounting.bean.SessionAccountAmount;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.network.radius.AccountingSession;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.bean.VoiceTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeEntry;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAbtractAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOperAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.tariff.AddCallCostTariffTreeNode;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceServiceCost;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffRequest;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffWorkerContext;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.worker.ThreadContext;

public class VoiceSessionRuntime
extends BGLogger
implements AccountingSession {
    public static final short STATUS_ALIVE = 0;
    public static final short STATUS_FINESHED = 1;
    private final VoiceSession session;
    private int contractId = 0;
    private final VoiceAbtractAccountRuntime<?> accountRuntime;
    private String tarifficationNumber;
    private Map<Integer, SessionAccountAmount> accountAmountMap = new HashMap<Integer, SessionAccountAmount>();
    Map<Integer, SessionAccountAmount> accountDeltaMap = new HashMap<Integer, SessionAccountAmount>();
    private long calculateAmountDelta = 0L;
    private TrafficRangeEntry rangedTraffic;
    private final boolean isOperSession;
    private VoiceSessionRuntime parentSession;
    private Set<Integer> optionsSet = new HashSet<Integer>();

    public VoiceSessionRuntime(VoiceSession session, VoiceAbtractAccountRuntime<?> accountRuntime) {
        this.session = session;
        this.contractId = session.getContractId();
        this.accountRuntime = accountRuntime;
        this.tarifficationNumber = this.session.getE164CalledStationId();
        this.isOperSession = accountRuntime instanceof VoiceOperAccountRuntime;
    }

    public String getUserName() {
        return null;
    }

    public VoiceSession getSession() {
        return this.session;
    }

    public TrafficRangeEntry getRangedTraffic() {
        return this.rangedTraffic;
    }

    public void setRangedTraffic(TrafficRangeEntry rangedTraffic) {
        this.rangedTraffic = rangedTraffic;
    }

    public int getContractId() {
        return this.contractId;
    }

    public int calculate(VoiceTariffContext tariffContext, boolean round) throws BGException {
        return this.calculate(tariffContext, null, round);
    }

    public int calculate(VoiceTariffContext tariffContext, Long amount, boolean round) throws BGException {
        VoiceOperAccountRuntime operAccountRuntime;
        int serviceId;
        VoiceTariffWorkerContext workerContext = (VoiceTariffWorkerContext)VoiceTariffWorkerContext.get();
        int moduleId = workerContext.getModuleId();
        VoiceTariffRequest voiceTariffRequest = new VoiceTariffRequest(0, moduleId, this.session.getContractId(), this.session.getId(), null, 0, 0L, 0L, this);
        voiceTariffRequest.setTime(TimeUtils.convertDateToCalendar((Date)this.session.getSessionStart()));
        ServerContext serverContext = (ServerContext)ServerContext.get();
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(serverContext.getConnectionSet(), Integer.valueOf(this.contractId));
        ContractTariffOptionList contractTariffOptions = contractRuntime.getTariffOptions(voiceTariffRequest.getTime().getTimeInMillis());
        voiceTariffRequest.setContractTariffOptions(contractTariffOptions);
        String calledNumber = this.tarifficationNumber;
        voiceTariffRequest.setPhoneTo(calledNumber);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("calledNumber={}", (Object)calledNumber);
            this.getLogger().trace("session.getE164CallingStationId={}", (Object)this.session.getE164CallingStationId());
            this.getLogger().trace("session.getCalledStationId={}", (Object)this.session.getCalledStationId());
        }
        voiceTariffRequest.setPhoneOriginalTo(this.session.getCalledStationId());
        voiceTariffRequest.setCallType(this.session.getCallType());
        voiceTariffRequest.setOperatorId(this.session.getOperatorId());
        voiceTariffRequest.setPhoneFrom(this.session.getE164CallingStationId());
        long amountForTariff = amount != null ? amount.longValue() : this.session.getSessionTime();
        voiceTariffRequest.serviceCost = new VoiceServiceCost().setAmount(amountForTariff);
        voiceTariffRequest.setPortFrom(this.session.getFromPort());
        voiceTariffRequest.setPortTo(this.session.getToPort());
        if (this.accountRuntime instanceof VoiceOperAccountRuntime && (serviceId = ((VoiceOperAccount)(operAccountRuntime = (VoiceOperAccountRuntime)this.accountRuntime).getAccount()).getServiceId()) > 0) {
            ArrayList<VoiceServiceCost> serviceCosts = new ArrayList<VoiceServiceCost>();
            serviceCosts.add((VoiceServiceCost)voiceTariffRequest.serviceCost);
            voiceTariffRequest.getServiceCost().put(serviceId, serviceCosts);
            ((VoiceServiceCost)voiceTariffRequest.serviceCost).setServiceId(serviceId);
        }
        TariffModuleTreeSet treeSet = this.accountRuntime.getTariffTreeSet();
        List treeList = treeSet.getEntryList(this.session.getSessionStart().getTime());
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("treeSet = {}", (Object)treeSet.toString());
            this.getLogger().trace("treeList.size() = {}", (Object)treeList.size());
        }
        try {
            int result = this.calcInternal(tariffContext, round, workerContext, voiceTariffRequest, treeList);
            this.getLogger().trace("calcInternal result = {}", (Object)result);
            if (result >= 0) {
                if (result == 0) {
                    this.session.setContractId(this.accountRuntime.getAccount().getContractId());
                    this.contractId = this.accountRuntime.getAccount().getContractId();
                }
                return result;
            }
            if (result < 0 && this.accountRuntime instanceof VoiceAccountRuntime) {
                VoiceAccountRuntime accountRuntimeCl = (VoiceAccountRuntime)this.accountRuntime;
                for (VoiceAccountRuntime.ContractInfo contractInfo : accountRuntimeCl.getSubContracts()) {
                    treeList = contractInfo.tariffTreeSet.getEntryList(this.session.getSessionStart().getTime());
                    result = this.calcInternal(tariffContext, round, workerContext, voiceTariffRequest, treeList);
                    if (tariffContext.isRuntime() && !StatusCache.getInstance().isModuleActiveStatus(moduleId, contractInfo.status) || result < 0) continue;
                    if (result == 0) {
                        this.session.setContractId(contractInfo.contractId);
                        this.contractId = contractInfo.contractId;
                    }
                    return result;
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error(String.valueOf(e) + "; contractId=" + this.session.getContractId() + "; sessionId=" + this.session.getId());
        }
        return AccessCode.PRICE_NOT_FOUND.getCode();
    }

    private int calcInternal(TariffContext tariffContext, boolean round, VoiceTariffWorkerContext workerContext, VoiceTariffRequest tariffRequest, List<TariffModuleTreeSet.Entry> treeList) {
        if (treeList.size() == 0) {
            return AccessCode.TARIFF_NOT_FOUND.getCode();
        }
        BigDecimal sessionCost = this.session.getSessionCost();
        boolean priceFound = false;
        for (TariffModuleTreeSet.Entry entry : treeList) {
            try {
                tariffRequest.setTariffTreeSetEntry(entry);
            }
            catch (SQLException ex) {
                this.logError(ex);
            }
            entry.getTree().execute((AbstractTariffRequest)tariffRequest, tariffContext, (ThreadContext)workerContext);
            List serviceCosts = (List)tariffRequest.getServiceCostList();
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("serviceCosts.size() = {}", (Object)serviceCosts.size());
            }
            if (tariffRequest.isRejected()) {
                return AccessCode.AUTH_DENY.getCode();
            }
            if (serviceCosts.size() == 0) continue;
            priceFound = true;
            int destId = tariffRequest.getDestId();
            if (destId <= 0) {
                return AccessCode.DESTINATION_NOT_FOUND.getCode();
            }
            this.session.setDestinationId(destId);
            int zoneId = tariffRequest.getZoneId();
            int codeId = tariffRequest.getCodeId();
            int operatorId = tariffRequest.getOperatorId();
            int costMapItemId = tariffRequest.getCostMapItemId();
            this.session.setZoneId(zoneId);
            this.session.setCodeId(codeId);
            this.session.setCostMapItemId(costMapItemId);
            this.session.setOperatorId(operatorId);
            for (VoiceServiceCost cost : serviceCosts) {
                if (cost.getServiceId() == 0 || cost.getCost() == null) {
                    if (!(cost.getServiceId() == 0 ^ cost.getCost() == null)) continue;
                    return AccessCode.TARIFF_ERROR.getCode();
                }
                SessionAccountAmount accountAmount = this.accountAmountMap.get(cost.getServiceId());
                if (accountAmount == null) {
                    accountAmount = new SessionAccountAmount(BigDecimal.ZERO, 0L);
                    this.accountAmountMap.put(cost.getServiceId(), accountAmount);
                }
                if (round) {
                    this.roundServiceCost(tariffRequest, cost);
                }
                accountAmount.addAccount(cost.getCost(), tariffContext.mc);
                accountAmount.addAmount(cost.getAmount());
                sessionCost = sessionCost.add(cost.getCost(), tariffContext.mc);
                SessionAccountAmount delta = this.getAccountDeltaMap().get(cost.getServiceId());
                if (delta == null) {
                    delta = new SessionAccountAmount(cost.getCost(), cost.getAmount());
                    this.getAccountDeltaMap().put(cost.getServiceId(), delta);
                    continue;
                }
                delta.addAmount(cost.getAmount());
                delta.addAccount(cost.getCost(), tariffContext.mc);
            }
            if (round) {
                int result = this.roundSessionTime(tariffRequest, serviceCosts, tariffContext.mc, sessionCost);
                if (result > 0) {
                    return result;
                }
            } else {
                this.session.setRoundedSessionTime(this.session.getSessionTime());
                this.session.setSessionCost(sessionCost);
            }
            this.setFirstServiceAndMinuteCost(serviceCosts);
            this.optionsSet = tariffRequest.getOptionSet();
            break;
        }
        if (!priceFound) {
            return -1;
        }
        return 0;
    }

    private void setFirstServiceAndMinuteCost(List<VoiceServiceCost> serviceCosts) {
        if (serviceCosts.size() > 0) {
            VoiceServiceCost cost = serviceCosts.get(0);
            this.session.setServiceId(cost.getServiceId());
            this.session.setMinuteCost(cost.secondCost.multiply(new BigDecimal(60)));
        }
    }

    private void roundServiceCost(VoiceTariffRequest tariffRequest, VoiceServiceCost cost) {
        VoiceTariffConfig config = tariffRequest.getConfig();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("roundServiceCost: cost.cost = " + String.valueOf(cost.getCost()) + "; config = " + String.valueOf(config));
        }
        if (config != null && cost != null) {
            cost.setCost(config.roundCost(cost.getCost() != null ? cost.getCost() : BigDecimal.ZERO, 5));
        }
    }

    private int roundSessionTime(VoiceTariffRequest tariffRequest, List<VoiceServiceCost> serviceCosts, MathContext mc, BigDecimal sessionCost) {
        long roundTime = this.session.getSessionTime();
        VoiceTariffConfig config = tariffRequest.getConfig();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("session.getSessionTime() = " + this.session.getSessionTime() + "; config = " + String.valueOf(config));
        }
        if (config != null && serviceCosts.size() > 0) {
            long delta;
            VoiceServiceCost lastCost = serviceCosts.get(serviceCosts.size() - 1);
            roundTime = config.getRoundTime((int)this.session.getSessionTime());
            long l = delta = config.isUseRound() ? 0L : roundTime - this.session.getSessionTime();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("lastCost = " + String.valueOf((Object)lastCost) + "; roundTime = " + roundTime + "; delta = " + delta);
            }
            if (delta > 0L) {
                if (lastCost.getAmount() > 0L) {
                    SessionAccountAmount deltaCost;
                    BigDecimal secondCost = lastCost.secondCost;
                    BigDecimal newDeltaCost = config.roundCost(new BigDecimal(lastCost.getAmount() + delta).multiply(lastCost.secondCost), 5);
                    newDeltaCost = newDeltaCost.subtract(lastCost.getCost());
                    newDeltaCost.add(this.getAddCost(tariffRequest, roundTime));
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("secondCost = " + String.valueOf(secondCost) + "; newDeltaCost = " + String.valueOf(newDeltaCost));
                    }
                    sessionCost = sessionCost.add(newDeltaCost, mc);
                    SessionAccountAmount cost = this.accountAmountMap.get(lastCost.getServiceId());
                    if (cost != null) {
                        cost.addAccount(newDeltaCost, mc);
                    }
                    if ((deltaCost = this.accountDeltaMap.get(lastCost.getServiceId())) == null) {
                        deltaCost = new SessionAccountAmount(newDeltaCost, 0L);
                        this.getAccountDeltaMap().put(lastCost.getServiceId(), deltaCost);
                    } else {
                        deltaCost.addAccount(newDeltaCost, mc);
                    }
                }
            } else if (delta < 0L && roundTime == 0L) {
                sessionCost = BigDecimal.ZERO;
                this.accountAmountMap.clear();
            } else if (delta < 0L) {
                return AccessCode.TARIFF_ERROR.getCode();
            }
            sessionCost = config.roundCost(sessionCost, 5);
        }
        this.session.setRoundedSessionTime(roundTime);
        this.session.setSessionCost(sessionCost);
        return 0;
    }

    private BigDecimal getAddCost(VoiceTariffRequest tariffRequest, long roundSessionTime) {
        AddCallCostTariffTreeNode addCost = tariffRequest.getAddCost();
        if (!(addCost == null || addCost.nonZero && roundSessionTime <= 0L)) {
            return addCost.cost;
        }
        return BigDecimal.ZERO;
    }

    public long getCalculateAmountDelta() {
        return this.calculateAmountDelta;
    }

    public void setCalculateAmountDelta(long calculateAmountDelta) {
        this.calculateAmountDelta = calculateAmountDelta;
    }

    public Map<Integer, SessionAccountAmount> getAccountDeltaMap() {
        return this.accountDeltaMap;
    }

    public Map<Integer, SessionAccountAmount> getAccountAmountMap() {
        return this.accountAmountMap;
    }

    public static List<VoiceSessionRuntime> toListRuntime(List<VoiceSessionRuntime> session) {
        return null;
    }

    public String getTarifficationNumber() {
        return this.tarifficationNumber;
    }

    public void setTarifficationNumber(String tarifficationNumber) {
        this.tarifficationNumber = tarifficationNumber;
    }

    public boolean isOperSession() {
        return this.isOperSession;
    }

    public VoiceAbtractAccountRuntime<?> getAccountRuntime() {
        return this.accountRuntime;
    }

    public int hashCode() {
        return this.accountRuntime != null ? this.accountRuntime.getAccountId() : 0;
    }

    public VoiceSessionRuntime getParentSession() {
        return this.parentSession;
    }

    public void setParentSession(VoiceSessionRuntime parentSession) {
        this.parentSession = parentSession;
    }

    public Set<Integer> getOptionsSet() {
        return this.optionsSet;
    }
}

