/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30;

import java.io.IOException;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.BitArrayOutputStream;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.CDCAS30Connection;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.Request;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.SendMailResponse;

public class SendMailRequest
extends Request<SendMailRequest, SendMailResponse> {
    private String title;
    private String text;
    private int importance = 0;
    private String charset = "utf-8";

    public SendMailRequest(CDCAS30Connection connection, int dB_ID) {
        super(connection, dB_ID);
    }

    public void setData(String title, String text, String emailCharset) throws IOException {
        if (title.length() > 30) {
            throw new IOException("title length > 30");
        }
        if (text.length() > 160) {
            throw new IOException("text length > 160");
        }
        this.title = title;
        this.text = text;
        this.charset = emailCharset;
    }

    @Override
    protected int getMessageId() {
        return 769;
    }

    @Override
    protected void writeDataCont(BitArrayOutputStream output) throws IOException {
        String exp = "card=" + new String(this.card_sn);
        output.writeBits(exp.length(), 8);
        output.write(exp.getBytes("ascii"));
        byte[] s = this.title.getBytes(this.charset);
        output.writeBits(s.length, 8);
        output.write(s);
        s = this.text.getBytes(this.charset);
        output.writeBits(s.length, 8);
        output.write(s);
        output.writeBits(this.importance, 8);
    }

    @Override
    public SendMailResponse getResponse() {
        return new SendMailResponse(this.connection, this.DB_ID);
    }
}

