/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGBorderFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class CommentPatternEditor
extends BGPanel {
    private int mode = 17;
    private String nameEditor = "\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0435\u0432";
    private PatternTableModel patternTableModel = new PatternTableModel(PatternTableModel.class.getName());
    private BGUTable table = new BGUTable(this.patternTableModel);

    @Override
    public void init(String module, int moduleId) {
        super.init(module, moduleId);
    }

    public CommentPatternEditor() {
        this.tryCall(() -> this.jbInit());
    }

    private void jbInit() throws Exception {
        this.table.setBorder(BGBorderFactory.createEmptyBorder());
        this.table.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.setBorder(new BGTitleBorder(this.nameEditor));
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        BGSwingUtilites.handleLDMouseClicked(this.table, e -> this.editItem());
    }

    @Override
    public void setData() {
        Request request = new Request().setModule(this.module).setAction("ListDirectory").setAttribute("mode", this.mode);
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.trySetDocument(doc);
        }
    }

    @Override
    public void setDocument(Document doc) throws Exception {
        ArrayList<ContractPatternItem> patterns = new ArrayList<ContractPatternItem>();
        for (Element element : XMLUtils.selectElements(doc, "//table/data/row")) {
            ContractPatternItem contractPattern = new ContractPatternItem();
            contractPattern.setId(Utils.parseInt(element.getAttribute("f0")));
            contractPattern.setTitle(element.getAttribute("f1"));
            contractPattern.setPattern(element.getAttribute("f2"));
            patterns.add(contractPattern);
        }
        this.patternTableModel.setData(patterns);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if ("newItem".equals(actionCommand)) {
            this.newItem();
        } else if ("editItem".equals(actionCommand)) {
            this.editItem();
        } else if ("deleteItem".equals(actionCommand)) {
            ContractPatternItem contractPattern = (ContractPatternItem)this.patternTableModel.getSelectedRow();
            if (contractPattern == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
                return;
            }
            if (!ClientUtils.confirmDelete(((ContractPatternItem)this.patternTableModel.getSelectedRow()).getTitle())) {
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("DeleteDirectoryItem");
            request.setAttribute("mode", this.mode);
            request.setAttribute("id", ((ContractPatternItem)this.patternTableModel.getSelectedRow()).getId());
            if (!ClientUtils.checkStatus(TransferManager.getDocument(request))) {
                return;
            }
            this.setData();
        } else if ("refresh".equals(actionCommand)) {
            this.setData();
        }
    }

    @Override
    public void newItem() {
        new Editor("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f", new ContractPatternItem()).open();
    }

    @Override
    public void editItem() {
        this.patternTableModel.optSelectedRow().ifPresentOrElse(contractPattern -> new Editor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f", (ContractPatternItem)contractPattern).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!"));
    }

    class PatternTableModel
    extends BGTableModel<ContractPatternItem> {
        public PatternTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 150, 250, 500, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0428\u0430\u0431\u043b\u043e\u043d", 150, 150, -1, "pattern", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class ContractPatternItem
    extends IdTitle {
        private String pattern = "";

        public ContractPatternItem() {
            super.setId(-1);
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }

    class Editor
    extends BGEditorDialog<ContractPatternItem> {
        private JTextField title;
        private JTextField pattern;

        public Editor(String title, ContractPatternItem data) {
            super(title, data);
            this.title = new JTextField(50);
            this.pattern = new JTextField();
        }

        @Override
        public void doDialogPanel() {
            this.title.setPreferredSize(new Dimension(this.title.getPreferredSize().width, 24));
            this.addFieldV("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:", this.title);
            this.addFieldV("\u0428\u0430\u0431\u043b\u043e\u043d:", this.pattern);
            this.title.setText(((ContractPatternItem)this.data).getTitle());
            this.pattern.setText(((ContractPatternItem)this.data).getPattern());
        }

        @Override
        public boolean doApply() throws Exception {
            if (this.title.getText().trim().length() == 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            Request request = new Request();
            request.setModule(CommentPatternEditor.this.module);
            request.setAction("UpdateDirectoryItem");
            request.setAttribute("mode", CommentPatternEditor.this.mode);
            request.setAttribute("id", ((ContractPatternItem)this.data).getId());
            request.setAttribute("title", this.title.getText().trim());
            request.setAttribute("pattern", this.pattern.getText().trim());
            if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
                CommentPatternEditor.this.setData();
            }
            return true;
        }
    }
}

