/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.server.action.web;

import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.modules.subscription.common.bean.RegistrationPeriod;
import ru.bitel.bgbilling.modules.subscription.common.bean.Subscription;
import ru.bitel.bgbilling.modules.subscription.common.bean.SubscriptionType;
import ru.bitel.bgbilling.modules.subscription.common.service.SubscriptionService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.PeriodWithTime;

@WebAction(title="Subscription")
public class ActionSubscription
extends AbstractAction {
    @Resource
    private SubscriptionService subscriptionService;

    public ActionSubscription() {
        super("subscription");
    }

    @WebOperation(title="\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438")
    public void active() throws Exception {
        this.list(true);
    }

    @WebOperation(title="\u0410\u0440\u0445\u0438\u0432\u043d\u044b\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438")
    public void history() throws Exception {
        this.list(false);
    }

    private void list(boolean active) throws Exception {
        int n = 1;
        LocalDateTime now = LocalDateTime.now();
        ArrayList rows = new ArrayList();
        HashMap<Integer, SubscriptionType> types = new HashMap<Integer, SubscriptionType>();
        for (Subscription subscription : this.subscriptionService.subscriptionList(this.contractId, true)) {
            if (TimeUtils.dateInPeriod((LocalDateTime)now, (PeriodWithTime)subscription.getPeriod()) != active) continue;
            SubscriptionType subscriptionType = (SubscriptionType)types.get(subscription.getTypeId());
            if (subscriptionType == null) {
                int typeId = subscription.getTypeId();
                subscriptionType = this.subscriptionService.subscriptionTypeGet(typeId);
                if (subscriptionType == null) {
                    subscriptionType = new SubscriptionType().setTitle("???");
                }
                types.put(typeId, subscriptionType);
            }
            subscription.setSubscriptionType(subscriptionType);
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            rowMap.put("n", n++);
            rowMap.put("name", subscription.getSubscriptionType().getTitle());
            rowMap.put("period", subscription.getPeriod().toString());
            rowMap.put("lastActivePeriod", subscription.getRegistrationPeriodId() > 0 ? ((RegistrationPeriod)subscription.getRegistrationPeriodList().get(0)).getPeriod().toString() : "-");
            rowMap.put("active", subscription.isActive());
            rowMap.put("avtoCommit", subscription.isAvtoCommit());
            rowMap.put("comment", subscription.getComment());
            rows.add(rowMap);
        }
        this.setResultParam("active", active);
        this.setResultParam("rows", rows);
        this.requestDispatcher(this.moduleName, "list");
    }
}

