/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gorod.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.gorod.server.bean.Register;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class RegisterManager
extends AbstarctDaoConstant {
    public RegisterManager(Connection con, int moduleId) {
        super(con, "gorod_register", moduleId);
    }

    public Register getRegisterById(int id) throws SQLException {
        Register result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = new Register();
                    result.setTagId(rs.getInt("tid"));
                    result.setType(rs.getInt("type"));
                    result.setDate(TimeUtils.convertDateToCalendar((Date)rs.getDate("dt")));
                    result.setId(rs.getInt("id"));
                }
            }
        }
        return result;
    }

    public void addRegister(Register register) throws SQLException {
        Objects.requireNonNull(register, "register must be not null");
        String query = "INSERT INTO " + this.tableName + " SET dt=?, type=?, tid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)register.getDate()));
            ps.setInt(2, register.getType());
            ps.setInt(3, register.getTagId());
            ps.executeUpdate();
            register.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
    }

    public List<Register> getRegisterList(Calendar date1, Calendar date2) throws SQLException {
        ArrayList<Register> result = new ArrayList<Register>();
        String query = "SELECT * FROM " + this.tableName + " WHERE (? IS NULL OR ?<=dt) AND (? IS NULL OR ?>=dt) ORDER BY dt";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            java.sql.Date sqlDate1 = TimeUtils.convertCalendarToSqlDate((Calendar)date1);
            java.sql.Date sqlDate2 = TimeUtils.convertCalendarToSqlDate((Calendar)date2);
            ps.setDate(1, sqlDate1);
            ps.setDate(2, sqlDate1);
            ps.setDate(3, sqlDate2);
            ps.setDate(4, sqlDate2);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.loadRegisterFromRS(rs));
                }
            }
        }
        return result;
    }

    public Register getRegister(int type, Calendar date, int tagID) throws SQLException {
        Register result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE dt=? AND type=? AND tid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ps.setInt(2, type);
            ps.setInt(3, tagID);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.loadRegisterFromRS(rs);
                }
            }
            ps.close();
        }
        return result;
    }

    public void deleteRegister(int id) throws SQLException {
        String query = "DELETE FROM gorod_register_item_" + this.moduleId + " WHERE rid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        query = "DELETE FROM " + this.tableName + " WHERE id=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private Register loadRegisterFromRS(ResultSet rs) throws SQLException {
        return new Register().setId(rs.getInt("id")).setDate(TimeUtils.convertDateToCalendar((Date)rs.getDate("dt"))).setType(rs.getInt("type")).setTagId(rs.getInt("tid"));
    }
}

