/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.common.worker.ThreadContext;

public final class TariffTreeNodeHolder {
    public final Long treeNodeId;
    public final int level;
    public final TariffTreeNode node;
    public final TariffTreeNodeHolder[] children;

    public TariffTreeNodeHolder(Long treeNodeId, int level, TariffTreeNode node, TariffTreeNodeHolder[] children) {
        this.treeNodeId = treeNodeId;
        this.level = level;
        this.node = node;
        this.children = children;
    }

    public int execute(Long parentTreeNodeId, AbstractTariffRequest<?> req, TariffContext context, TreeContext treeContext, ThreadContext workerContext) {
        return this.node.execute(this.treeNodeId, parentTreeNodeId, req, this, context, treeContext, workerContext);
    }

    int executeDebug(Long parentTreeNodeId, AbstractTariffRequest<?> req, TariffContext context, TreeContext treeContext, ThreadContext workerContext) {
        int result = this.node.execute(this.treeNodeId, parentTreeNodeId, req, this, context, treeContext, workerContext);
        if (req.isInfoEnabled()) {
            if (result == 1) {
                req.addInfo("OK: " + this.node.fingerprint + "\n");
            } else {
                req.addInfo("CANCEL: " + this.node.fingerprint + "\n");
            }
        }
        return result;
    }

    public void getNodeList(List<TariffTreeNodeHolder> result, Set<Class<?>> classes) {
        TariffTreeNodeHolder[] children = this.children;
        if (children != null) {
            for (TariffTreeNodeHolder child : children) {
                if (classes.contains(child.node.getClass())) {
                    result.add(child);
                }
                child.getNodeList(result, classes);
            }
        }
    }
}

