/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.ext.dhcp;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import ru.bitel.common.Utils;

public final class DHCPPacket
implements Comparator<DHCPOption> {
    protected static final byte ZERO = 0;
    public static final byte OP_BOOT_REQUEST = 1;
    public static final byte OP_BOOT_RESPONSE = 2;
    public static final int DHCP_DISCOVER = 1;
    public static final int DHCP_OFFER = 2;
    public static final int DHCP_REQUEST = 3;
    public static final int DHCP_DECLINE = 4;
    public static final int DHCP_ACK = 5;
    public static final int DHCP_NAK = 6;
    public static final int DHCP_RELEASE = 7;
    public static final int DHCP_INFORM = 8;
    private static final byte OPTION_END = -1;
    private static final byte OPTION_PADDING = 0;
    public static final byte OPTION_SUBNET_MASK = 1;
    public static final byte OPTION_TIME_OFFSET = 2;
    public static final byte OPTION_ROUTER = 3;
    public static final byte OPTION_TIME_SERVER = 4;
    public static final byte OPTION_NAME_SERVER = 5;
    public static final byte OPTION_DOMAIN_NAME_SERVER = 6;
    public static final byte OPTION_LOG_SERVER = 7;
    public static final byte OPTION_COOKIE_SERVER = 8;
    public static final byte OPTION_LPR_SERVER = 9;
    public static final byte OPTION_DOMAIN_NAME = 15;
    public static final byte OPTION_REQUESTED_IP_ADDRESS = 50;
    public static final byte OPTION_IP_ADDRESS_LEASE_TIME = 51;
    private static final byte OPTION_OVERLOAD = 52;
    private static final byte OPTION_DHCP_MESSAGE_TYPE = 53;
    public static final byte OPTION_SERVER_IDENTIFIER = 54;
    public static final byte OPTION_PARAMETER_REQUEST_LIST = 55;
    public static final byte OPTION_CLIENT_IDENTIDIER = 61;
    public static final byte OPTION_AGENT_INFORMATION = 82;
    public static final byte[] MAGIC_COOKIE;
    private static final String charsetName = "ISO-8859-1";
    private static final int DHCP_PACKET_LENGTH = 300;
    private static final DHCPSubOption[] nullSubOptions;
    public byte op;
    public byte htype;
    public byte hlen;
    public byte hops;
    public int xid;
    public short secs;
    public short flags;
    public byte[] ciaddr;
    public byte[] yiaddr;
    public byte[] siaddr;
    public byte[] giaddr;
    public byte[] chaddr;
    public byte[] sname;
    public byte[] file;
    public byte[] magicCookie;
    private DHCPOption[] options;
    private int optionsLength;
    public byte messageType;
    public DHCPSubOption optionAgentInformation;
    byte[] parameterRequestListOption;
    private static final Charset charset;

    public DHCPPacket() {
        this.ciaddr = new byte[4];
        this.yiaddr = new byte[4];
        this.siaddr = new byte[4];
        this.giaddr = new byte[4];
        this.chaddr = new byte[16];
        this.sname = new byte[64];
        this.file = new byte[128];
        this.magicCookie = new byte[4];
        this.options = new DHCPOption[12];
        this.optionsLength = 0;
    }

    private DHCPPacket(DHCPPacket request) {
        this.op = (byte)2;
        this.htype = request.htype;
        this.hlen = request.hlen;
        this.hops = request.hops;
        this.xid = request.xid;
        this.ciaddr = request.ciaddr;
        this.yiaddr = new byte[4];
        this.siaddr = new byte[4];
        this.giaddr = request.giaddr;
        this.chaddr = request.chaddr;
        this.sname = new byte[64];
        this.file = new byte[128];
        this.magicCookie = new byte[4];
        this.options = new DHCPOption[12];
        this.optionsLength = 0;
        DHCPOption reqParams = request.getOption((byte)55);
        if (reqParams != null) {
            this.parameterRequestListOption = reqParams.value;
        }
        this.optionAgentInformation = request.optionAgentInformation;
        this.setOption(this.optionAgentInformation);
    }

    public static DHCPPacket getDHCPPacket(ByteBuffer bb) {
        try {
            DHCPPacket packet = new DHCPPacket();
            packet.op = bb.get();
            packet.htype = bb.get();
            packet.hlen = bb.get();
            packet.hops = bb.get();
            packet.xid = bb.getInt();
            packet.secs = bb.getShort();
            packet.flags = bb.getShort();
            bb.get(packet.ciaddr);
            bb.get(packet.yiaddr);
            bb.get(packet.siaddr);
            bb.get(packet.giaddr);
            bb.get(packet.chaddr);
            bb.get(packet.sname);
            bb.get(packet.file);
            bb.get(packet.magicCookie);
            block13: while (bb.hasRemaining()) {
                byte[] value;
                String stringValue;
                byte code = bb.get();
                if (code == 0) continue;
                if (code == -1) break;
                int len = bb.get() & 0xFF;
                switch (code) {
                    case 53: {
                        packet.messageType = bb.get();
                        continue block13;
                    }
                    case 52: {
                        byte val = bb.get();
                        int pos = bb.position();
                        switch (val) {
                            case 1: {
                                bb.mark();
                                bb.position(bb.limit());
                                bb.put(packet.file);
                                bb.reset();
                                break;
                            }
                            case 2: {
                                bb.mark();
                                bb.position(bb.limit());
                                bb.put(packet.sname);
                                bb.reset();
                                break;
                            }
                            case 3: {
                                bb.mark();
                                bb.position(bb.limit());
                                bb.put(packet.sname);
                                bb.put(packet.file);
                                bb.reset();
                            }
                        }
                        bb.position(pos);
                    }
                    case 15: {
                        ByteBuffer b = bb.slice();
                        b.limit(len);
                        stringValue = charset.decode(b).toString();
                        value = new byte[len];
                        bb.get(value);
                        packet.setOption(code, value, stringValue);
                        continue block13;
                    }
                    case 82: {
                        DHCPPacket.readAgentInformation(bb, packet, code, len);
                        continue block13;
                    }
                }
                value = new byte[len];
                bb.get(value);
                stringValue = null;
                packet.setOption(code, value, stringValue);
            }
            return packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void readAgentInformation(ByteBuffer bb, DHCPPacket packet, byte code, int len) {
        byte[] value = new byte[len];
        bb.mark();
        bb.get(value);
        bb.reset();
        DHCPSubOption[] options = new DHCPSubOption[5];
        int scount = 0;
        int i = 0;
        while (i < len) {
            byte scode = bb.get();
            int slen = bb.get() & 0xFF;
            i += slen + 2;
            byte[] sval = new byte[slen];
            bb.get(sval);
            if (scount == options.length) {
                DHCPSubOption[] optionsNew = new DHCPSubOption[options.length * 2];
                System.arraycopy(options, 0, optionsNew, 0, options.length);
                options = optionsNew;
            }
            options[scount] = new DHCPSubOption(scode, sval, null, 0);
            ++scount;
        }
        packet.optionAgentInformation = new DHCPSubOption(code, value, options, scount);
        packet.setOption(packet.optionAgentInformation);
    }

    @Override
    public final int compare(DHCPOption o1, DHCPOption o2) {
        return this.getWeight(o1) - this.getWeight(o2);
    }

    private int getWeight(DHCPOption o) {
        if (o == null) {
            return 10000;
        }
        switch (o.code) {
            case 53: {
                return -10;
            }
            case 54: {
                return -9;
            }
            case 51: {
                return -8;
            }
        }
        for (int i = 0; i < this.parameterRequestListOption.length; ++i) {
            if (this.parameterRequestListOption[i] != o.code) continue;
            return i;
        }
        return 1000 + o.code;
    }

    public final byte[] serialize() {
        if (this.parameterRequestListOption != null) {
            Arrays.sort(this.options, this);
        }
        int len = 244;
        for (int i = 0; i < this.optionsLength; ++i) {
            len += this.options[i].value.length + 2;
        }
        if (len < 300) {
            len = 300;
        }
        byte[] result = new byte[len];
        result[0] = this.op;
        result[1] = this.htype;
        result[2] = this.hlen;
        result[3] = this.hops;
        result[4] = (byte)(this.xid >> 24);
        result[5] = (byte)(this.xid >> 16);
        result[6] = (byte)(this.xid >> 8);
        result[7] = (byte)(this.xid >> 0);
        result[8] = (byte)(this.secs >> 0);
        result[9] = (byte)(this.secs >> 8);
        result[10] = (byte)(this.flags >> 0);
        result[11] = (byte)(this.flags >> 8);
        System.arraycopy(this.ciaddr, 0, result, 12, 4);
        System.arraycopy(this.yiaddr, 0, result, 16, 4);
        System.arraycopy(this.siaddr, 0, result, 20, 4);
        System.arraycopy(this.giaddr, 0, result, 24, 4);
        System.arraycopy(this.chaddr, 0, result, 28, 16);
        System.arraycopy(this.sname, 0, result, 44, 64);
        System.arraycopy(this.file, 0, result, 108, 128);
        System.arraycopy(MAGIC_COOKIE, 0, result, 236, 4);
        int pos = 240;
        result[pos++] = 53;
        result[pos++] = 1;
        result[pos++] = this.messageType;
        for (int i = 0; i < this.optionsLength; ++i) {
            DHCPOption o = this.options[i];
            result[pos++] = o.code;
            result[pos++] = (byte)o.value.length;
            System.arraycopy(o.value, 0, result, pos, o.value.length);
            pos += o.value.length;
        }
        result[pos++] = -1;
        while (pos < 300) {
            result[pos++] = 0;
        }
        return result;
    }

    public final void setOption(DHCPOption option) {
        if (option == null) {
            return;
        }
        for (int i = 0; i < this.optionsLength; ++i) {
            if (this.options[i].code != option.code) continue;
            this.options[i] = option;
            return;
        }
        if (this.optionsLength == this.options.length) {
            DHCPOption[] newOptions = new DHCPOption[this.options.length * 2];
            System.arraycopy(this.options, 0, newOptions, 0, this.options.length);
            this.options = newOptions;
        }
        this.options[this.optionsLength++] = option;
    }

    public final void setOption(byte code, byte[] value) {
        this.setOption(new DHCPOption(code, value));
    }

    private final void setOption(byte code, byte[] value, String stringValue) {
        this.setOption(new DHCPOption(code, value, stringValue));
    }

    public final DHCPOption getOption(byte code) {
        return DHCPPacket.findOption(this.options, this.optionsLength, code);
    }

    private static final DHCPOption findOption(DHCPOption[] options, int optionsLength, byte code) {
        for (int i = 0; i < optionsLength; ++i) {
            if (options[i].code != code) continue;
            return options[i];
        }
        return null;
    }

    private static final DHCPSubOption findOption(DHCPSubOption[] options, int optionsLength, byte code) {
        for (int i = 0; i < optionsLength; ++i) {
            if (options[i].code != code) continue;
            return options[i];
        }
        return null;
    }

    public final DHCPPacket createResponse() {
        return new DHCPPacket(this);
    }

    public final boolean isFromRelayAgent() {
        for (int i = 0; i < this.giaddr.length; ++i) {
            if (this.giaddr[i] == 0) continue;
            return true;
        }
        return false;
    }

    public final boolean isClientAddressSet() {
        for (int i = 0; i < this.ciaddr.length; ++i) {
            if (this.ciaddr[i] == 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("op=").append(this.op).append("; htype=").append(this.htype);
        sb.append("; hlen=").append(this.hlen).append("; hops=").append(this.hops);
        sb.append("; xid=").append(Utils.bytesToString((byte[])Utils.convertIntToBytes((int)this.xid)));
        sb.append("; secs=").append(this.secs).append("; flags=").append(this.flags);
        return sb.toString();
    }

    public String getMessageTypeString() {
        switch (this.messageType) {
            case 1: {
                return "DHCPDISCOVER";
            }
            case 2: {
                return "DHCPOFFER";
            }
            case 3: {
                return "DHCPREQUEST";
            }
            case 4: {
                return "DHCPDECLINE";
            }
            case 5: {
                return "DHCPACK";
            }
            case 6: {
                return "DHCPNAK";
            }
            case 7: {
                return "DHCPRELEASE";
            }
            case 8: {
                return "DHCPINFORM";
            }
        }
        return "INKNOWN";
    }

    static {
        Charset ch;
        MAGIC_COOKIE = new byte[]{99, -126, 83, 99};
        nullSubOptions = new DHCPSubOption[0];
        try {
            ch = Charset.forName(charsetName);
        }
        catch (Exception e) {
            ch = null;
            e.printStackTrace();
        }
        charset = ch;
    }

    public static class DHCPOption {
        public final byte code;
        public final byte[] value;
        public final String stringValue;

        public DHCPOption(byte code, byte[] value) {
            this.code = code;
            this.value = value;
            this.stringValue = null;
        }

        public DHCPOption(byte code, byte[] value, String stringValue) {
            this.code = code;
            this.value = value;
            this.stringValue = stringValue;
        }

        public DHCPOption(byte code, String stringValue) throws Exception {
            this.code = code;
            this.value = stringValue.getBytes(DHCPPacket.charsetName);
            this.stringValue = stringValue;
        }

        public final byte getFirst() {
            return this.value.length > 0 ? this.value[0] : (byte)0;
        }

        public int hashCode() {
            return this.code;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DHCPOption other = (DHCPOption)obj;
            return this.code == other.code;
        }
    }

    public static final class DHCPSubOption
    extends DHCPOption {
        public final DHCPSubOption[] subOptions;
        public final int subOptionsLength;

        public DHCPSubOption(byte code, byte[] value) {
            super(code, value);
            this.subOptions = nullSubOptions;
            this.subOptionsLength = 0;
        }

        private DHCPSubOption(byte code, byte[] value, DHCPSubOption[] subOptions, int subOptionsLength) {
            super(code, value);
            this.subOptions = subOptions;
            this.subOptionsLength = subOptionsLength;
        }

        public DHCPSubOption getSubOption(byte code) {
            return DHCPPacket.findOption(this.subOptions, this.subOptionsLength, code);
        }
    }

    public static class DHCPMessageTypeOption {
        public final byte code;
        public final byte value;

        public DHCPMessageTypeOption(byte code, byte value) {
            this.code = code;
            this.value = value;
        }
    }
}

