/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.runner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.client.runner.BGClientRunnerCipher;
import ru.bitel.bgbilling.client.runner.BGClientRunnerDbInfo;
import ru.bitel.bgbilling.client.runner.BGClientRunnerUtil;
import ru.bitel.bgbilling.client.runner.json.JSONArray;
import ru.bitel.bgbilling.client.runner.json.JSONObject;

public class BGClientRunnerDbInfoManager
implements Comparator<BGClientRunnerDbInfo> {
    private boolean debug = false;
    private boolean anySSL = false;
    private String configURL = null;
    private String defaultServerKey = null;
    private String serversListMode = "all";
    private static BGClientRunnerDbInfoManager manager;
    private Map<String, BGClientRunnerDbInfo> servers = new HashMap<String, BGClientRunnerDbInfo>();

    public static BGClientRunnerDbInfoManager getManager() {
        if (manager == null) {
            manager = new BGClientRunnerDbInfoManager();
        }
        return manager;
    }

    private BGClientRunnerDbInfoManager() {
        this.debug = Boolean.parseBoolean(System.getProperty("debug", "false"));
        this.parseServersConfig();
    }

    private void parseServersConfig() {
        try {
            this.parseConfig(BGClientRunnerUtil.loadDefaultConfig(), "config");
        }
        catch (Exception e) {
            System.err.println("Error load DefaultConfig! [" + e.getLocalizedMessage() + "]");
            e.printStackTrace();
        }
        try {
            this.parseConfig(BGClientRunnerUtil.loadDefaultHttpConfig(this.configURL, "http://billing.local/servers.json", this.anySSL), "server");
        }
        catch (Exception e) {
            System.err.println("Error load DefaultHttpConfig! [" + e.getLocalizedMessage() + "]");
            e.printStackTrace();
        }
        try {
            this.parseConfig(BGClientRunnerUtil.loadServersConfig(), "user");
            this.loadDBInfoFromProperties();
        }
        catch (Exception e) {
            System.err.println("Error load ServersConfig! [" + e.getLocalizedMessage() + "]");
            e.printStackTrace();
        }
    }

    private void parseConfig(String serversConfig, String dbServerType) {
        if (serversConfig != null && serversConfig.length() > 0) {
            JSONObject serversJsonObject = new JSONObject(serversConfig);
            if (serversJsonObject.has("param")) {
                JSONObject serversParamJSONObject = serversJsonObject.getJSONObject("param");
                this.defaultServerKey = this.getJSONObjectValue(serversParamJSONObject, "defaultServerKey", this.defaultServerKey);
                this.serversListMode = this.getJSONObjectValue(serversParamJSONObject, "serversListMode", this.serversListMode);
                this.configURL = this.getJSONObjectValue(serversParamJSONObject, "configURL", this.configURL);
                this.anySSL = Boolean.valueOf(this.getJSONObjectValue(serversParamJSONObject, "anySSL", String.valueOf(this.anySSL)));
            }
            if (serversJsonObject.has("servers")) {
                JSONArray serversJSONArray = serversJsonObject.getJSONArray("servers");
                for (int index = 0; index < serversJSONArray.length(); ++index) {
                    try {
                        BGClientRunnerDbInfo dbInfoOld;
                        if (this.debug) {
                            System.out.println(dbServerType + ": index = " + index);
                        }
                        JSONObject dbInfoJSONObject = serversJSONArray.getJSONObject(index);
                        if (this.debug) {
                            System.out.println(dbServerType + ": dbInfoJSONObject = " + dbInfoJSONObject.toString());
                        }
                        BGClientRunnerDbInfo dbInfo = BGClientRunnerDbInfo.parseBGClientRunnerDbInfoFromJson(dbInfoJSONObject);
                        if (this.debug) {
                            System.out.println(dbServerType + ": dbInfo = " + String.valueOf(dbInfo));
                            System.out.println(dbServerType + ": dbInfo.getDbServerKey() = " + dbInfo.getDbServerKey());
                            System.out.println(dbServerType + ": dbInfo.getDbServerType() = " + dbInfo.getDbServerType());
                            System.out.println(dbServerType + ": dbInfo.getDbServerLogin() = " + dbInfo.getDbServerLogin());
                        }
                        if (dbInfo.getDbServerType() == null) {
                            dbInfo.setDbServerType(dbServerType);
                        }
                        if ((dbInfoOld = this.servers.get(dbInfo.getDbServerKey())) != null && !dbInfoOld.getDbServerType().equals("user")) {
                            if (this.debug) {
                                System.out.println(dbServerType + ": dbInfoOld = " + String.valueOf(dbInfoOld));
                                System.out.println(dbServerType + ": dbInfoOld.getDbServerType() = " + dbInfoOld.getDbServerType());
                                System.out.println(dbServerType + ": dbInfoOld.getDbServerLogin() = " + dbInfoOld.getDbServerLogin());
                            }
                            dbInfoOld.setDbServerLogin(dbInfo.getDbServerLogin());
                            dbInfoOld.setDbServerPassword(dbInfo.getDbServerPassword());
                            dbInfoOld.setDbServerProxyHost(dbInfo.getDbServerProxyHost());
                            dbInfoOld.setDbServerProxyPort(dbInfo.getDbServerProxyPort());
                            dbInfoOld.setDbServerVMArgs(dbInfo.getDbServerVMArgs());
                            dbInfoOld.setFavorite(dbInfo.isFavorite());
                            dbInfoOld.setSaveAccount(dbInfo.isSaveAccount());
                            continue;
                        }
                        if (this.debug) {
                            System.out.println(dbServerType + ": Add to servers = " + String.valueOf(dbInfo));
                        }
                        this.servers.put(dbInfo.getDbServerKey(), dbInfo);
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println("Error load server #" + index + " from config (" + dbServerType + ")!");
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private String getJSONObjectValue(JSONObject jsonObject, String key, String defaultValue) {
        return jsonObject != null && jsonObject.has(key) ? jsonObject.getString(key) : defaultValue;
    }

    public void setDefaultServerKey(String defaultServerKey) {
        this.defaultServerKey = defaultServerKey;
    }

    public String getDefaultServerKey() {
        return this.defaultServerKey;
    }

    public void setServersListMode(String serversListMode) {
        this.serversListMode = serversListMode;
    }

    public boolean isAnySSL() {
        return this.anySSL;
    }

    public void setAnySSL(boolean anySSL) {
        this.anySSL = anySSL;
    }

    public String getConfigURL() {
        return this.configURL;
    }

    public void setConfigURL(String configURL) {
        this.configURL = configURL;
    }

    public void addServer(BGClientRunnerDbInfo info) {
        this.servers.put(info.getDbServerKey(), info);
    }

    public void removeServer(BGClientRunnerDbInfo info) {
        this.servers.remove(info.getDbServerKey());
        this.removeServerFromUserConfig(info.getDbServerKey());
        BGClientRunnerUtil.saveServersConfig(this.getInfoLists(), this.getDefaultServerKey(), this.getServersListMode(), this.isAnySSL());
    }

    public String getServersListMode() {
        return this.serversListMode != null ? this.serversListMode : "all";
    }

    public BGClientRunnerDbInfo getBGClientRunnerDbInfo(String key) {
        return key != null ? this.servers.get(key) : null;
    }

    public List<BGClientRunnerDbInfo> getInfoLists() {
        ArrayList<BGClientRunnerDbInfo> result = new ArrayList<BGClientRunnerDbInfo>();
        for (Map.Entry<String, BGClientRunnerDbInfo> entry : this.servers.entrySet()) {
            result.add(entry.getValue());
        }
        Collections.sort(result, this);
        return result;
    }

    public List<BGClientRunnerDbInfo> geInfoLists(boolean favorite) {
        List<BGClientRunnerDbInfo> allList = this.getInfoLists();
        ArrayList<BGClientRunnerDbInfo> result = new ArrayList<BGClientRunnerDbInfo>();
        if (favorite) {
            result.addAll(allList.stream().filter(w -> w.isFavorite()).collect(Collectors.toList()));
        } else {
            result.addAll(allList.stream().filter(w -> !w.isFavorite()).collect(Collectors.toList()));
        }
        return result;
    }

    private Map<String, String> loadUserConfig() {
        HashMap<String, String> properties = new HashMap<String, String>();
        File file = BGClientRunnerUtil.getLocalSettingsFile();
        if (file != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    int pos = line.indexOf(61);
                    if (pos < 0 && pos >= line.length()) continue;
                    properties.put(line.substring(0, pos), line.substring(pos + 1));
                }
                reader.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return properties;
    }

    private void loadDBInfoFromProperties() {
        Matcher m;
        Map<String, String> preferences = this.loadUserConfig();
        if (this.defaultServerKey == null) {
            this.defaultServerKey = preferences.getOrDefault("db.server.default.key", this.defaultServerKey);
        }
        HashMap<String, String> serversMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : preferences.entrySet()) {
            if (!entry.getKey().startsWith("db.server.")) continue;
            serversMap.put(entry.getKey().substring(10), entry.getValue());
        }
        Pattern pattern = Pattern.compile("^([\\d\\w]+)\\.(info|title)$");
        for (Map.Entry entry : serversMap.entrySet()) {
            m = pattern.matcher((CharSequence)entry.getKey());
            if (!m.find()) continue;
            this.addServer(m.group(1), serversMap);
        }
        pattern = Pattern.compile("^([\\d\\w]+)\\.(s*auth)$");
        for (Map.Entry entry : serversMap.entrySet()) {
            m = pattern.matcher((CharSequence)entry.getKey());
            if (!m.find()) continue;
            this.updateServer(m.group(1), (String)serversMap.get(m.group(1) + ".auth"), (String)serversMap.get(m.group(1) + ".sauth"));
        }
    }

    private void addServer(String key, Map<String, String> serversMap) {
        String val;
        boolean favorite;
        BGClientRunnerDbInfo info = this.servers.get(key);
        if (info != null) {
            return;
        }
        info = new BGClientRunnerDbInfo();
        this.servers.put(key, info);
        String value = serversMap.get(key + ".info");
        if (value != null) {
            String[] values = value.split("\t");
            int idx = 0;
            String title = values[idx++];
            String url = values[idx++];
            String proxy = "";
            String port = "";
            favorite = false;
            if (idx < values.length) {
                proxy = values[idx++];
            }
            if (idx < values.length) {
                port = values[idx++];
            }
            if (idx < values.length) {
                favorite = (val = values[idx++]).equals("1") || val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("on");
            }
            info.setDbServerKey(key);
            info.setDbServerTitle(title);
            info.setDbServerURL(url);
            info.setDbServerProxyHost(proxy);
            info.setDbServerProxyPort(port);
            info.setFavorite(favorite);
        }
        String auth = serversMap.get(key + ".auth");
        String sauth = serversMap.get(key + ".sauth");
        if (sauth != null) {
            auth = BGClientRunnerCipher.cipher(sauth, true);
        }
        if (auth != null) {
            String[] values = auth.split("\t", -1);
            int idx = 0;
            String login = values[idx++];
            String password = values[idx++];
            favorite = false;
            if (values.length > 3) {
                favorite = (val = values[++idx]).equals("1") || val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("on");
            }
            info.setDbServerLogin(login);
            info.setDbServerPassword(password);
            info.setFavorite(favorite);
            info.setSaveAccount(info.getDbServerLogin() != null && !info.getDbServerLogin().isEmpty());
        }
    }

    private void updateServer(String key, String auth, String sauth) {
        BGClientRunnerDbInfo info = this.servers.get(key);
        if (info != null && (info.getDbServerLogin() == null || info.getDbServerLogin().isEmpty())) {
            if (sauth != null) {
                auth = BGClientRunnerCipher.cipher(sauth, true);
            }
            if (auth != null) {
                String[] values = auth.split("\t", -1);
                int idx = 0;
                String login = values[idx++];
                String password = values[idx++];
                boolean favorite = false;
                if (values.length > 3) {
                    String val;
                    favorite = (val = values[++idx]).equals("1") || val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("on");
                }
                info.setDbServerLogin(login);
                info.setDbServerPassword(password);
                info.setFavorite(favorite);
            }
        }
    }

    private void removeServerFromUserConfig(String serverKey) {
        Map<String, String> preferences = this.loadUserConfig();
        boolean change = false;
        HashMap<String, String> preferencesNew = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : preferences.entrySet()) {
            if (!entry.getKey().startsWith("db.server." + serverKey + ".info") && !entry.getKey().startsWith("db.server." + serverKey + ".sauth")) {
                preferencesNew.put(entry.getKey(), entry.getValue());
                continue;
            }
            change = true;
        }
        if (change) {
            this.saveUserConfig(preferencesNew);
        }
    }

    public void saveUserConfig(Map<String, String> properties) {
        File file = BGClientRunnerUtil.getLocalSettingsFile();
        if (file != null && file.canWrite()) {
            try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
                if (properties != null) {
                    ArrayList<String> keys = new ArrayList<String>();
                    for (Map.Entry<String, String> e : properties.entrySet()) {
                        keys.add(e.getKey());
                    }
                    Collections.sort(keys);
                    for (String key : keys) {
                        fileWriter.write(String.format("%s=%s\n", key, properties.get(key)));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int compare(BGClientRunnerDbInfo dbInfo1, BGClientRunnerDbInfo dbInfo2) {
        int result = -1;
        if (dbInfo1.getDbServerTitle() != null && dbInfo2.getDbServerTitle() != null) {
            result = dbInfo1.getDbServerTitle().compareTo(dbInfo2.getDbServerTitle());
        } else if (dbInfo2.getDbServerTitle() != null) {
            result = 1;
        }
        return result;
    }
}

