/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.server.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderBase;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServTypeDao;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class LoaderImportInetServUtil
extends LoaderBase {
    @Override
    public String execute(String data, String config) throws Exception {
        JSONObject configJsonObject = new JSONObject(config);
        int moduleId = configJsonObject.getInt("moduleId");
        int inetServTypeId = configJsonObject.getInt("inetServTypeId");
        StringBuffer result = new StringBuffer();
        try (InetServDao inetServDao = new InetServDao(this.con, moduleId);
             ContractDao contractDao = new ContractDao(this.con, 0);
             InetServTypeDao inetServTypeDao = new InetServTypeDao(this.con, moduleId);){
            InetServService inetServService = this.context.getService(InetServService.class, moduleId);
            InetServType inetServType = (InetServType)inetServTypeDao.get(inetServTypeId);
            int deviceId = new Preferences(inetServType.getConfig(), "\n").getInt("const.device.id", 0);
            DateTimeFormatter timeFormatter = DateTimeFormatter.ISO_LOCAL_DATE;
            int count = 0;
            for (String line : data.split("\n")) {
                InetServData inetServData = new InetServData(this);
                AtomicReference<Integer> index = new AtomicReference<Integer>(3);
                String[] lineData = line.split("\t");
                if (this.setConract(line, lineData, inetServData, contractDao, result) || this.setDateFrom(line, lineData, inetServData, timeFormatter, result) || this.setSessionCount(line, lineData, inetServData, result) || inetServType.isNeedLogin() && this.setLoginPassword(line, lineData, inetServData, result, index)) continue;
                List inetServs = inetServDao.list(inetServData.contractId);
                if (inetServs == null || inetServs.isEmpty()) {
                    this.addInetServ(inetServData, inetServTypeId, deviceId, inetServService);
                } else {
                    boolean add = true;
                    for (InetServ inetServ : inetServs) {
                        if (inetServ.getTypeId() != inetServTypeId) continue;
                        add = false;
                        break;
                    }
                    if (!add) {
                        result.append("\u041f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c => " + line + " => \u043f\u043e\u0432\u0442\u043e\u0440\n");
                        continue;
                    }
                    try {
                        this.addInetServ(inetServData, inetServTypeId, deviceId, inetServService);
                    }
                    catch (Exception ex) {
                        result.append("\u041f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c => " + line + " => " + ex.getMessage() + "\n");
                        --count;
                    }
                }
                this.context.commit();
                ++count;
            }
            result.insert(0, "\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 -> " + count + "\n\n");
        }
        return result.toString();
    }

    private void addInetServ(InetServData inetServData, int inetServTypeId, int deviceId, InetServService inetServService) throws Exception {
        InetServ inetServ = new InetServ().setContractId(inetServData.contractId).setTypeId(inetServTypeId).setDeviceId(deviceId).setDateFrom(TimeUtils.convertLocalDateToDate((LocalDate)inetServData.dateFrom)).setSessionCountLimit(inetServData.sessionCount).setLogin(inetServData.login).setPassword(inetServData.password);
        inetServService.inetServUpdate(inetServ, null, false, false, 1000L);
    }

    private boolean setConract(String line, String[] lineData, InetServData inetServData, ContractDao contractDao, StringBuffer result) throws BGException {
        if (lineData.length > 0) {
            Contract contract = contractDao.getByTitle(lineData[0]);
            if (contract == null) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \"" + lineData[0] + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\n");
                return true;
            }
            inetServData.contractId = contract.getId();
            return false;
        }
        result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 => " + line + "\n");
        return true;
    }

    private boolean setDateFrom(String line, String[] lineData, InetServData inetServData, DateTimeFormatter timeFormatter, StringBuffer result) throws BGException {
        if (lineData.length > 1) {
            try {
                inetServData.dateFrom = LocalDate.parse(lineData[1], timeFormatter);
                return false;
            }
            catch (Exception ex) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u0434\u0430\u0442\u044b \"" + lineData[1] + "\"\n");
                return true;
            }
        }
        result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 => " + line + "\n");
        return true;
    }

    private boolean setSessionCount(String line, String[] lineData, InetServData inetServData, StringBuffer result) throws BGException {
        if (lineData.length > 2) {
            try {
                inetServData.sessionCount = Integer.parseInt(lineData[2]);
                return false;
            }
            catch (Exception ex) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0435\u0441\u0441\u0438\u0439 \"" + lineData[2] + "\"\n");
                return true;
            }
        }
        result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 => " + line + "\n");
        return true;
    }

    private boolean setLoginPassword(String line, String[] lineData, InetServData inetServData, StringBuffer result, AtomicReference<Integer> index) throws BGException {
        if (lineData.length > index.get() + 1) {
            try {
                inetServData.login = lineData[index.get()];
                index.set(index.get() + 1);
                inetServData.password = lineData[index.get()];
                index.set(index.get() + 1);
                return false;
            }
            catch (Exception ex) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043b\u043e\u0433\u0438\u043d\u0430/\u043f\u0430\u0440\u043e\u043b\u044f \"" + lineData[index.get()] + "\"\n");
                return true;
            }
        }
        result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 => " + line + "\n");
        return true;
    }

    class InetServData {
        int contractId;
        LocalDate dateFrom;
        int sessionCount = 0;
        String login;
        String password;

        InetServData(LoaderImportInetServUtil this$0) {
        }
    }
}

