/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.action.web;

import java.math.BigDecimal;
import java.util.ArrayList;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseCopy;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrder;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderBillData;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderConfirmed;
import ru.bitel.bgbilling.modules.license.server.action.web.ActionOrders;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;
import ru.bitel.bgbilling.modules.license.server.utils.LicenseUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class ActionGetBills
extends ActionOrders {
    @Override
    public void doAction() throws Exception {
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        int billsCount = 0;
        BigDecimal totalPaySum = BigDecimal.ZERO;
        int ordersCount = this.req.getInt("ordersCount", -1);
        ArrayList<Integer> processedIds = new ArrayList<Integer>();
        this.setResultParam("bills", processedIds);
        int selectedCopyId = this.req.getInt("copyId", -1);
        for (int i = 1; i <= ordersCount; ++i) {
            LicenseOrder order;
            int selectedOrderId = this.req.getInt("chbx_" + i, -1);
            if (selectedOrderId <= 0 || (order = licenseManager.getOrder(selectedOrderId)) == null) continue;
            LicenseCopy copy = licenseManager.getCopy(order.getCopyId());
            String productVersion = copy.getProductVersion();
            int productItemId = order.getComponentId();
            if (processedIds.contains(productItemId)) continue;
            processedIds.add(productItemId);
            LicenseOrderConfirmed grouppedConfirmedItem = licenseManager.groupCopyItems(productItemId, selectedCopyId, new int[]{2, 3});
            LicenseOrderConfirmed grouppedNewItem = licenseManager.groupCopyItems(productItemId, selectedCopyId, new int[]{0});
            if (grouppedConfirmedItem == null && grouppedNewItem == null) continue;
            String productItemName = new String();
            Integer confirmedItemsCount = null;
            if (grouppedConfirmedItem != null) {
                confirmedItemsCount = grouppedConfirmedItem.getCount();
                productItemName = grouppedConfirmedItem.getComponentName();
            }
            Integer newItemsCount = null;
            if (grouppedNewItem != null) {
                newItemsCount = grouppedNewItem.getCount();
                productItemName = grouppedNewItem.getComponentName();
            }
            LicenseOrderBillData addCostItem = LicenseUtils.getCostDelta(productItemName, confirmedItemsCount, newItemsCount, productVersion, (Preferences)this.moduleSetup);
            totalPaySum = totalPaySum.add(addCostItem.getCostDelta());
            ++billsCount;
        }
        this.setResultParam("billsCount", String.valueOf(billsCount));
        this.setResultParam("totalPaySum", Utils.formatCost((BigDecimal)totalPaySum));
    }
}

