/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.packer.server.service;

import jakarta.jws.WebService;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.packer.common.bean.PackerKit;
import ru.bitel.bgbilling.plugins.packer.common.bean.PackerOptionLibrary;
import ru.bitel.bgbilling.plugins.packer.common.service.PackerService;
import ru.bitel.bgbilling.plugins.packer.server.bean.PackerKitDao;
import ru.bitel.bgbilling.plugins.packer.server.bean.PackerOptionLibraryDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.packer.common.service.PackerService")
public class PackerServiceImpl
extends AbstractService
implements PackerService {
    private PackerKitDao packerKitDao;
    private PackerOptionLibraryDao packerOptionLibraryDao;

    public List<PackerKit> packerKitList() throws BGException {
        try (PackerKitDao packerKitDao = this.getPackerKitDao();){
            List<PackerKit> list = packerKitDao.list();
            return list;
        }
    }

    public PackerKit packerKitGet(int packerKitId) throws BGException {
        try (PackerKitDao packerKitDao = this.getPackerKitDao();){
            PackerKit packerKit = (PackerKit)packerKitDao.get(packerKitId);
            return packerKit;
        }
    }

    public int packerKitUpdate(PackerKit packerKit) throws BGException {
        return (Integer)this.tryReturn(() -> {
            try (PackerKitDao packerKitDao = this.getPackerKitDao();){
                packerKitDao.update(packerKit);
                Integer n = packerKit.getId();
                return n;
            }
        });
    }

    public int packerKitDelete(int packerKitId) throws BGException {
        return (Integer)this.tryReturn(() -> {
            try (PackerKitDao packerKitDao = this.getPackerKitDao();){
                Integer n = packerKitDao.delete(packerKitId);
                return n;
            }
        });
    }

    public SearchResult<PackerOptionLibrary> searchPackerOptionLibraryList(String title, Page page) throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult searchResult = new SearchResult(page);
            this.getPackerOptionLibraryDao().searchPackerOptionLibraryList((SearchResult<PackerOptionLibrary>)searchResult, title);
            return searchResult;
        });
    }

    public void packerOptionLibraryUpdate(PackerOptionLibrary packerOptionLibrary) throws BGException {
        this.tryCall(() -> this.getPackerOptionLibraryDao().update(packerOptionLibrary));
    }

    public void packerOptionLibraryDelete(int packerOptionLibraryId) throws BGException {
        this.tryCall(() -> this.getPackerOptionLibraryDao().delete(packerOptionLibraryId));
    }

    private PackerOptionLibraryDao getPackerOptionLibraryDao() {
        this.packerOptionLibraryDao = new PackerOptionLibraryDao(this.getConnection());
        return Optional.ofNullable(this.packerOptionLibraryDao).orElse(this.packerOptionLibraryDao);
    }

    private PackerKitDao getPackerKitDao() {
        this.packerKitDao = new PackerKitDao(this.getConnection());
        return Optional.ofNullable(this.packerKitDao).orElse(this.packerKitDao);
    }
}

