/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import jakarta.jws.WebService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDeviceType;
import ru.bitel.bgbilling.modules.voice.common.event.VoiceDeviceManageEvent;
import ru.bitel.bgbilling.modules.voice.common.mediation.Mediator;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDeviceService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceDeviceDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceDeviceMap;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceDeviceTypeDao;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceDevicesReloadEvent;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceSessionFinishDeviceEvent;
import ru.bitel.common.model.Id;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceTypeDao;
import ru.bitel.oss.systems.inventory.resource.server.service.AbstractDeviceServiceImpl;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceDeviceService")
public class VoiceDeviceServiceImpl
extends AbstractDeviceServiceImpl<VoiceDevice, VoiceDeviceType>
implements VoiceDeviceService {
    private VoiceDeviceTypeDao voiceDeviceTypeDao;
    private VoiceDeviceDao voiceDeviceDao;
    private Directory<VoiceDeviceType> voiceDeviceTypeDirectory;

    public List<VoiceDevice> voiceDeviceSourceList() throws BGException {
        return this.getDeviceDao().listSource();
    }

    public List<VoiceDevice> voiceDeviceRadiusList() throws BGException {
        return this.getDeviceDao().listNas();
    }

    public VoiceDevice deviceGet(int deviceId) throws BGException {
        return (VoiceDevice)this.getDeviceDao().get(deviceId);
    }

    public int deviceUpdate(VoiceDevice device) throws BGException {
        return (Integer)this.tryReturn(() -> {
            VoiceDeviceType voiceDeviceType;
            if (device.getDeviceTypeId() == -1 && (voiceDeviceType = (VoiceDeviceType)this.voiceDeviceTypeDirectory.get(device.getDeviceTypeId())) == null) {
                voiceDeviceType = new VoiceDeviceType();
                voiceDeviceType.setId(-1);
                voiceDeviceType.setTitle("\u041f\u0430\u043f\u043a\u0430");
                this.voiceDeviceTypeDirectory.update((Id)voiceDeviceType);
            }
            this.getDeviceDao().update((Entity)device);
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceDevicesReloadEvent(this.moduleId, this.userId));
            return device.getId();
        });
    }

    public void deviceDelete(int id) throws BGException {
        this.tryCall(() -> {
            super.deviceDelete(id);
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceDevicesReloadEvent(this.moduleId, this.userId));
        });
    }

    public VoiceDeviceType deviceTypeGet(int deviceTypeId) throws BGException {
        return (VoiceDeviceType)this.context.getDirectory(VoiceDeviceType.class, this.moduleId).get(deviceTypeId);
    }

    public int deviceTypeUpdate(VoiceDeviceType deviceType) throws BGException {
        return (Integer)this.tryReturn(() -> {
            int result = super.deviceTypeUpdate((DeviceType)deviceType);
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceDevicesReloadEvent(this.moduleId, this.userId));
            return result;
        });
    }

    public void deviceTypeDelete(int deviceTypeId) throws BGException {
        this.tryCall(() -> {
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceDevicesReloadEvent(this.moduleId, this.userId));
            super.deviceTypeDelete(deviceTypeId);
        });
    }

    public String getMediationIface() throws BGException {
        return Mediator.class.getCanonicalName();
    }

    public String deviceConfigPreview(int id) throws BGException {
        return (String)this.tryReturn(() -> {
            VoiceDeviceMap deviceMap = VoiceDeviceMap.getInstance(this.moduleId);
            VoiceDeviceMap.VoiceDeviceMapItem device = deviceMap.get(id);
            if (device == null) {
                return "";
            }
            return String.valueOf(device.getConfig());
        });
    }

    protected Directory<VoiceDeviceType> getDeviceTypeDirectory() throws BGException {
        if (this.voiceDeviceTypeDirectory == null) {
            this.voiceDeviceTypeDirectory = this.context.getDirectory(VoiceDeviceType.class, this.moduleId);
        }
        return this.voiceDeviceTypeDirectory;
    }

    protected VoiceDeviceDao getDeviceDao() throws BGException {
        if (this.voiceDeviceDao == null) {
            this.voiceDeviceDao = new VoiceDeviceDao(this.getConnection(), this.moduleId, this.userId);
        }
        return this.voiceDeviceDao;
    }

    protected DeviceTypeDao<VoiceDeviceType> getDeviceTypeDao() throws BGException {
        if (this.voiceDeviceTypeDao == null) {
            this.voiceDeviceTypeDao = new VoiceDeviceTypeDao(this.getConnection(), this.moduleId);
        }
        return this.voiceDeviceTypeDao;
    }

    public void finishSessions(int deviceId) throws BGException {
        EventProcessor.getInstance().publish((Event)new VoiceSessionFinishDeviceEvent(this.moduleId, this.userId, deviceId));
    }

    public boolean deviceTreeReorder(int srcDeviceId, int tgtDeviceId, int step) throws BGException {
        return false;
    }

    public String deviceManage(int id, String operation, int servId, int connectionId, long timeout) throws BGException, BGMessageException, BGIllegalAccessException {
        timeout = timeout <= 0L ? 30000L : Math.max(Math.min(timeout, TimeUnit.MINUTES.toMillis(5L)), TimeUnit.SECONDS.toMillis(10L));
        VoiceDeviceManageEvent e = new VoiceDeviceManageEvent(this.moduleId, this.userId, id, operation, servId, connectionId);
        e = (VoiceDeviceManageEvent)EventProcessor.getInstance().request((Event)e, 20000L);
        if (e == null) {
            throw new BGMessageException("\u0418\u0441\u0442\u0435\u043a\u043b\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e Access \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0438\u043b\u0438 \u0437\u0430\u043d\u044f\u0442.");
        }
        return String.valueOf(e.getResult());
    }
}

