/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.server.event.worker;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Optional;
import org.json.JSONObject;
import org.slf4j.MDC;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.YoomoneyPaymentType;
import ru.bitel.bgbilling.modules.yoomoney.server.event.YoomoneyAutopaymentEvent;
import ru.bitel.bgbilling.modules.yoomoney.server.event.YoomoneyCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.Utils;

public class YoomoneyAutopaymentEventWorker
extends EventWorker {
    private TransactionManager transactionManager;
    private AutopaymentManager autopaymentManager;
    private long sleepTimeout = 500L;

    public YoomoneyAutopaymentEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), YoomoneyAutopaymentEvent.class, moduleId, -1, null);
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 60000L;
        this.sleepTimeout = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)).getLong("yoomoney.autopayment.event.worker.sleep.timeout", 500L);
        this.getLogger().info("Starting YoomoneyAutopaymentEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "yoomoney-autopayment-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.autopaymentManager = new AutopaymentManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        return this.doTasks();
    }

    public Object doTask(Object task) throws BGException {
        YoomoneyAutopaymentEvent event = (YoomoneyAutopaymentEvent)((Object)task);
        int contractId = event.getContractId();
        MDC.put((String)"module", (String)"yoomoney");
        MDC.put((String)"moduleId", (String)String.valueOf(this.moduleId));
        MDC.put((String)"contractId", (String)String.valueOf(contractId));
        try {
            Autopayment autopayment = this.autopaymentManager.getCurrentAutopayment(contractId);
            if (autopayment != null) {
                Contract contract;
                BigDecimal sum = Optional.ofNullable(event.getSum()).orElse(autopayment.getSum());
                this.getLogger().debug("eventSum = {}; autopayment.getSumm = {}; sum = {}", new Object[]{event.getSum(), autopayment.getSum(), sum});
                this.getLogger().debug("autopayment.getMode() = {}; event.getMode() = {}", (Object)autopayment.getMode(), (Object)event.getMode());
                if (autopayment.getMode() == event.getMode() && (contract = ContractDao.getContract((Connection)((EventListenerContext)this.context).getConnection(), (int)contractId)) != null) {
                    this.getLogger().debug("contract.getTitle() = {}; autopayment.getAccessToken() = {}", (Object)contract.getTitle(), (Object)autopayment.getAccessToken());
                    JSONObject data = this.transactionManager.getPaymentRequestJSON(sum, contractId, contract.getTitle(), autopayment.getAccessToken(), YoomoneyPaymentType.AUTO);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("data = {}", (Object)data.toString());
                    }
                    String resultJson = this.transactionManager.doPaymentRequest(data.toString(), Setup.getSetup().get("billing.name", "") + System.currentTimeMillis());
                    this.getLogger().debug("resultJson = {}", (Object)resultJson);
                    if (resultJson != null) {
                        JSONObject result = new JSONObject(resultJson);
                        String objectId = result.optString("id");
                        this.getLogger().debug("objectId = {}", (Object)objectId);
                        if (Utils.notEmptyString((String)objectId)) {
                            EventProcessor.getInstance().publish((Event)new YoomoneyCheckEvent(this.moduleId, contractId, objectId));
                        }
                    }
                    try {
                        Thread.sleep(this.sleepTimeout);
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            MDC.remove((String)"module");
            MDC.remove((String)"moduleId");
            MDC.remove((String)"contractId");
        }
        return null;
    }
}

