/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.inet.common.bean.InvDevice;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceInterface;
import ru.bitel.oss.systems.inventory.resource.common.bean.DevicePortSubscription;
import ru.bitel.oss.systems.inventory.resource.common.event.DeviceInterfaceModifiedEvent;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceInterfaceService;
import ru.bitel.oss.systems.inventory.resource.server.bean.DevicePortDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.DevicePortSubscriptionDao;

@WebService(endpointInterface="ru.bitel.oss.systems.inventory.resource.common.service.DeviceInterfaceService")
public class DeviceInterfaceServiceImpl
extends AbstractService
implements DeviceInterfaceService {
    private DevicePortDao devicePortDao;
    private DevicePortSubscriptionDao devicePortSubscriptionDao;

    @PostConstruct
    protected void init() {
        this.devicePortDao = new DevicePortDao(this.getConnection(), this.moduleId);
        this.devicePortSubscriptionDao = new DevicePortSubscriptionDao(this.getConnection(), this.moduleId);
    }

    @Deprecated
    public List<DeviceInterface> devicePortList(int deviceId) throws BGException {
        return this.devicePortList(deviceId, false);
    }

    public List<DeviceInterface> devicePortList(int deviceId, boolean loadSubscription) throws BGException {
        List<DeviceInterface> result = this.devicePortDao.list(deviceId, -1, true, true, loadSubscription);
        return result;
    }

    public DeviceInterface devicePort(int deviceId, int port) throws BGException {
        return this.devicePortDao.get(deviceId, port);
    }

    public void devicePortDelete(int deviceId, int port) throws BGException {
        this.tryCall(() -> {
            List<DevicePortSubscription> subs = this.devicePortSubscriptionDao.list(deviceId, port, null, null);
            if (subs.size() > 0) {
                throw new BGException("\u041d\u0430 \u044d\u0442\u043e\u0442 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438, \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0432\u043d\u0430\u0447\u0430\u043b\u0435 \u0438\u0445");
            }
            DeviceInterface oldIface = this.devicePortDao.get(deviceId, port);
            this.devicePortDao.delete(deviceId, port);
            this.context.publishAfterCommit(new DeviceInterfaceModifiedEvent(this.moduleId, this.userId, oldIface, null));
        });
    }

    public void devicePortUpdate(DeviceInterface port, boolean deviceTypeUpdate) throws BGException {
        this.tryCall(() -> {
            DeviceInterface oldPort = this.devicePortDao.get(port.getDeviceId(), port.getPort());
            if (!deviceTypeUpdate) {
                InetDeviceService inetDeviceService = this.context.getService(InetDeviceService.class, this.moduleId);
                InvDevice invDevice = (InvDevice)inetDeviceService.deviceGet(port.getDeviceId());
                if (oldPort != null && !port.getTitle().equals(oldPort.getTitle()) && !inetDeviceService.isUniqueInterface(invDevice.getDeviceTypeId())) {
                    throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430");
                }
            }
            if (oldPort != null && oldPort.getStatus() != 0 && port.getStatus() == 0) {
                List<DevicePortSubscription> subs = this.devicePortSubscriptionDao.list(port.getDeviceId(), port.getPort(), null, null);
                boolean notReserve = false;
                Date date = new Date();
                for (DevicePortSubscription devicePort : subs) {
                    if (!TimeUtils.dateInRange((Date)date, (Date)devicePort.getDateFrom(), (Date)devicePort.getDateTo())) continue;
                    notReserve = true;
                }
                if (subs.size() > 0 && notReserve) {
                    throw new BGException("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0437\u0430\u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441, \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u0430 \u043d\u0435\u0433\u043e \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438 ");
                }
            }
            this.devicePortDao.update(port);
            this.context.publishAfterCommit(new DeviceInterfaceModifiedEvent(this.moduleId, this.userId, oldPort, port));
        });
    }

    public void devicePortCommentUpdate(DeviceInterface deviceInterface) throws BGException {
        this.devicePortDao.updateDevicePortComment(deviceInterface.getDeviceId(), deviceInterface.getPort(), deviceInterface.getComment());
    }

    public boolean devicePortSubscribe(int subscriberId, String subscriberTitle, int deviceId, int port, Date dateFrom, Date dateTo, boolean isInterfacePersonal) throws BGException {
        return (Boolean)this.tryReturn(() -> {
            List<DevicePortSubscription> subList;
            DeviceInterface devicePort = this.devicePort(deviceId, port);
            if (devicePort == null) {
                throw new BGMessageException("\u042d\u0442\u043e\u0433\u043e \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u043d\u0435\u0442 \u043d\u0430 \u044d\u0442\u043e\u043c \u0443\u0441\u0442\u0440\u043e\u0439\u0442\u0441\u0442\u0432\u0435 ");
            }
            if (devicePort.getStatus() == 0) {
                throw new BGMessageException("\u042d\u0442\u043e\u0442 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u0437\u0430\u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u043d\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0442\u0441\u0442\u0432\u0435 ");
            }
            this.devicePortUnsubscribe(subscriberId);
            if (isInterfacePersonal && (subList = this.devicePortSubscriptionDao.list(deviceId, port, dateFrom, dateTo)).size() > 0) {
                throw new BGMessageException("\u042d\u0442\u043e\u0442 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u0440\u0443\u0433\u0438\u043c\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0430\u043c\u0438");
            }
            DevicePortSubscription result = new DevicePortSubscription().setId(-1).setDeviceId(deviceId).setPortId(port).setDateFrom(dateFrom).setDateTo(dateTo).setSubscriberId(subscriberId).setSubscriberTitle(subscriberTitle);
            this.devicePortSubscriptionDao.update(result);
            return true;
        });
    }

    public void devicePortUnsubscribe(int subscriberId) throws BGException {
        this.tryCall(() -> this.devicePortSubscriptionDao.deleteBySubscriberId(subscriberId));
    }

    public Result<DevicePortSubscription> devicePortSubscriptionList(int deviceId, int port, Date dateFrom, Date dateTo, Page page) throws BGException {
        return this.devicePortSubscriptionDao.list(deviceId, port, dateFrom, dateTo, page);
    }

    public Integer nextFreeInterface(int deviceId, Date dateFrom, Date dateTo) throws BGException {
        List<DeviceInterface> portList = this.devicePortDao.list(deviceId, 1, false, false, null);
        this.devicePortList(deviceId, false);
        Integer port = null;
        for (DeviceInterface iface : portList) {
            List<DevicePortSubscription> subList = this.devicePortSubscriptionDao.list(deviceId, iface.getPort(), dateFrom, dateTo);
            if (subList.size() != 0) continue;
            port = iface.getPort();
            break;
        }
        if (port == null) {
            throw new BGMessageException("\u041d\u0435\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u043e\u0432 \u0432 \u0440\u0435\u0441\u0443\u0440\u0441\u0435 ");
        }
        return port;
    }

    public List<DeviceInterface> deviceInterfaceListFree(int deviceId, Date dateFrom, Date dateTo, String interfaceTitle) throws BGException {
        ArrayList<DeviceInterface> result = new ArrayList<DeviceInterface>();
        List<DeviceInterface> portList = this.devicePortDao.list(deviceId, 1, true, false, interfaceTitle);
        for (DeviceInterface iface : portList) {
            List<DevicePortSubscription> subList = this.devicePortSubscriptionDao.list(deviceId, iface.getPort(), dateFrom, dateTo);
            if (subList.size() != 0) continue;
            result.add(iface);
        }
        return result;
    }
}

