/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.table;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseComponent;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseComponentPrice;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseComponentDao;
import ru.bitel.bgbilling.modules.license.server.bean.LicensePriceDao;
import ru.bitel.common.Utils;

public class TableProductComponentPrice
extends BGTableInfoBase {
    public TableProductComponentPrice() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextLeft((String)"\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442", (String)"componentTitle").setWidth(300), BGUTableColumn.buildColumnTextLeft((String)"\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u044b", (String)"ranges").setMaxWidth(-1), BGUTableColumn.buildColumnDecimal((String)"\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c (unlim)", (String)"unlimCost").setMaxWidth(200), BGUTableColumn.buildColumnBoolean((String)"\u041d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447.", (String)"unlimited", (int)100), BGUTableColumn.buildColumnId()};
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        ArrayList<BGUTableRowData> list = new ArrayList<BGUTableRowData>();
        int productId = Utils.parseInt((String)tableParams.get("productId"));
        if (productId > 0) {
            ServerContext serverContext = (ServerContext)ServerContext.get();
            Connection con = serverContext.getConnection();
            List<LicenseComponentPrice> componentPrices = new LicensePriceDao(con, moduleId).list(productId);
            for (LicenseComponent component : new LicenseComponentDao(con, moduleId).listForProduct(productId)) {
                StringBuilder ranges = new StringBuilder();
                BigDecimal unlimCost = BigDecimal.ZERO;
                LicenseComponentPrice price = componentPrices.stream().filter(a -> a.getComponentId() == component.getId()).findFirst().orElse(null);
                if (price != null) {
                    JSONObject json = new JSONObject(price.getPrice());
                    unlimCost = json.optBigDecimal("unlim", unlimCost);
                    JSONArray array = json.optJSONArray("ranges");
                    array.forEach(a -> {
                        JSONObject range = (JSONObject)a;
                        ranges.append(ranges.isEmpty() ? "" : "; ").append(Utils.formatInteger((int)range.optInt("range"))).append("=").append(Utils.formatCost((BigDecimal)range.optBigDecimal("cost", BigDecimal.ZERO), (int)0));
                    });
                }
                BGUTableRowData rowData = new BGUTableRowData().addValue("componentTitle", component.getTitle()).addValue("ranges", ranges.toString()).addValue("unlimCost", unlimCost.toPlainString()).addValue("unlimited", component.getUnlimited() > 0).addValue(this.getId(component.getId()));
                list.add(rowData);
            }
        }
        return list;
    }
}

