/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.dhcp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpListenerWorker;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpDevice;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadLocalEvent;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetOptionRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;

public class InetDhcpDeviceMap {
    private static final Logger logger = LogManager.getLogger();
    private final Access access;
    private volatile Set<Integer> deviceTypeIds;
    private volatile Data data;

    public InetDhcpDeviceMap(Access access) throws BGException {
        this.access = access;
        this.loadDevices();
        EventProcessor.getInstance().addListener((EventListener)new EventListener<InetReloadLocalEvent>(){

            public void notify(InetReloadLocalEvent e, EventListenerContext ctx) throws BGException {
                InetDhcpDeviceMap.this.loadDevices();
            }
        }, InetReloadLocalEvent.class, access.moduleId, null);
    }

    protected void loadDevices() {
        InetDeviceRuntime root = this.access.deviceMap.get(this.access.rootDeviceId);
        String deviceTypeIdsString = root.config.get("dhcp.relay.deviceTypeIds", "");
        this.deviceTypeIds = Utils.toIntegerSet((String)deviceTypeIdsString);
        logger.info("Load DHCP relay list, types: [" + Utils.toString(this.deviceTypeIds) + "].");
        Map<Integer, InetDeviceRuntime> deviceMap = this.access.deviceMap.getMap();
        final Data data = new Data();
        InetOptionRuntimeMap inetOptionRuntimeMap = null;
        try {
            inetOptionRuntimeMap = InetOptionRuntimeMap.getInstance(this.access.moduleId);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        final ExecutorService executorService = Executors.newFixedThreadPool(100);
        for (final InetDeviceRuntime deviceRuntime : deviceMap.values()) {
            try {
                if (this.deviceTypeIds != null && this.deviceTypeIds.size() > 0 && !this.deviceTypeIds.contains(deviceRuntime.inetDevice.getDeviceTypeId())) continue;
                final int id = deviceRuntime.inetDevice.getId();
                final InetDhcpDevice dhcpDevice = new InetDhcpDevice(this.access, inetOptionRuntimeMap, deviceRuntime);
                data.deviceById.put(deviceRuntime.inetDeviceId, dhcpDevice);
                logger.info("Loaded device: " + id);
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (InetSocketAddress socketAddr : deviceRuntime.inetDevice.getHosts()) {
                                try {
                                    InetAddress address = socketAddr.getAddress();
                                    if (address != null) {
                                        address.hashCode();
                                        data.deviceByIp.put(address, dhcpDevice);
                                        logger.info("Bind device: " + id + "; " + IpAddress.toString((byte[])address.getAddress()));
                                        continue;
                                    }
                                    logger.info("Host not set for deviceId:" + id);
                                }
                                catch (Exception ex) {
                                    logger.error(ex.getMessage(), (Throwable)ex);
                                }
                            }
                        }
                        catch (Exception ex) {
                            logger.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                });
                String identifier = deviceRuntime.inetDevice.getIdentifier();
                if (!Utils.notBlankString((String)identifier)) continue;
                List<InetDhcpDevice> list = data.identifierMap.get(identifier);
                if (list == null) {
                    list = new ArrayList<InetDhcpDevice>(2);
                    data.identifierMap.put(identifier, list);
                }
                list.add(dhcpDevice);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            executorService.shutdown();
            if (!executorService.awaitTermination(1L, TimeUnit.MINUTES)) {
                new Thread(this, "dhcp-map-checker"){

                    @Override
                    public void run() {
                        try {
                            if (!executorService.awaitTermination(4L, TimeUnit.MINUTES)) {
                                logger.error("DHCP device IP-map loading timeout! Check DNS settings.");
                            }
                        }
                        catch (InterruptedException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }.start();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.data = data;
    }

    public InetDhcpDevice get(int id) {
        Data data = this.data;
        return data.deviceById.get(id);
    }

    @Deprecated
    public InetDhcpDevice getDevice(SocketAddress clientAddress, DhcpListenerWorker<InetDhcpDevice> req, DhcpPacket request) throws UnknownHostException {
        Object agentRemoteId;
        InetAddress address;
        Data data = this.data;
        InetAddress giaddr = InetAddress.getByAddress(request.giaddr);
        InetDhcpDevice device = (InetDhcpDevice)data.deviceByIp.get(giaddr);
        if (device == null && (device = (InetDhcpDevice)data.deviceByIp.get(address = ((InetSocketAddress)clientAddress).getAddress())) == null) {
            return null;
        }
        logger.debug("Found device by giaddr id=" + device.deviceRuntime.inetDeviceId);
        req.relayDeviceId = device.getId();
        if (device.deviceSearchMode != 1 || device.deviceRuntime.descendantIds.size() == 0) {
            return device;
        }
        if (device.deviceRuntime.protocolHandler != null) {
            try {
                device.deviceRuntime.protocolHandler.preprocessDhcpRequest(request, null);
                if (logger.isInfoEnabled()) {
                    logger.info("REQUEST_AFTER_PREPROCESS:\n" + String.valueOf(request));
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if ((agentRemoteId = device.deviceRuntime.getOption82AgentRemoteId(request)) == null || "".equals(agentRemoteId)) {
            return device;
        }
        InetDeviceRuntime subDeviceRuntime = this.access.deviceMap.getByIdentifier(device.deviceRuntime, agentRemoteId);
        if (subDeviceRuntime != null) {
            req.agentDeviceId = subDeviceRuntime.inetDeviceId;
            logger.debug("Found subDevice by identifier id=" + subDeviceRuntime.inetDeviceId);
            InetDhcpDevice dhcpDevice = data.deviceById.get(subDeviceRuntime.inetDeviceId);
            if (dhcpDevice != null) {
                return dhcpDevice;
            }
        }
        return device;
    }

    public InetDhcpDevice getDevice(SocketAddress clientAddress, DhcpPacket request, boolean socketAddressSearch) throws UnknownHostException {
        Data data = this.data;
        InetAddress giaddr = InetAddress.getByAddress(request.giaddr);
        InetDhcpDevice device = (InetDhcpDevice)data.deviceByIp.get(giaddr);
        if (device != null) {
            logger.debug("Found device by giaddr id=" + device.deviceRuntime.inetDeviceId);
        } else if (socketAddressSearch) {
            InetAddress address = ((InetSocketAddress)clientAddress).getAddress();
            device = (InetDhcpDevice)data.deviceByIp.get(address);
            if (device != null) {
                logger.debug("Found device by IP id=" + device.deviceRuntime.inetDeviceId);
            } else {
                return null;
            }
        }
        return device;
    }

    static class Data {
        final ConcurrentMap<InetAddress, InetDhcpDevice> deviceByIp = new ConcurrentHashMap<InetAddress, InetDhcpDevice>();
        final Map<Integer, InetDhcpDevice> deviceById = new HashMap<Integer, InetDhcpDevice>();
        final Map<String, List<InetDhcpDevice>> identifierMap = new HashMap<String, List<InetDhcpDevice>>();

        Data() {
        }
    }
}

