/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.limit.server.bean;

import bitel.billing.server.util.Config;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitParameters;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class LimitManagerConfig
extends Config {
    final List<ContractLimitParameters> contractLimitParameters;

    public LimitManagerConfig(int moduleId, ParameterMap moduleSetup, Setup serverSetup) {
        super(moduleId, moduleSetup, serverSetup);
        this.contractLimitParameters = LimitManagerConfig.load(serverSetup);
    }

    public static final List<ContractLimitParameters> load(Setup setup) {
        ArrayList<ContractLimitParameters> result = new ArrayList<ContractLimitParameters>();
        int i = 1;
        Set<Integer> contractLabelIds = null;
        while ((contractLabelIds = LimitManagerConfig.getContractLabelIds(setup, i)) != null) {
            String prefix = "contract.limit." + i;
            int maxNotPayoffed = setup.getInt(prefix + ".maxnotpayoffed", 0);
            int maxPartialPayoffed = setup.getInt(prefix + ".maxpartialpayoffed", 0);
            int maxExpiredForBlock = setup.getInt(prefix + ".maxexpiredforblock", 0);
            int minDays = setup.getInt(prefix + ".mindays", 1);
            int maxDays = setup.getInt(prefix + ".maxdays", 10);
            int delayDays = setup.getInt(prefix + ".delaydays", 30);
            int modeDefault = setup.getInt(prefix + ".mode.default", 1);
            BigDecimal minSumm = setup.getBigDecimal(prefix + ".minsumm", new BigDecimal(10));
            BigDecimal maxSumm = setup.getBigDecimal(prefix + ".maxsumm", new BigDecimal(100));
            BigDecimal minLimit = setup.getBigDecimal(prefix + ".minlimit", new BigDecimal(-100));
            result.add(new ContractLimitParameters(contractLabelIds, maxNotPayoffed, maxPartialPayoffed, maxExpiredForBlock, minDays, maxDays, delayDays, modeDefault, minSumm, maxSumm, minLimit));
            ++i;
        }
        return result;
    }

    private static Set<Integer> getContractLabelIds(Setup setup, int n) {
        String ids = setup.get("contract.limit." + n + ".label.ids", null);
        if (ids != null) {
            return Utils.toIntegerSet(ids);
        }
        if (setup.get("contract.limit." + n + ".groups", null) != null) {
            BGLogger.error("\u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415!!! \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"contract.limit." + n + ".groups\" \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430 \"contract.limit." + n + ".label.ids\"");
        }
        return null;
    }
}

