/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.log.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.sql.ConnectionSet;

public class ConnectionLogEntryDao
extends BGLogger
implements AutoCloseable {
    private final ConnectionSet connectionSet;
    private final int mid;
    private Connection con;
    private String updateLastTableName;
    private PreparedStatement updatePS;

    public ConnectionLogEntryDao(ConnectionSet connectionSet, int mid) {
        this.connectionSet = connectionSet;
        this.mid = mid;
    }

    protected ConnectionLogEntry getFromRS(ResultSet rs) throws SQLException, BGException {
        ConnectionLogEntry result = new ConnectionLogEntry();
        result.setId(rs.getInt("id"));
        result.setApplicationId(rs.getInt("applicationId"));
        result.setDeviceId(rs.getInt("deviceId"));
        result.setDevicePort(rs.getInt("devicePort"));
        result.setConnectionId(rs.getInt("connectionId"));
        result.setTime(TimeUtils.convertTimestampToDate(rs.getTimestamp("time")));
        result.setAcctSessId(rs.getString("acctSessId"));
        result.setLogType(rs.getInt("type"));
        result.setRequestDataLogId(rs.getInt("requestDataLogId"));
        result.setRequestChunkId(rs.getInt("requestChunkId"));
        result.setRequestPosition(rs.getInt("requestPosition"));
        result.setResponseDataLogId(rs.getInt("responseDataLogId"));
        result.setResponseChunkId(rs.getInt("responseChunkId"));
        result.setResponsePosition(rs.getInt("responsePosition"));
        result.setIdentifier(rs.getString("identifier"));
        return result;
    }

    public void update(ConnectionLogEntry b) throws BGException {
        try {
            this.updateImpl(b, false);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void update(ConnectionLogEntry b, boolean commit) throws BGException {
        try {
            this.updateImpl(b, commit);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    protected void updateImpl(ConnectionLogEntry b, boolean commit) throws BGException, SQLException {
        PreparedStatement ps;
        Date time = b.getTime();
        String tableName = ServerUtils.getModuleMonthTableName((String)"connection_log_entry", (Date)time, (int)this.mid);
        if (tableName.equals(this.updateLastTableName)) {
            ps = this.updatePS;
        } else {
            if (this.updatePS != null) {
                this.updatePS.close();
            }
            if (this.con == null) {
                this.con = this.connectionSet.getTrashConnection(tableName, 1);
            }
            if (!ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                Statement stmt = this.con.createStatement();
                stmt.executeUpdate("CREATE TABLE " + tableName + " ( `id` int(11) NOT NULL auto_increment,  `applicationId` INT  NOT NULL,  `deviceId` INT  NOT NULL,  `devicePort` INT  NOT NULL,  `connectionId` BIGINT  NOT NULL,  `time` DATETIME  NOT NULL,  `acctSessId` VARCHAR(50)  NOT NULL,  `type` INT  NOT NULL,  `requestDataLogId` INT  NOT NULL,  `requestChunkId` INT  NOT NULL,  `requestPosition` INT  NOT NULL,  `responseDataLogId` INT  NOT NULL,  `responseChunkId` INT  NOT NULL,  `responsePosition` INT  NOT NULL, `identifier` VARCHAR(50) NULL, PRIMARY KEY `id`  (`id`, `deviceId`), KEY `app-dev-con`(`deviceId`, `time`, `connectionId`, `acctSessId`, `identifier`))/*!50100 PARTITION BY HASH( deviceId ) PARTITIONS 8*/");
                stmt.close();
            } else if (!ServerUtils.columnExist((Connection)this.con, (String)tableName, (String)"identifier")) {
                Statement stmt = this.con.createStatement();
                stmt.executeUpdate("ALTER TABLE " + tableName + " ADD COLUMN `identifier` VARCHAR(50) NULL , DROP INDEX `app-dev-con`, ADD INDEX `app-dev-con` (`deviceId`, `time`, `connectionId`, `acctSessId`, `identifier`)");
                stmt.close();
            }
            ps = this.updatePS = this.con.prepareStatement("INSERT INTO " + tableName + " (applicationId, deviceId, devicePort, connectionId, time, acctSessId, type, requestDataLogId, requestChunkId, requestPosition, responseDataLogId, responseChunkId, responsePosition, identifier) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
            this.updateLastTableName = tableName;
        }
        ps.setInt(1, b.getApplicationId());
        ps.setInt(2, b.getDeviceId());
        ps.setInt(3, b.getDevicePort());
        ps.setLong(4, b.getConnectionId());
        ps.setTimestamp(5, TimeUtils.convertDateToTimestamp(b.getTime()));
        ps.setString(6, b.getAcctSessId());
        ps.setInt(7, b.getLogType());
        ps.setInt(8, b.getRequestDataLogId());
        ps.setInt(9, b.getRequestChunkId());
        ps.setInt(10, b.getRequestPosition());
        ps.setInt(11, b.getResponseDataLogId());
        ps.setInt(12, b.getResponseChunkId());
        ps.setInt(13, b.getResponsePosition());
        ps.setString(14, b.getIdentifier());
        ps.executeUpdate();
        b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        if (commit && !this.con.getAutoCommit()) {
            this.con.commit();
        }
    }

    public void updateResponseCoords(Date time, int deviceId, int id, int[] coords) throws BGException, SQLException {
        String tableName = ServerUtils.getModuleMonthTableName((String)"connection_log_entry", (Date)time, (int)this.mid);
        Connection con = this.connectionSet.getTrashConnection(tableName, 1);
        if (!ServerUtils.tableExists((Connection)con, (String)tableName)) {
            return;
        }
        PreparedStatement ps = con.prepareStatement("UPDATE " + tableName + " SET responseDataLogId=?, responseChunkId=?, responsePosition=? WHERE deviceId=? AND id=?");
        ps.setInt(1, coords[0]);
        ps.setInt(2, coords[1]);
        ps.setInt(3, coords[2]);
        ps.setInt(4, deviceId);
        ps.setInt(5, id);
        ps.executeUpdate();
        ps.close();
    }

    public List<ConnectionLogEntry> list(Date timeFrom, Date timeTo, int deviceId, int devicePort, String acctSessId, long connectionId, String identifier) throws BGException {
        ArrayList<ConnectionLogEntry> result = new ArrayList<ConnectionLogEntry>();
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            if (timeTo == null) {
                timeTo = new Date();
            } else {
                calendar.setTime(timeTo);
                ((Calendar)calendar).add(13, 3);
                timeTo = calendar.getTime();
            }
            calendar.setTime(timeTo);
            ((Calendar)calendar).add(13, 15);
            Date timeTo2 = calendar.getTime();
            calendar.setTime(timeFrom);
            ((Calendar)calendar).add(13, -3);
            Date timeFrom2 = calendar.getTime();
            TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
            calendar.set(5, 1);
            while (!calendar.getTime().after(timeTo)) {
                String tableName = ServerUtils.getModuleMonthTableName((String)"connection_log_entry", (Date)calendar.getTime(), (int)this.mid);
                Connection con = this.connectionSet.getTrashConnection(tableName, 2);
                if (ServerUtils.tableExists((Connection)con, (String)tableName)) {
                    PreparedStatement ps = con.prepareStatement("SELECT * FROM " + tableName + " WHERE deviceId=? AND ((time>=? AND time<=? AND (acctSessId=? OR ((acctSessId IS NULL OR acctSessId='') AND devicePort=?) OR (identifier IS NOT NULL && identifier=?) ) AND type=?) OR (time>=? AND time<=? AND connectionId=?))");
                    ps.setInt(1, deviceId);
                    ps.setTimestamp(2, TimeUtils.convertDateToTimestamp(timeFrom2));
                    ps.setTimestamp(3, TimeUtils.convertDateToTimestamp(timeFrom));
                    ps.setString(4, acctSessId);
                    ps.setInt(5, devicePort);
                    ps.setString(6, identifier);
                    ps.setInt(7, 1);
                    ps.setTimestamp(8, TimeUtils.convertDateToTimestamp(timeFrom2));
                    ps.setTimestamp(9, TimeUtils.convertDateToTimestamp(timeTo2));
                    ps.setLong(10, connectionId);
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        result.add(this.getFromRS(rs));
                    }
                    rs.close();
                    ps.close();
                }
                ((Calendar)calendar).add(2, 1);
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public ConnectionLogEntry get(int deviceId, Date date, int id) throws BGException {
        ConnectionLogEntry result = null;
        try {
            String tableName = ServerUtils.getModuleMonthTableName((String)"connection_log_entry", (Date)date, (int)this.mid);
            Connection con = this.connectionSet.getTrashConnection(tableName, 2);
            PreparedStatement ps = con.prepareStatement("SELECT * FROM " + tableName + " WHERE deviceId=? AND id=?");
            ps.setInt(1, deviceId);
            ps.setInt(2, id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = this.getFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public List<ConnectionLogEntry> getByConnectionId(Date date, int connectionId) throws BGException {
        ArrayList<ConnectionLogEntry> result = new ArrayList<ConnectionLogEntry>();
        try {
            String tableName = ServerUtils.getModuleMonthTableName((String)"connection_log_entry", (Date)date, (int)this.mid);
            Connection con = this.connectionSet.getTrashConnection(tableName, 2);
            PreparedStatement ps = con.prepareStatement("SELECT * FROM " + tableName + " WHERE connectionId=?");
            ps.setLong(1, connectionId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ConnectionLogEntry entry = this.getFromRS(rs);
                result.add(entry);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    @Override
    public void close() {
        this.updateLastTableName = null;
        if (this.updatePS != null) {
            try {
                this.updatePS.close();
            }
            catch (SQLException e) {
                this.getLogger().error("error close ConnectionLogEntryDao", (Throwable)e);
            }
            this.updatePS = null;
        }
        this.con = null;
    }
}

