/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paylinks.server.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.paylinks.server.bean.Method;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.model.IdTitle;

public class MethodManager {
    private SortedMap<Integer, Method> methodMap = new TreeMap<Integer, Method>();

    public MethodManager(ParameterMap setup) {
        SortedMap submethods = setup.subIndexed("method.");
        for (Map.Entry entry1 : submethods.entrySet()) {
            int id = (Integer)entry1.getKey();
            ParameterMap submethod = (ParameterMap)entry1.getValue();
            Method method = new Method();
            method.id = id;
            method.title = submethod.get("title", null);
            method.description = submethod.get("description", null);
            method.confirm = submethod.get("confirm", null);
            method.url = submethod.get("url", null);
            method.results = new HashMap<String, String>();
            ParameterMap resultpm = submethod.sub("result.");
            for (Map.Entry entry2 : resultpm.entrySet()) {
                method.results.put((String)entry2.getKey(), (String)entry2.getValue());
            }
            this.methodMap.put(id, method);
        }
    }

    public String getTitle(int methodId) {
        Method m = (Method)this.methodMap.get(methodId);
        return m != null ? m.title : "?#" + methodId;
    }

    public Method getMethod(int methodId) throws BGException {
        Method m = (Method)this.methodMap.get(methodId);
        if (m == null) {
            throw new BGMessageException("\u043c\u0435\u0442\u043e\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b id=" + methodId + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        return m;
    }

    public List<IdTitle> getMethods() {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        for (Method method : this.methodMap.values()) {
            result.add(new IdTitle(method.id, method.title));
        }
        return result;
    }
}

