/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.buyemoney.server.action;

import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.modules.buyemoney.server.action.ActionBase;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolCurrency;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolManager;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class ActionGetProtocolProps
extends ActionBase {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doAction() throws Exception {
        int f_currency = this.getIntParameter("currency", -1);
        ProtocolManager protocolManager = new ProtocolManager((ParameterMap)this.moduleSetup);
        ProtocolCurrency pcurrency = protocolManager.getProtocols().get(f_currency);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        if (pcurrency != null) {
            this.addRow(data, "\u041f\u0440\u043e\u0442\u043e\u043a\u043e\u043b", pcurrency.getProtocolParameter("title"));
            this.addRow(data, "\u041a\u043e\u0434", pcurrency.getProtocolParameter("code"));
            int chargeType = Utils.parseInt((String)pcurrency.getProtocolParameter("chargeType"));
            String chargeTitle = String.valueOf(this.context.getDirectory(ChargeType.class, 0).get(chargeType));
            this.addRow(data, "\u0422\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430", chargeTitle + " (id=" + String.valueOf(chargeType) + ")");
            int purseMode = Utils.parseInt((String)pcurrency.getProtocolParameter("purseMode"));
            this.addRow(data, "\u0420\u0435\u0436\u0438\u043c \u043a\u043e\u0448\u0435\u043b\u044c\u043a\u0430", String.valueOf(purseMode));
            try {
                Map<String, String> info = pcurrency.getInfo();
                if (info == null) return;
                for (Map.Entry<String, String> entry : info.entrySet()) {
                    this.addRow(data, entry.getKey(), entry.getValue());
                }
                return;
            }
            catch (Exception ex) {
                this.addRow(data, "\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", "\u041e\u0448\u0438\u0431\u043a\u0430: " + ex.getMessage());
                this.getLogger().error("error get currency info", (Throwable)ex);
                return;
            }
        } else {
            this.addRow(data, "\u041f\u0440\u043e\u0442\u043e\u043a\u043e\u043b", "\u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d");
        }
    }

    private void addRow(Element data, String key, String value) {
        Element currEl = this.createElement(data, "row");
        currEl.setAttribute("key", key);
        currEl.setAttribute("value", value);
    }
}

