/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.client;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternPluginTabPanel;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskService;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class PatternPluginTabPanelItemFactory
implements PatternPluginTabPanel.PatternPluginTabPanelItemFactory {
    public Collection<PatternPluginTabPanel.PatternPluginTabPanelItem> getPatternPluginTabPanelItems(int pid, String pluginTitle) {
        return Collections.singleton(new HelpDeskPanel(pid, pluginTitle));
    }

    private class HelpDeskPanel
    extends PatternPluginTabPanel.PatternPluginTabPanelItem {
        String title;
        private BGUComboBox<IdTitle> groupComboBox;
        private BGComboBox<KeyValue> modeComboBox;
        Vector<KeyValue> groupVector;

        public HelpDeskPanel(int pid, String title) {
            super((LayoutManager)new GridBagLayout());
            this.title = null;
            this.groupComboBox = new BGUComboBox();
            this.modeComboBox = new BGComboBox();
            this.groupVector = new Vector();
            this.title = "\u0420\u0435\u0436\u0438\u043c \u0438 \u0413\u0440\u0443\u043f\u043f\u0430";
            this.pid = pid;
            JPanel modePanel = new JPanel(new GridBagLayout());
            modePanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0436\u0438\u043c "));
            modePanel.add((Component)this.modeComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            JPanel groupPanel = new JPanel(new GridBagLayout());
            groupPanel.setBorder((Border)new BGTitleBorder(" \u0413\u0440\u0443\u043f\u043f\u0430 "));
            groupPanel.add((Component)this.groupComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)modePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)groupPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            panel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.add(panel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        }

        protected void init() {
            ClientContext clientContext = new ClientContext(null, -1, -1, "ru.bitel.bgbilling.plugins.helpdesk.client.contract.setup");
            try {
                this.groupComboBox.setData(((HelpdeskService)clientContext.getWebService(HelpdeskService.class)).categoryGroupList());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            if (this.groupComboBox.getModel().getSize() > 0) {
                this.groupComboBox.setSelectedIndex(0);
            }
            try {
                DefaultComboBoxModel<KeyValue> model = new DefaultComboBoxModel<KeyValue>();
                for (KeyValue item : ((HelpdeskService)clientContext.getWebService(HelpdeskService.class)).getModeList()) {
                    model.addElement(item);
                }
                this.modeComboBox.setModel(model);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        protected boolean isItemEnabled() {
            return false;
        }

        protected void setData(Element element) {
            try {
                Element helpDesk;
                KeyValue noSelect = new KeyValue("0", "=====");
                this.groupVector.remove(noSelect);
                int modeListSize = this.modeComboBox.getModel().getSize();
                if (modeListSize > 0 && ((KeyValue)this.modeComboBox.getModel().getElementAt(modeListSize - 1)).getKey().equals("0")) {
                    this.modeComboBox.removeItemAt(modeListSize - 1);
                }
                if ((helpDesk = XMLUtils.selectElement((Node)element, (String)"//helpDesk")) != null) {
                    String selectGroupId = helpDesk.getAttribute("selectGroupId");
                    if (!selectGroupId.isEmpty()) {
                        int selectIndex = -1;
                        for (KeyValue item : this.groupVector) {
                            if (!item.getKey().equals(selectGroupId)) continue;
                            selectIndex = this.groupVector.indexOf(item);
                            break;
                        }
                        if (selectIndex != -1) {
                            this.groupComboBox.setSelectedIndex(selectIndex);
                        } else {
                            this.setNoSelectItem(this.groupComboBox);
                        }
                    } else {
                        this.setNoSelectItem(this.groupComboBox);
                    }
                    String modeId = helpDesk.getAttribute("mode");
                    if (!modeId.equals("")) {
                        this.modeComboBox.setSelectedId(modeId);
                    } else {
                        this.setNoSelectItem(this.modeComboBox);
                    }
                } else {
                    this.setNoSelectItem(this.groupComboBox);
                    this.setNoSelectItem(this.modeComboBox);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        protected void reset() {
        }

        protected void serialise(Element element) throws BGException {
            KeyValue keyValue;
            Element helpDesk = XMLUtils.createElement((Element)element, (String)"helpDesk");
            IdTitle item = (IdTitle)this.groupComboBox.getSelectedItem();
            if (item != null && item.getId() != 0) {
                helpDesk.setAttribute("selectGroupId", String.valueOf(item.getId()));
            }
            if ((keyValue = (KeyValue)this.modeComboBox.getSelectedItem()) == null) {
                throw new BGMessageException("\u0420\u0435\u0436\u0438\u043c \u0425\u0435\u043b\u043f\u0434\u0435\u0441\u043a\u0430 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d!");
            }
            String modeId = keyValue.getKey();
            if (!modeId.equals("0")) {
                helpDesk.setAttribute("mode", modeId);
            }
        }

        public String getTitle() {
            return this.title;
        }

        private void setNoSelectItem(BGUComboBox<IdTitle> bgComboBox) {
            if (bgComboBox.getItemCount() > 0 && 0 == ((IdTitle)bgComboBox.getItemAt(0)).getId()) {
                bgComboBox.setSelectedIndex(0);
            } else {
                bgComboBox.insertItemAt((Object)IdTitle.NO_SELECT, 0);
                bgComboBox.setSelectedItem((Object)IdTitle.NO_SELECT);
            }
        }

        private void setNoSelectItem(BGComboBox<KeyValue> bgComboBox) {
            if (bgComboBox.getItemCount() > 0 && "0".equals(((KeyValue)bgComboBox.getItemAt(0)).getKey())) {
                bgComboBox.setSelectedIndex(0);
            } else {
                KeyValue noSelectItem = new KeyValue("0", "=====");
                bgComboBox.insertItemAt((Object)noSelectItem, 0);
                bgComboBox.setSelectedItem((Object)noSelectItem);
            }
        }
    }
}

