/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.bean;

import bitel.billing.server.contract.object.bean.ListValueManager;
import bitel.billing.server.contract.object.bean.ObjectTypeManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObjectType;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ListValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectParam;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectType;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamAddressValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamDateValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamFlagValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamListValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamTextValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamValue;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ObjectParamDao;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ParamValueManager;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.entity.common.bean.AbstractSpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;

public class ContractObjectDao
extends AbstractEntityAttrDao<ContractObject> {
    public ContractObjectDao(Connection con, int userId) {
        super(con, "object", "object", CONTRACT_OBJECT_SUPPORT, 0, userId);
    }

    public EntityAttr getObjectParameter(int objectId, int parameterId) throws Exception {
        return super.getEntityAttribute(objectId, parameterId);
    }

    public boolean updateObjectParameter(int objectId, EntityAttr entityAttr) throws Exception {
        boolean result = super.updateEntityAttribute(objectId, entityAttr);
        this.saveTitleByMacros((ContractObject)((Object)this.get(entityAttr.getEntityId())));
        return result;
    }

    public Optional<EntityAttrText> optObjectParameterText(int objectId, int parameterId) throws Exception {
        return super.optEntityAttribute(objectId, parameterId).filter(a -> a instanceof EntityAttrText).map(a -> (EntityAttrText)a);
    }

    public Optional<String> optObjectParameterTextAsString(int objectId, int parameterId) throws Exception {
        return this.optObjectParameterText(objectId, parameterId).map(EntityAttrText::getValue);
    }

    public Optional<EntityAttrBoolean> optObjectParameterBoolean(int objectId, int parameterId) throws Exception {
        return super.optEntityAttribute(objectId, parameterId).filter(a -> a instanceof EntityAttrBoolean).map(a -> (EntityAttrBoolean)a);
    }

    public Optional<Boolean> optObjectParameterBooleanAsBoolean(int objectId, int parameterId) throws Exception {
        return this.optObjectParameterBoolean(objectId, parameterId).map(EntityAttrBoolean::getValue);
    }

    public Optional<EntityAttrDate> optObjectParameterDate(int objectId, int parameterId) throws Exception {
        return super.optEntityAttribute(objectId, parameterId).filter(a -> a instanceof EntityAttrDate).map(a -> (EntityAttrDate)a);
    }

    public Optional<Date> optObjectParameterDateAsDate(int objectId, int parameterId) throws Exception {
        return this.optObjectParameterDate(objectId, parameterId).map(EntityAttrDate::getValue);
    }

    public Optional<EntityAttrList> optObjectParameterList(int objectId, int parameterId) throws Exception {
        return super.optEntityAttribute(objectId, parameterId).filter(a -> a instanceof EntityAttrList).map(a -> (EntityAttrList)a);
    }

    public Optional<String> optObjectParameterListAsString(int objectId, int parameterId) throws Exception {
        EntityAttrList attrList = this.optObjectParameterList(objectId, parameterId).orElse(null);
        if (attrList == null) {
            return Optional.empty();
        }
        if (attrList.getValue() > 0) {
            return new ListValueManager(this.con).getValues(parameterId).stream().filter(a -> a.getId() == attrList.getValue()).findFirst().map(IdTitle::getTitle);
        }
        return Optional.ofNullable(attrList.getTitle());
    }

    public Optional<EntityAttrAddress> optObjectParameterAddress(int objectId, int parameterId) throws Exception {
        return super.optEntityAttribute(objectId, parameterId).filter(a -> a instanceof EntityAttrAddress).map(a -> (EntityAttrAddress)a);
    }

    public Optional<String> getObjectParameterAddressAsString(int contractId, int parameterId) throws Exception {
        return this.optObjectParameterAddress(contractId, parameterId).map(EntityAttrAddress::getTitle);
    }

    public Directory<? extends EntitySpec> getEntitySpecDirectory() throws BGException {
        if (this.entitySpecDirectory == null) {
            this.entitySpecDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(ContractObjectType.class, this.con, 0, true);
        }
        return this.entitySpecDirectory;
    }

    protected Directory<? extends AbstractSpecAttr> getEntitySpecAttrDirectory() throws BGException {
        if (this.entitySpecAttrDirectory == null) {
            this.entitySpecAttrDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(ObjectParameterGroupAttr.class, this.con, 0, true);
        }
        return this.entitySpecAttrDirectory;
    }

    public void contractObjectTable(SearchResult<ContractObject> searchResult, int contractId, String titleFilter, int typeId) throws BGException {
        List<ContractObject> list = searchResult.getList();
        Page page = searchResult.getPage();
        StringBuilder query = new StringBuilder("SELECT SQL_CALC_FOUND_ROWS * FROM ").append(this.tableName).append(" WHERE cid=").append(contractId);
        if (typeId > 0) {
            query.append(" AND type_id=").append(typeId);
        }
        if (Utils.notBlankString(titleFilter)) {
            query.append(" AND title REGEXP ?");
        }
        query.append(" ORDER BY pos").append(Page.toSqlLimit(page));
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (Utils.notBlankString(titleFilter)) {
                ps.setString(1, titleFilter);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add((ContractObject)((Object)this.getFromRS(rs)));
                }
            }
            Page.setRecordCount(page, ServerUtils.foundRows((Connection)this.con));
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    protected ContractObject getFromRS(ResultSet rs, boolean loadAttributes) throws SQLException {
        return new ContractObject().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setStatus(rs.getInt("status")).setTitle(rs.getString("title")).setTypeId(rs.getInt("type_id")).setDateFrom(rs.getDate("date1")).setDateTo(rs.getDate("date2")).setPosition(rs.getInt("pos"));
    }

    protected void updateImpl(ContractObject contractObject) throws BGException, SQLException {
        boolean update = contractObject.getId() > 0;
        String set = " SET title=?, date1=?, date2=?, cid=?, type_id=?";
        String prefix = (update ? "UPDATE " : "INSERT INTO ") + this.tableName;
        String query = prefix + set;
        if (update) {
            query = query + " WHERE id=?";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, contractObject.getTitle() != null ? contractObject.getTitle().trim() : "");
            ps.setDate(2, TimeUtils.convertDateToSqlDate(contractObject.getDateFrom()));
            ps.setDate(3, TimeUtils.convertDateToSqlDate(contractObject.getDateTo()));
            ps.setInt(4, contractObject.getContractId());
            ps.setInt(5, contractObject.getTypeId());
            if (update) {
                ps.setInt(6, contractObject.getId());
            }
            ps.executeUpdate();
            if (!update) {
                contractObject.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        if (!update) {
            this.updateSortPosition(contractObject);
        }
    }

    private void updateSortPosition(ContractObject contractObject) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET pos=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractObject.getId());
            ps.setInt(2, contractObject.getId());
            ps.executeUpdate();
        }
    }

    public List<ContractObject> list(int contractId) throws BGException {
        return super.list("cid=?", "pos", new Object[]{contractId});
    }

    public void orderObject(int id, boolean up) throws Exception {
        String query = up ? "SELECT id, pos FROM " + this.tableName + " WHERE cid=? AND pos<? AND id!=? ORDER BY pos DESC LIMIT 1" : "SELECT id, pos FROM " + this.tableName + " WHERE cid=? AND pos>? AND id!=? ORDER BY pos ASC LIMIT 1";
        boolean update = false;
        int contrObjectId = 0;
        int contrObjectPos = 0;
        ContractObject contractObject = (ContractObject)((Object)this.get(id));
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractObject.getContractId());
            ps.setInt(2, contractObject.getPosition());
            ps.setInt(3, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    contrObjectId = rs.getInt(1);
                    contrObjectPos = rs.getInt(2);
                    update = true;
                }
            }
        }
        if (update) {
            query = "UPDATE " + this.tableName + " SET pos=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, contractObject.getPosition());
                ps.setInt(2, contrObjectId);
                ps.executeUpdate();
                ps.setInt(1, contrObjectPos);
                ps.setInt(2, id);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    public String getObjectParamTitle(int objectId, int paramId) throws Exception {
        ContractObject object = (ContractObject)((Object)this.get(objectId));
        ObjectParam objectParam = new ObjectParamDao(this.con).getParameter(paramId);
        Map<Integer, ParamValue> valuesMap = new ParamValueManager(this.con).getObjectParamMap(objectId);
        ParamValue value = valuesMap.get(paramId);
        if (object != null && objectParam != null && value != null) {
            switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)objectParam.getTypeId()).get()) {
                case TEXT: {
                    return ((ParamTextValue)value).getValue();
                }
                case BOOLEAN: {
                    return String.valueOf(((ParamFlagValue)value).getValue());
                }
                case ADDRESS: {
                    return ((ParamAddressValue)value).getAddress();
                }
                case DATE: {
                    return TimeUtils.formatDate(((ParamDateValue)value).getValue());
                }
                case LIST: {
                    Map listValuesMap = new ListValueManager(this.con).getValuesMap();
                    ListValue listValue = (ListValue)listValuesMap.get(((ParamListValue)value).getValue());
                    if (listValue != null) {
                        return listValue.getTitle();
                    }
                    return "???";
                }
            }
        }
        return null;
    }

    public void saveTitleByMacros(ContractObject object) throws Exception {
        String generateTitle = this.generateTitle(object);
        if (!object.getTitle().equals(generateTitle)) {
            object.setTitle(generateTitle);
            this.update((Object)object);
        }
    }

    public String generateTitle(ContractObject object) throws Exception {
        String title = object.getTitle();
        ObjectType type = new ObjectTypeManager(this.con).getType(object.getTypeId());
        if (type == null) {
            throw new BGRuntimeException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430!");
        }
        String macros = type.getNameMakros();
        if (Utils.isBlankString(macros)) {
            return title;
        }
        Pattern pattern = Pattern.compile("\\$\\{([\\w:]+)\\}");
        Matcher m = pattern.matcher(macros);
        StringBuffer result = new StringBuffer();
        int end = 0;
        while (m.find()) {
            int start = m.start();
            result.append(macros.substring(end, start));
            result.append(this.processMacros(m.group(1), type, object));
            end = m.end();
        }
        result.append(macros.substring(end, macros.length()));
        title = result.toString();
        return title;
    }

    private String processMacros(String macros, ObjectType type, ContractObject object) throws Exception {
        String result = "";
        ParamValueManager valueManager = new ParamValueManager(this.con);
        try (ContractObjectDao contractObjectDao = new ContractObjectDao(this.con, 0);){
            if (macros.equals("type")) {
                result = type.getTitle();
            } else if (macros.equals("id")) {
                result = String.valueOf(object.getId());
            } else if (macros.startsWith("address:")) {
                ParamAddressValue value = valueManager.getAddressParamValue(object.getId(), this.getParamId(macros));
                if (value != null) {
                    result = value.getAddress();
                }
            } else if (macros.startsWith("date:")) {
                result = contractObjectDao.optObjectParameterDateAsDate(object.getId(), this.getParamId(macros)).map(a -> TimeUtils.formatDate(a)).orElse(result);
            } else if (macros.startsWith("text:")) {
                result = contractObjectDao.optObjectParameterTextAsString(object.getId(), this.getParamId(macros)).orElse(result);
            } else if (macros.startsWith("list:")) {
                result = contractObjectDao.optObjectParameterListAsString(object.getId(), this.getParamId(macros)).orElse(result);
            }
        }
        return result;
    }

    private int getParamId(String str) {
        int result = 0;
        int pos = str.indexOf(58);
        if (pos > 0 && pos < str.length() - 1) {
            result = Utils.parseInt(str.substring(pos + 1), 0);
        }
        return result;
    }
}

