/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.action.apps;

import java.math.BigDecimal;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.container.service.server.ServiceFactory;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.BalanceDetailItem;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractBalance;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.BalanceService;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.modules.mobile.server.bean.AbstractAction;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class ActionMonthBalance
extends AbstractAction {
    public void execute() throws Exception {
        Map<Integer, BigDecimal> balanceMap;
        int yy = Utils.parseInt((String)this.req.get("yy"));
        int mm = Utils.parseInt((String)this.req.get("mm"));
        boolean init = this.req.getBoolean("init", false);
        boolean withDetail = this.req.getBoolean("withDetail", false);
        if (yy < 1 || mm < 1) {
            Calendar calendar = Calendar.getInstance();
            yy = calendar.get(1);
            mm = calendar.get(2) + 1;
        }
        List<BalanceDetailItem> detail = null;
        try (BalanceDao balanceDao = new BalanceDao(this.con);){
            ContractBalance balance = balanceDao.getContractBalance(this.contractId, yy, mm);
            int requestM = yy * 12 + mm;
            int resultM = balance.getYear() * 12 + balance.getMonth();
            int defM = requestM - resultM;
            if (defM != 0) {
                Calendar calendar = Calendar.getInstance();
                int nowM = calendar.get(1) * 12 + calendar.get(2) + 1;
                if (nowM >= requestM) {
                    balance.setYear(yy);
                    balance.setMonth(mm);
                    balance.setIncomingSaldo(balance.toBalance());
                    balance.setPayments(BigDecimal.ZERO);
                    balance.setCharges(BigDecimal.ZERO);
                    balance.setAccounts(BigDecimal.ZERO);
                    balance.setReserve(BigDecimal.ZERO);
                    if (withDetail) {
                        detail = Arrays.asList(new BalanceDetailItem(7, calendar.getTime(), balance.toBalance()), new BalanceDetailItem(8, calendar.getTime(), balance.toBalance()));
                        this.actionMap.put("detail", detail);
                    }
                }
            } else if (withDetail) {
                Period period = new Period(yy, mm - 1, 1, 31);
                BalanceService balanceService = (BalanceService)this.context.getService(BalanceService.class, 0);
                detail = balanceService.balanceDetailList(this.contractId, period, true);
            }
            this.actionMap.put("balance", balance);
            if (detail != null && detail.size() > 0) {
                ArrayList<1> list = new ArrayList<1>(detail.size());
                for (final BalanceDetailItem d : detail) {
                    HashMap<String, Object> item = new HashMap<String, Object>(){
                        {
                            this.put("type", d.getType());
                            this.put("title", d.getTitle());
                            this.put("sum", d.getSum());
                            this.put("sumAfterChange", d.getSumAfterChange());
                            this.put("date", d.getDate());
                            if (!ActionMonthBalance.this.contract.getTitle().equals(d.getContractTitle())) {
                                this.put("contract", d.getContractTitle());
                            }
                        }
                    };
                    list.add(item);
                }
                this.actionMap.put("detail", list);
            }
            this.actionMap.put("year", balance.getYear());
            this.actionMap.put("month", balance.getMonth());
            this.actionMap.put("incomingSaldo", balance.getIncomingSaldo());
            this.actionMap.put("accounts", balance.getAccounts());
            this.actionMap.put("payments", balance.getPayments());
            this.actionMap.put("charges", balance.getCharges());
            this.actionMap.put("reserve", balance.getReserve());
        }
        if (init && (this.contract.isSuper() || this.contract.isIndependSub()) && (balanceMap = this.getBalanceMap()) != null && balanceMap.size() > 0) {
            this.actionMap.put("balanceMap", balanceMap);
        }
    }

    private Map<Integer, BigDecimal> getBalanceMap() throws Exception {
        ContractService contractService = (ContractService)ServiceFactory.newService(ContractService.class, (int)0);
        BalanceService balanceService = (BalanceService)ServiceFactory.newService(BalanceService.class, (int)0);
        HashMap<Integer, BigDecimal> balanceMap = new HashMap<Integer, BigDecimal>();
        Contract superContract = this.contract;
        if (superContract.isSub() && (superContract = contractService.contractGet(this.contract.getSuperContractId())) == null) {
            return null;
        }
        YearMonth currentYearMonth = YearMonth.now();
        int year = currentYearMonth.getYear();
        int month = currentYearMonth.getMonthValue();
        List subList = contractService.contractSubList(superContract.getId(), 1, true, null);
        for (Contract subContract : subList) {
            BigDecimal balance;
            ContractBalance result = balanceService.contractBalanceGet(subContract.getId(), year, month);
            if (result.getYear() != year || result.getMonth() != month) {
                ContractBalance newResult = new ContractBalance();
                newResult.setYear(year);
                newResult.setMonth(month);
                newResult.setIncomingSaldo(result.toBalance());
                newResult.setPayments(BigDecimal.ZERO);
                newResult.setCharges(BigDecimal.ZERO);
                newResult.setAccounts(BigDecimal.ZERO);
                newResult.setReserve(BigDecimal.ZERO);
                balance = subContract.getBalanceMode() == 0 ? newResult.toSaldo() : newResult.toBalance();
            } else {
                balance = subContract.getBalanceMode() == 0 ? result.toSaldo() : result.toBalance();
            }
            balanceMap.put(subContract.getId(), balance);
        }
        return balanceMap;
    }
}

