/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.generator.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.generator.common.bean.BGGenerator;
import ru.bitel.bgbilling.kernel.generator.common.bean.enums.BGGeneratorType;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class BGGeneratorDao
extends AbstractIdDao<BGGenerator> {
    public BGGeneratorDao(Connection con) {
        super(con, "counter_generator");
    }

    public List<BGGenerator> list(BGGeneratorType generatorType) throws SQLException {
        return this.list("generator_type=?", "title", new Object[]{generatorType.name()});
    }

    protected BGGenerator getFromRS(ResultSet rs) throws SQLException {
        return new BGGenerator().setId(rs.getInt("id")).setTitle(rs.getString("title")).setPattern(rs.getString("pattern")).setSequenceId(rs.getInt("sequence_id")).setGeneratorType(BGGeneratorType.valueOf(rs.getString("generator_type")));
    }

    protected void updateImpl(BGGenerator generator) throws SQLException {
        String querySet = "title=?, pattern=?, sequence_id=?, generator_type=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)generator, querySet);){
            int index = 1;
            ps.setString(index++, generator.getTitle());
            ps.setString(index++, generator.getPattern());
            ps.setInt(index++, generator.getSequenceId());
            ps.setString(index++, generator.getGeneratorType().name());
            this.executeUpdate((Id)generator, index, ps);
        }
    }
}

