/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSAction;

public class UserPermitionsManager {
    private static final Logger logger = LogManager.getLogger((String)UserPermitionsManager.class.getSimpleName());
    private Connection con;
    private static final String TABLE_NAME = "bgs_user_action";

    public UserPermitionsManager(Connection con) {
        this.con = con;
    }

    public List<BGSAction> getUserActions(int userId) throws SQLException {
        return this.getActions(userId, true);
    }

    public List<BGSAction> getActions(int id, boolean byUserId) throws SQLException {
        String where = byUserId ? " WHERE uid=?" : " WHERE bgs_action_group_id=?";
        ArrayList<BGSAction> result = new ArrayList<BGSAction>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM bgs_user_action" + where);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    BGSAction action = new BGSAction();
                    this.loadFromRS(rs, action);
                    result.add(action);
                }
            }
        }
        return result;
    }

    public void updateUserActions(int id, List<BGSAction> values, boolean updateByUser) {
        PreparedStatement ps;
        String condition;
        String string = condition = updateByUser ? "uid=?" : "bgs_action_group_id=?";
        if (id > 0) {
            try {
                ps = this.con.prepareStatement("DELETE FROM bgs_user_action WHERE " + condition);
                try {
                    ps.setInt(1, id);
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        try {
            ps = this.con.prepareStatement("INSERT INTO bgs_user_action SET " + condition + ", mid=?, aid=?");
            try {
                ps.setInt(1, id);
                for (BGSAction action : values) {
                    ps.setString(2, action.mid);
                    ps.setString(3, action.actionID);
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private void loadFromRS(ResultSet rs, BGSAction action) throws SQLException {
        action.mid = rs.getString("mid");
        action.actionID = rs.getString("aid");
    }
}

