/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.client.payments;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDateTime;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.megafon.client.payments.MegafonPaymentsPanel;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonPayment;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class MegafonPaymentsTablePanel
extends BGUPanel {
    private final MegafonPaymentsPanel parentPanel;
    private PaymentsTableModel tableModel;
    private final JLabel recordCountLabel = new JLabel();
    private final BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private final BGControlPanelPages page = new BGControlPanelPages();

    public MegafonPaymentsTablePanel(MegafonPaymentsPanel parentPanel) {
        this.parentPanel = parentPanel;
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JButton search = new JButton("\u041f\u043e\u0438\u0441\u043a");
        search.addActionListener(e -> this.loadPayments());
        this.tableModel = new PaymentsTableModel();
        final BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem cancel = new JMenuItem("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436");
                    cancel.addActionListener(ev -> MegafonPaymentsTablePanel.this.cancelPayment());
                    menu.add(cancel);
                    menu.show((Component)table, e.getX(), e.getY());
                }
            }
        });
        this.periodPanel.setDateFrom(new Date());
        this.add((Component)this.periodPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 3, 0), 0, 0));
        this.add(search, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 0), 0, 0));
        this.add(this.getFilterPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 0), 0, 0));
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void cancelPayment() {
        MegafonPayment payment = (MegafonPayment)this.tableModel.getSelectedRow();
        if (payment == null) {
            return;
        }
        LocalDateTime paymentTime = payment.getPaymentDate();
        if (ClientUtils.confirm((String)"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436?", (String)"\u041e\u0442\u043c\u0435\u043d\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430")) {
            try {
                this.parentPanel.getMegafonService().cancelPayment(payment);
                this.performAction("refresh");
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
    }

    private JPanel getFilterPanel() {
        this.page.init();
        this.page.addToHandler(a -> {
            if (this.tableModel.getRowCount() > 0) {
                this.loadPayments();
            }
        });
        GridBagConstraints constraints = new GridBagConstraints(-1, 0, 1, 0, 0.0, 1.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0);
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)this.recordCountLabel, constraints);
        filterPanel.add((Component)this.page, constraints);
        return filterPanel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.loadPayments());
    }

    private void loadPayments() {
        Period period = this.periodPanel.getPeriod();
        if (period.getDateFrom() == null && period.getDateTo() != null || period.getDateTo() != null && period.getDateFrom().after(period.getDateTo())) {
            BGToolTip.showErrorMessage((JComponent)this.periodPanel, (String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
            return;
        }
        try {
            SearchResult searchResult = this.parentPanel.getMegafonService().getMegafonPayments(this.page.getPage(), period.getLocalDateFrom(), period.getLocalDateTo());
            this.tableModel.setData(searchResult.getList());
            this.page.setPage(searchResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private static final class PaymentsTableModel
    extends BGTableModel<MegafonPayment> {
        public PaymentsTableModel() {
            super("megafonPaymentsTable");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", -1, -1, -1, "contractId", true);
            this.addColumn("MSISDN", -1, -1, -1, "msisdn", false);
            this.addColumn("\u041d\u043e\u043c\u0435\u0440 \u0447\u0435\u043a\u0430", -1, -1, -1, "checkNumber", false);
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", -1, -1, -1, "amount", false);
            this.addColumn("\u0414\u0430\u0442\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430", -1, -1, -1, "paymentDate", false);
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, -1, -1, "status", false);
        }

        public Object getValueAt(MegafonPayment val, int column) throws Exception {
            return switch (column) {
                case 5 -> TimeUtils.format((LocalDateTime)val.getPaymentDate(), (String)"dd.MM.yyyy HH:mm:ss");
                case 6 -> {
                    if (val.getStatus() != null) {
                        yield val.getStatus().getComment();
                    }
                    yield "<\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d>";
                }
                default -> super.getValueAt((Object)val, column);
            };
        }
    }
}

