/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.tariff;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayServiceCost;
import ru.bitel.common.sql.ConnectionSet;

public class NPayTariffRequest
extends AbstractTariffRequest<NPayServiceCost> {
    private Calendar tariffDateFrom;
    private Calendar tariffDateTo;
    protected Calendar monthStart;
    protected Calendar monthEnd;
    private ServiceObject serviceObject;
    private int calculateModeLog = -1;
    private Map<Integer, BigDecimal> dayDetailLog = new HashMap<Integer, BigDecimal>();
    private Map<String, String> config = new HashMap<String, String>();

    public NPayTariffRequest(int domainId, int moduleId, ServiceObject serviceObject) {
        super(domainId, moduleId, serviceObject.getContractId(), new ArrayList(), (long)serviceObject.getServiceId(), null);
        this.serviceObject = serviceObject;
    }

    public void cleardayDetailLog() {
        this.dayDetailLog.clear();
    }

    public int getCalculateModeLog() {
        return this.calculateModeLog;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public Map<Integer, BigDecimal> getDayDetailLog() {
        return this.dayDetailLog;
    }

    public Calendar getMonthEnd() {
        return this.monthEnd;
    }

    public Calendar getMonthStart() {
        return this.monthStart;
    }

    public ServiceObject getServiceObject() {
        return this.serviceObject;
    }

    public Calendar getTariffDateFrom() {
        return this.tariffDateFrom;
    }

    public Calendar getTariffDateTo() {
        return this.tariffDateTo;
    }

    public boolean isAccepted() {
        boolean result = true;
        block0: for (List me : this.serviceCostMap.values()) {
            for (NPayServiceCost serviceCost : me) {
                if (result = result && serviceCost.getCost() != null) continue;
                break block0;
            }
        }
        return result;
    }

    public NPayTariffRequest setAccountingMonthDays(int accountingMonthDays) {
        super.setAccountingMonthDays(accountingMonthDays);
        return this;
    }

    public void setCalculateModeLog(int calculateModeLog) {
        this.calculateModeLog = calculateModeLog;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public NPayTariffRequest setConnectionSet(ConnectionSet connectionSet) {
        super.setConnectionSet(connectionSet);
        return this;
    }

    public void setDayDetailLog(int day, BigDecimal cost) {
        this.dayDetailLog.put(day, cost);
    }

    public NPayTariffRequest setInfoEnable(boolean value) {
        super.setInfoEnable(value);
        return this;
    }

    public NPayTariffRequest setMonthEnd(Calendar monthEnd) {
        this.monthEnd = monthEnd;
        return this;
    }

    public NPayTariffRequest setMonthStart(Calendar monthStart) {
        this.monthStart = monthStart;
        return this;
    }

    public NPayTariffRequest setTariffDateFrom(Calendar tariffDateFrom) {
        this.tariffDateFrom = tariffDateFrom;
        return this;
    }

    public NPayTariffRequest setTariffDateTo(Calendar tariffDateTo) {
        this.tariffDateTo = tariffDateTo;
        return this;
    }

    public NPayTariffRequest setTime(Calendar time) {
        super.setTime(time);
        return this;
    }

    public NPayTariffRequest setServiceCost(Integer serviceId, List<NPayServiceCost> serviceCostList) {
        super.setServiceCost(serviceId, serviceCostList);
        return this;
    }

    public NPayTariffRequest setTariffTreeSetEntry(TariffModuleTreeSet.Entry tariffTreeSetEntry) throws SQLException {
        super.setTariffTreeSetEntry(tariffTreeSetEntry);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("accepted => ").append(this.isAccepted()).append("\n").append(super.toString());
        return sb.toString();
    }
}

