/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.table;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterGroup;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterProblem;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterGroupManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterProblemManager;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TableRegisterProblemHistory
extends BGTableInfoBase {
    public TableRegisterProblemHistory() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnDateTime((String)"\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", (String)"change_time").setWidth(135), BGUTableColumn.buildColumnTextCenter((String)"\u041a\u0442\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u043b", (String)"change_user").setWidth(150), BGUTableColumn.buildColumnTextColorCenter((String)"\u0421\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u044c", (String)"urgency").setWidth(70), BGUTableColumn.buildColumnTextCenter((String)"\u0413\u0440\u0443\u043f\u043f\u0430", (String)"group").setWidth(100), BGUTableColumn.buildColumnTextCenter((String)"\u0421\u0442\u0430\u0442\u0443\u0441", (String)"status").setWidth(100), BGUTableColumn.buildColumnTextCenter((String)"\u0421\u0442\u0430\u0442\u0443\u0441(\u043f\u043e\u043b\u044c\u0437\u043e\u0432.)", (String)"status_user").setWidth(150), BGUTableColumn.buildColumnTextCenter((String)"\u0421\u0442\u0430\u0442\u0443\u0441(\u0432\u0440\u0435\u043c\u044f)", (String)"status_time").setWidth(105), BGUTableColumn.buildColumnTextLeft((String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", (String)"comment").setMaxWidth(-1), BGUTableColumn.buildColumnId()};
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        Connection connection = serverContext.getConnection();
        BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.crm");
        int id = Utils.parseInt((String)tableParams.get("id"));
        RegisterProblemManager manager = new RegisterProblemManager(connection);
        List<RegisterProblem> history = manager.getProblemHistory(id);
        Map<Integer, RegisterGroup> groupMap = new RegisterGroupManager(connection).getGroupMap();
        String statusList = plugin.getSetup().get("register.problem.status.list", "0:\u043e\u0442\u043a\u0440\u044b\u0442\u0430;1:\u043f\u0440\u0438\u043d\u044f\u0442\u0430;2:\u0437\u0430\u043a\u0440\u044b\u0442\u0430");
        Map<Integer, String> statusMap = RegisterProblemManager.getStatusMap(statusList);
        ArrayList<BGUTableRowData> tableRowDatas = new ArrayList<BGUTableRowData>();
        for (RegisterProblem ri : history) {
            BGUTableRowData rowData = new BGUTableRowData().addValue("urgency", String.valueOf(ri.getUrgency()), this.getUrgencyColor(ri.getUrgency())).addValue("change_time", ri.getValue("changeTime")).addValue("change_user", UserMap.getUser((Integer)Utils.parseInt((String)ri.getValue("changeUid"))).getName()).addValue("group", Optional.ofNullable(groupMap.get(ri.getGroupId())).map(a -> a.getTitle()).orElse("ID#" + ri.getGroupId())).addValue("status", statusMap.get(ri.getStatus())).addValue("status_user", UserMap.getUser((Integer)ri.getStatusUserId()).getName()).addValue("status_time", TimeUtils.format((Date)ri.getStatusTime(), (String)"dd.MM.yy HH:mm")).addValue(this.getComment(ri.getComment())).addValue(this.getId(ri.getId()));
            tableRowDatas.add(rowData);
        }
        return tableRowDatas;
    }

    private String getUrgencyColor(int urgency) {
        String[] colors = new String[]{"ffffff", "00ff00", "ffff00", "ffC800", "ff0000"};
        int result = 0;
        if (urgency <= 2 && urgency >= -2) {
            result = Integer.parseInt(colors[urgency + 2], 16);
        }
        return String.valueOf(result);
    }
}

