/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate.day;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.TrafficMaxTarifficationManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMax;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class TrafficMaxTarrificationDayManager
extends TrafficMaxTarifficationManager {
    private int day;

    public TrafficMaxTarrificationDayManager(int moduleId, Date month, int day) throws BGException {
        super(moduleId, month);
        this.day = day;
    }

    @Override
    protected TrafficMax getMaxTraffic(InetTariffWorkerContext workerContext, int contractId, long accountingPeriodFrom, long treeNodeId, long key, Calendar time) throws BGException {
        TrafficMax max = super.getMaxTraffic(workerContext, contractId, accountingPeriodFrom, treeNodeId, key, time);
        String tableName = ServerUtils.getModuleMonthTableName((String)"inet_tariff_traffic_max_detail", (Date)this.month, (int)this.moduleId);
        try {
            String query = "SELECT SUM(amountMax), SUM(amount1), SUM(amount2)  FROM " + tableName + " WHERE contractId=? AND treeNodeId=? AND maxKey=?  AND  day < ?";
            ResultSet rs = workerContext.getPSCache().execute(query, new Object[]{contractId, treeNodeId, key, this.day});
            if (rs.next()) {
                max.amountMax += rs.getLong(1);
                max.amount1 += rs.getLong(2);
                max.amount2 += rs.getLong(3);
            }
            return max;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

