/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.news.server.service;

import jakarta.jws.WebService;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.plugins.news.common.bean.News;
import ru.bitel.bgbilling.plugins.news.common.bean.NewsItem;
import ru.bitel.bgbilling.plugins.news.common.service.NewsService;
import ru.bitel.bgbilling.plugins.news.server.bean.NewsManager;
import ru.bitel.bgbilling.plugins.news.server.event.NewsModifiedEvent;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.news.common.service.NewsService")
public class NewsServiceImpl
extends AbstractService
implements NewsService {
    private NewsManager newsManager;

    public News newsGet(int id) throws BGException {
        return (News)this.tryReturn(() -> (News)this.getNewsManager().get(id));
    }

    public int newsUpdate(News news) throws BGException {
        return (Integer)this.tryReturn(() -> {
            boolean isNew = news.getId() == 0;
            this.getNewsManager().update(news);
            EventProcessor.getInstance().request((QueueEvent)new NewsModifiedEvent(this.userId, news.getId(), isNew));
            return news.getId();
        });
    }

    public List<News> newsList(Page page) throws BGException {
        return (List)this.tryReturn(() -> this.getNewsManager().list(page));
    }

    public List<News> newsListForContract(int contractId, Page page) throws BGException {
        return this.getNewsManager().getNewsList(this.context.getSetup(), page, contractId);
    }

    public void newsDelete(int id) throws BGException {
        this.tryCall(() -> {
            this.getNewsManager().delete(id);
            EventProcessor.getInstance().request((QueueEvent)new NewsModifiedEvent(this.userId, id));
        });
    }

    public SearchResult<NewsItem> newsSearch(Page page) throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult searchResult = new SearchResult(page);
            this.getNewsManager().search((SearchResult<NewsItem>)searchResult);
            return searchResult;
        });
    }

    private NewsManager getNewsManager() {
        this.newsManager = new NewsManager(this.getConnection());
        return Optional.ofNullable(this.newsManager).orElse(this.newsManager);
    }
}

