/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.tariff.tree;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.common.ParameterMap;

public class SmartHouseMultOptionCostTariffTreeNode
extends DefaultTariffTreeNode<AbstractTariffRequest<ServiceCost>, TariffContext> {
    private final BigDecimal multiplicand;

    public SmartHouseMultOptionCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.multiplicand = parameterMap.getBigDecimal("value", BigDecimal.ONE);
    }

    public int executeImpl(Long treeNodeId, AbstractTariffRequest<ServiceCost> tariffRequest, TariffContext tariffContext) {
        int result;
        if (tariffRequest.serviceCost != null) {
            if (tariffRequest.serviceCost.getCost() != null) {
                tariffRequest.serviceCost.setCost(tariffRequest.serviceCost.getCost().multiply(this.multiplicand, tariffContext.mc));
                result = 1;
            } else {
                result = 0;
            }
        } else {
            result = 0;
            for (Map.Entry e : tariffRequest.getServiceCost().entrySet()) {
                List serviceCostList = (List)e.getValue();
                if (serviceCostList == null) continue;
                int jsize = serviceCostList.size();
                for (int j = 0; j < jsize; ++j) {
                    ServiceCost serviceCost = (ServiceCost)serviceCostList.get(j);
                    if (serviceCost.getCost() == null) continue;
                    result = 1;
                    if (BigDecimal.ZERO.compareTo(serviceCost.getCost()) == 0) continue;
                    serviceCost.setCost(serviceCost.getCost().multiply(this.multiplicand, tariffContext.mc));
                }
            }
        }
        return result;
    }
}

