/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvServiceCost;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.common.ParameterMap;

public class ServiceSetTariffTreeNode
extends DefaultTariffTreeNode<TvTariffRequest, TariffContext> {
    private static final Logger logger = LogManager.getLogger();
    private final Integer serviceId;

    public ServiceSetTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.serviceId = parameterMap.getInt("serviceId", 0);
    }

    protected int executeImpl(Long treeNodeId, TvTariffRequest req, TariffContext ctx) {
        if (req.serviceCost == null) {
            logger.error("ServiceSetTariffTreeNode must be in ProductTariffTreeNode!");
            throw new BGRuntimeException("\u0412\u0435\u0442\u043a\u0430 \"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0443\u0441\u043b\u0443\u0433\u0438\" \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0432\u043d\u0443\u0442\u0440\u0438 \u0432\u0435\u0442\u043a\u0438 \"\u041f\u0440\u043e\u0434\u0443\u043a\u0442\".");
        }
        ((TvServiceCost)req.serviceCost).setServiceId(this.serviceId);
        return 1;
    }

    public static void serviceSet(TvTariffRequest req, TvServiceCost cost, int serviceId) {
        Map costMap = req.getServiceCost();
        List serviceCosts = (List)costMap.get(cost.getServiceId());
        List<TvServiceCost> newServiceCosts = (ArrayList<TvServiceCost>)costMap.get(serviceId);
        if (serviceCosts != null) {
            if (newServiceCosts == null) {
                if (serviceCosts.size() == 1 && serviceCosts.get(0) == cost) {
                    costMap.remove(cost.getServiceId());
                    newServiceCosts = serviceCosts;
                } else {
                    serviceCosts.remove((Object)cost);
                    newServiceCosts = new ArrayList(4);
                    newServiceCosts.add(cost);
                }
                cost.setServiceId(serviceId);
                costMap.put(serviceId, newServiceCosts);
            } else {
                serviceCosts.remove((Object)cost);
                cost.setServiceId(serviceId);
                newServiceCosts.add(cost);
            }
        } else if (newServiceCosts == null) {
            newServiceCosts = new ArrayList<TvServiceCost>(4);
            newServiceCosts.add(cost);
            cost.setServiceId(serviceId);
            costMap.put(serviceId, newServiceCosts);
        } else {
            cost.setServiceId(serviceId);
            newServiceCosts.add(cost);
        }
    }
}

