/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptTariffContext;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstarctDaoConstant;
import ru.bitel.common.sql.ConnectionSet;

public class TariffRequestManager
extends AbstarctDaoConstant {
    private Connection con;
    private ConnectionSet connectionSet = null;
    private int mid;
    private HashMap<Calendar, TariffModuleTreeSet> contractTreeSets = new HashMap(8);

    public TariffRequestManager(ConnectionSet connectionSet, int mid) {
        this.connectionSet = connectionSet;
        this.con = connectionSet.getConnection();
        this.mid = mid;
    }

    public Set<Integer> getMultiroomIgnorePacket(ParameterMap moduleSetup, int contractId, Calendar date) throws BGException {
        try (TariffModuleTreeSetDao tariffModuleTreeSetDao = new TariffModuleTreeSetDao(this.con);){
            CerbercryptTariffContext context = new CerbercryptTariffContext(date.getTime(), contractId);
            TariffModuleTreeSet treeSet = tariffModuleTreeSetDao.getRealtimeTariffTreeSet(contractId, date.getTime(), "cerbercrypt", this.mid, 0, 0);
            TariffModuleTree tree = treeSet.getTree(date);
            if (tree != null) {
                CerbercryptTariffRequest tariffRequest = new CerbercryptTariffRequest(this.connectionSet, 0, this.mid, contractId, new ArrayList<Integer>());
                tariffRequest.setCheckUpdatePacket(true);
                tariffRequest.setTime(date);
                tree.execute((AbstractTariffRequest)tariffRequest, (TariffContext)context);
                Set<Integer> multiroomIgnorePackets = tariffRequest.getMultiroomIgnorePackets();
                if (multiroomIgnorePackets != null) {
                    HashSet<Integer> hashSet = new HashSet<Integer>(multiroomIgnorePackets);
                    return hashSet;
                }
            }
        }
        return null;
    }

    public Set<Integer> getPacketGroup(ParameterMap moduleSetup, int contractId, Calendar date) throws BGException {
        try (TariffModuleTreeSetDao tariffModuleTreeSetDao = new TariffModuleTreeSetDao(this.con);){
            CerbercryptTariffContext context = new CerbercryptTariffContext(date.getTime(), contractId);
            TariffModuleTreeSet treeSet = tariffModuleTreeSetDao.getRealtimeTariffTreeSet(contractId, date.getTime(), "cerbercrypt", this.mid, 0, 0);
            TariffModuleTree tree = treeSet.getTree(date);
            if (tree != null) {
                CerbercryptTariffRequest tariffRequest = new CerbercryptTariffRequest(this.connectionSet, 0, this.mid, contractId, new ArrayList<Integer>());
                tariffRequest.setCheckUpdatePacket(true);
                tariffRequest.setServiceId(moduleSetup.getInt("cerbercrypt.base_group.serviceId", -1));
                tariffRequest.setTime(date);
                tree.execute((AbstractTariffRequest)tariffRequest, (TariffContext)context);
                Set<Integer> packetGroup = tariffRequest.getPacketGroup();
                if (packetGroup != null) {
                    HashSet<Integer> hashSet = new HashSet<Integer>(packetGroup);
                    return hashSet;
                }
            }
        }
        return null;
    }

    public Set<Integer> getPacketsAutosync(ParameterMap moduleSetup, int contractId, Date date, AutosyncOnMode source) throws BGException {
        try (TariffModuleTreeSetDao tariffModuleTreeSetDao = new TariffModuleTreeSetDao(this.con);){
            CerbercryptTariffContext context = new CerbercryptTariffContext(date, contractId);
            TariffModuleTreeSet treeSet = tariffModuleTreeSetDao.getRealtimeTariffTreeSet(contractId, date, "cerbercrypt", this.mid, 0, 0);
            TariffModuleTree tree = treeSet.getTree(date);
            if (tree != null) {
                CerbercryptTariffRequest tariffRequest = new CerbercryptTariffRequest(this.connectionSet, 0, this.mid, contractId, new ArrayList<Integer>());
                tariffRequest.setCheckPacketsAutoSync(true);
                tariffRequest.setTime(TimeUtils.convertDateToCalendar((Date)date));
                tree.execute((AbstractTariffRequest)tariffRequest, (TariffContext)context);
                Set<Integer> packets_autosync = tariffRequest.getPacketsAutoSync();
                boolean on_card_add = tariffRequest.isPacketsAutoSyncOnCardAdd();
                boolean on_tariff_change = tariffRequest.isPacketsAutoSyncOnTariffChange();
                if (packets_autosync != null && (source == null || source == AutosyncOnMode.ONCARDADD && on_card_add || source == AutosyncOnMode.ONTARIFFCHANGE && on_tariff_change)) {
                    HashSet<Integer> hashSet = new HashSet<Integer>(packets_autosync);
                    return hashSet;
                }
            }
        }
        return null;
    }

    public float getSubscriptionCost(int contractId, Date date, Map<Integer, Packet> packetMap, List<CardPacket> cardPacketList, boolean check) throws BGException {
        TariffModuleTree tree;
        float result = 0.0f;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int daysInMonth = ((Calendar)calendar).getActualMaximum(5);
        CerbercryptTariffContext context = new CerbercryptTariffContext(calendar.getTime(), contractId);
        TariffModuleTreeSet treeSet = this.contractTreeSets.get(calendar);
        if (treeSet == null) {
            try (TariffModuleTreeSetDao tariffModuleTreeSetDao = new TariffModuleTreeSetDao(this.con);){
                treeSet = tariffModuleTreeSetDao.getRealtimeTariffTreeSet(contractId, calendar.getTime(), "cerbercrypt", this.mid, 0, 0);
                this.contractTreeSets.put(calendar, treeSet);
            }
        }
        if ((tree = treeSet.getTree(calendar.getTime())) != null) {
            Packet packet;
            ArrayList<Packet> packets = new ArrayList<Packet>(cardPacketList.size());
            for (CardPacket cardPacket : cardPacketList) {
                packet = new Packet();
                packet.setId(cardPacket.getPacketId());
                packets.add(packet);
            }
            for (CardPacket cardPacket : cardPacketList) {
                packet = packetMap.get(cardPacket.getPacketId());
                if (packet != null) {
                    CerbercryptTariffRequest tariffRequest = new CerbercryptTariffRequest(this.connectionSet, 0, this.mid, contractId, new ArrayList<Integer>());
                    tariffRequest.setPacket(packet.getId());
                    tariffRequest.setServiceId(packet.getServiceId());
                    tariffRequest.setPacketCount(cardPacketList.size());
                    tariffRequest.setPacketList(packets);
                    tariffRequest.setTime(TimeUtils.convertDateToCalendar((Date)date));
                    tree.execute((AbstractTariffRequest)tariffRequest, (TariffContext)context);
                    int costType = tariffRequest.getCostType();
                    BigDecimal cost = tariffRequest.getCost();
                    BigDecimal discount = tariffRequest.getDiscount();
                    Set<Integer> ignoreDiscountPackets = tariffRequest.getPacketsIgnoreDiscount();
                    if (!tariffRequest.isAccepted() || cost == null || costType <= 0) {
                        this.getLogger().error("Wrong tariff response: " + tariffRequest.toString());
                        if (!check) continue;
                        return Float.NaN;
                    }
                    float dayCost = 0.0f;
                    dayCost = costType == 1 ? cost.floatValue() : cost.floatValue() / (float)daysInMonth;
                    if (!(packet.isVirtualCinema() || discount == null || !(discount.floatValue() > 0.0f) || ignoreDiscountPackets != null && ignoreDiscountPackets.contains(packet.getId()))) {
                        dayCost *= 1.0f - discount.floatValue() / 100.0f;
                    }
                    result += dayCost;
                    continue;
                }
                if (!check) continue;
                return Float.NaN;
            }
        } else if (check) {
            return Float.NaN;
        }
        return result;
    }

    public static enum AutosyncOnMode {
        ONCARDADD,
        ONTARIFFCHANGE;

    }
}

