/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitMovement;
import ru.bitel.common.TimeUtils;

public class ContractLimitMovementDao
extends AbstractIdDao<ContractLimitMovement> {
    public ContractLimitMovementDao(Connection con) {
        super(con, "contract_limit_manage");
    }

    @Override
    protected ContractLimitMovement getFromRS(ResultSet rs) throws SQLException {
        return new ContractLimitMovement().setId(rs.getInt("id")).setAmount(rs.getBigDecimal("summ")).setDateFrom(TimeUtils.convertSqlDateToDate(rs.getDate("date1"))).setDateTo(TimeUtils.convertSqlDateToDate(rs.getDate("date2"))).setStatus(rs.getInt("status"));
    }

    public List<ContractLimitMovement> list(int contractId, Date dateFrom, Date dateTo) throws SQLException {
        java.sql.Date sqlDateFrom = TimeUtils.convertDateToSqlDate(dateFrom);
        java.sql.Date sqlDateTo = TimeUtils.convertDateToSqlDate(dateTo);
        return super.list("cid=? AND (? OR date1 IS NULL OR date1<=?) AND (? OR date2 IS NULL OR date2>=?)", "date1", contractId, sqlDateTo == null, sqlDateTo, sqlDateFrom == null, sqlDateFrom);
    }

    @Override
    protected void updateImpl(ContractLimitMovement b) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

