/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.autopayment.common.bean;

import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.math.BigDecimal;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;

@XmlSeeAlso(value={ContractAutopaymentModeAuto.class, ContractAutopaymentModePeriodic.class})
public abstract class ContractAutopaymentMode {
    private AutopaymentMode mode;

    public AutopaymentMode getMode() {
        return this.mode;
    }

    public void setMode(AutopaymentMode mode) {
        this.mode = mode;
    }

    public String toData() {
        return "";
    }

    public void toAutopayment(Autopayment autopayment) {
        autopayment.setMode(this.getMode());
        autopayment.setModeData(this.toData());
    }

    public static ContractAutopaymentMode getContractAutopaymentMode(ParameterMap moduleSetup, String prefix, ParameterMap defaultSetup, Autopayment autopayment) {
        if (autopayment.getMode() == null || autopayment.getMode() == AutopaymentMode.OFF) {
            return null;
        }
        ParameterMap modeData = new Preferences(autopayment.getModeData());
        moduleSetup = moduleSetup.sub(prefix);
        moduleSetup = defaultSetup.inherit(moduleSetup);
        modeData = moduleSetup.inherit(modeData);
        switch (autopayment.getMode()) {
            case WEEK: {
                ContractAutopaymentModePeriodic mode = new ContractAutopaymentModePeriodic();
                mode.setMode(AutopaymentMode.WEEK);
                mode.setDay(modeData.getInt("autopayment.mode.week.day", 1));
                mode.setSum(modeData.getBigDecimal("autopayment.mode.week.sum", BigDecimal.valueOf(50L)));
                return mode;
            }
            case MONTH: {
                ContractAutopaymentModePeriodic mode = new ContractAutopaymentModePeriodic();
                mode.setMode(AutopaymentMode.MONTH);
                mode.setDay(modeData.getInt("autopayment.mode.month.day", 1));
                mode.setSum(modeData.getBigDecimal("autopayment.mode.month.sum", BigDecimal.valueOf(50L)));
                return mode;
            }
            case AUTO: {
                ContractAutopaymentModeAuto mode = new ContractAutopaymentModeAuto();
                mode.setMode(AutopaymentMode.AUTO);
                mode.setDaySum(modeData.getBigDecimal("autopayment.mode.auto.day.sum", BigDecimal.valueOf(500L)));
                mode.setWeekSum(modeData.getBigDecimal("autopayment.mode.auto.week.sum", BigDecimal.valueOf(1000L)));
                mode.setMonthSum(modeData.getBigDecimal("autopayment.mode.auto.month.sum", BigDecimal.valueOf(3000L)));
                return mode;
            }
        }
        return null;
    }

    public static ContractAutopaymentMode fromAutopayment(Autopayment autopayment) {
        switch (autopayment.getMode()) {
            case AUTO: {
                Preferences params = new Preferences(autopayment.getModeData(), "\n");
                ContractAutopaymentModeAuto result = new ContractAutopaymentModeAuto();
                result.setMode(autopayment.getMode());
                result.setDaySum(params.getBigDecimal("autopayment.mode.auto.day.sum", BigDecimal.ZERO));
                result.setWeekSum(params.getBigDecimal("autopayment.mode.auto.week.sum", BigDecimal.ZERO));
                result.setMonthSum(params.getBigDecimal("autopayment.mode.auto.month.sum", BigDecimal.ZERO));
                return result;
            }
            case MONTH: {
                Preferences params = new Preferences(autopayment.getModeData(), "\n");
                ContractAutopaymentModePeriodic result = new ContractAutopaymentModePeriodic();
                result.setMode(autopayment.getMode());
                result.setDay(params.getInt("autopayment.mode.month.day", 1));
                result.setSum(params.getBigDecimal("autopayment.mode.month.sum", BigDecimal.ZERO));
                return result;
            }
            case WEEK: {
                Preferences params = new Preferences(autopayment.getModeData(), "\n");
                ContractAutopaymentModePeriodic result = new ContractAutopaymentModePeriodic();
                result.setMode(autopayment.getMode());
                result.setDay(params.getInt("autopayment.mode.week.day", 1));
                result.setSum(params.getBigDecimal("autopayment.mode.week.sum", BigDecimal.ZERO));
                return result;
            }
        }
        return null;
    }

    public static class ContractAutopaymentModePeriodic
    extends ContractAutopaymentMode {
        private int day;
        private BigDecimal sum;
        private BigDecimal sumMin;
        private BigDecimal sumMax;

        public ContractAutopaymentModePeriodic() {
        }

        public ContractAutopaymentModePeriodic(AutopaymentMode mode) {
            if (mode == AutopaymentMode.MONTH || mode == AutopaymentMode.WEEK) {
                this.setMode(mode);
            }
        }

        public BigDecimal getSum() {
            return this.sum;
        }

        public ContractAutopaymentModePeriodic setSum(BigDecimal sumDefault) {
            this.sum = sumDefault;
            return this;
        }

        public int getDay() {
            return this.day;
        }

        public ContractAutopaymentModePeriodic setDay(int day) {
            this.day = day;
            return this;
        }

        public BigDecimal getSumMin() {
            return this.sumMin;
        }

        public ContractAutopaymentModePeriodic setSumMin(BigDecimal sumMin) {
            this.sumMin = sumMin;
            return this;
        }

        public BigDecimal getSumMax() {
            return this.sumMax;
        }

        public ContractAutopaymentModePeriodic setSumMax(BigDecimal sumMax) {
            this.sumMax = sumMax;
            return this;
        }

        @Override
        public String toData() {
            StringBuilder sb = new StringBuilder();
            switch (this.getMode()) {
                case WEEK: {
                    sb.append("autopayment.mode.week.day").append('=').append(this.day).append('\n');
                    sb.append("autopayment.mode.week.sum").append('=').append(this.sum.intValue());
                    break;
                }
                case MONTH: {
                    sb.append("autopayment.mode.month.day").append('=').append(this.day).append('\n');
                    sb.append("autopayment.mode.month.sum").append('=').append(this.sum.intValue());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return sb.toString();
        }

        @Override
        public void toAutopayment(Autopayment autopayment) {
            super.toAutopayment(autopayment);
            autopayment.setSum(this.sum);
        }
    }

    public static class ContractAutopaymentModeAuto
    extends ContractAutopaymentMode {
        private BigDecimal daySum;
        private BigDecimal daySumMax;
        private BigDecimal weekSum;
        private BigDecimal weekSumMax;
        private BigDecimal monthSum;
        private BigDecimal monthSumMax;

        public ContractAutopaymentModeAuto() {
            this.setMode(AutopaymentMode.AUTO);
        }

        public BigDecimal getDaySum() {
            return this.daySum;
        }

        public ContractAutopaymentModeAuto setDaySum(BigDecimal daySumDefault) {
            this.daySum = daySumDefault;
            return this;
        }

        public BigDecimal getDaySumMax() {
            return this.daySumMax;
        }

        public ContractAutopaymentModeAuto setDaySumMax(BigDecimal daySumMax) {
            this.daySumMax = daySumMax;
            return this;
        }

        public BigDecimal getWeekSum() {
            return this.weekSum;
        }

        public ContractAutopaymentModeAuto setWeekSum(BigDecimal weekSumDefault) {
            this.weekSum = weekSumDefault;
            return this;
        }

        public BigDecimal getWeekSumMax() {
            return this.weekSumMax;
        }

        public ContractAutopaymentModeAuto setWeekSumMax(BigDecimal weekSumMax) {
            this.weekSumMax = weekSumMax;
            return this;
        }

        public BigDecimal getMonthSum() {
            return this.monthSum;
        }

        public ContractAutopaymentModeAuto setMonthSum(BigDecimal monthSumDefault) {
            this.monthSum = monthSumDefault;
            return this;
        }

        public BigDecimal getMonthSumMax() {
            return this.monthSumMax;
        }

        public ContractAutopaymentModeAuto setMonthSumMax(BigDecimal monthSumMax) {
            this.monthSumMax = monthSumMax;
            return this;
        }

        @Override
        public String toData() {
            StringBuilder sb = new StringBuilder();
            switch (this.getMode()) {
                case AUTO: {
                    sb.append("autopayment.mode.auto.day.sum").append('=').append(this.daySum.intValue()).append('\n');
                    sb.append("autopayment.mode.auto.week.sum").append('=').append(this.weekSum.intValue()).append('\n');
                    sb.append("autopayment.mode.auto.month.sum").append('=').append(this.monthSum.intValue());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return sb.toString();
        }

        @Override
        public void toAutopayment(Autopayment autopayment) {
            super.toAutopayment(autopayment);
            autopayment.setSum(this.daySum);
        }
    }
}

