/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.service;

import jakarta.jws.WebService;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractService;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractServiceInstallment;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractServiceInstallmentStatus;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMServiceDto;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMCalculatorUtils;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMContractServiceManager;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMRecalculator;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMServiceManager;
import ru.bitel.bgbilling.modules.rscm.server.event.RSCMContractServiceUpdateEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.rscm.common.service.RSCMService")
public class RSCMServiceImpl
extends AbstractService
implements ru.bitel.bgbilling.modules.rscm.common.service.RSCMService {
    public SearchResult<RSCMContractService> searchRSCMContractService(int contractId, Period period, String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(page);
        searchResult.setSort(sort);
        try (RSCMContractServiceManager contractServiceManager = new RSCMContractServiceManager(this.getConnection(), this.moduleId);){
            searchResult.setList(contractServiceManager.getContractServiceList(contractId, period, page, true));
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return searchResult;
    }

    public SearchResult<RSCMService> searchRSCMService(String[] sort, Page page) throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult searchResult = new SearchResult(page);
            searchResult.setSort(sort);
            searchResult.getList().addAll(new RSCMServiceManager(this.getConnection(), this.moduleId).getServiceList());
            Page.setRecordCount((Page)page, (int)searchResult.getList().size());
            return searchResult;
        });
    }

    public RSCMContractService getRSCMContractService(int contractId, int rscmContractServiceId) throws BGException {
        RSCMContractService rSCMContractService;
        RSCMContractServiceManager contractServiceManager = new RSCMContractServiceManager(this.getConnection(), this.moduleId);
        try {
            rSCMContractService = contractServiceManager.getContractService(contractId, rscmContractServiceId);
        }
        catch (Throwable throwable) {
            try {
                try {
                    contractServiceManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        contractServiceManager.close();
        return rSCMContractService;
    }

    public RSCMService getRSCMService(int rscmServiceId) throws BGException {
        return (RSCMService)this.tryReturn(() -> new RSCMServiceManager(this.getConnection(), this.moduleId).getService(rscmServiceId));
    }

    public void updateRSCMContractService(RSCMContractService rscmContractService) throws BGException, BGMessageException {
        LocalDate now = LocalDate.now();
        Calendar closedDate = null;
        Connection con = this.getConnection();
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionContractServiceUpdate", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, null, (LocalDate)rscmContractService.getDate());
        }
        try (RSCMContractServiceManager contractServiceManager = new RSCMContractServiceManager(con, this.moduleId);){
            int amountDown;
            int amountUp;
            String error;
            boolean checklowerbound;
            int serviceId = rscmContractService.getServiceId();
            int contractId = rscmContractService.getContractId();
            LocalDate date = rscmContractService.getDate();
            if (this.getModuleSetup().getBoolean("hard.tariff.check", false)) {
                contractServiceManager.checkTariffsForService(contractId, serviceId, date, this.getConnectionSet());
            }
            JSONObject json = null;
            RSCMContractServiceInstallment rscmContractServiceInstallment = null;
            if (rscmContractService.getId() < 1) {
                int parts = 100;
                JSONArray paymentsArray = null;
                RSCMServiceManager rscmServiceManager = new RSCMServiceManager(con, this.moduleId);
                RSCMService rscmService = rscmServiceManager.getServiceByServiceId(serviceId);
                if (rscmService != null && rscmService.getInstallmentData() != null) {
                    json = new JSONObject(rscmService.getInstallmentData());
                    paymentsArray = json.optJSONArray("paymentsArray");
                    parts = json.optInt("parts");
                    if (parts < 1 && paymentsArray != null) {
                        int len = paymentsArray.length();
                        for (int index = 0; index < len; ++index) {
                            parts += paymentsArray.getInt(index);
                        }
                    }
                }
                if (rscmService != null && rscmService.getInstallmentData() != null) {
                    String paymentMode = json.optString("paymentMode", "month");
                    LocalDate dateNext = RSCMCalculatorUtils.getInstallmentPaymentNextDate(date, paymentMode);
                    if (date.isAfter(now)) {
                        dateNext = date;
                    }
                    int amountUp2 = 1;
                    int amountDown2 = 1;
                    if (rscmContractService.getAmountDown() == 1 || rscmContractService.getAmountDown() == parts) {
                        amountUp2 = rscmContractService.getAmountUp() * parts;
                        amountDown2 = parts;
                        rscmContractService.setAmountDown(parts);
                    } else {
                        amountUp2 = rscmContractService.getAmountUp() * parts;
                        amountDown2 = rscmContractService.getAmountDown() * parts;
                        rscmContractService.setAmountDown(amountDown2);
                        json.put("parts", rscmContractService.getAmountDown());
                    }
                    rscmContractServiceInstallment = new RSCMContractServiceInstallment().setContractId(contractId).setServiceId(serviceId).setDateFrom(date.isAfter(now) ? now : date).setDateNext(dateNext).setPaymentCount(date.isAfter(now) ? 0 : 1).setStatus(date.isAfter(now) ? RSCMContractServiceInstallmentStatus.NEW : RSCMContractServiceInstallmentStatus.IN_PROGRESS).setAmountUp(amountUp2).setAmountDown(amountDown2).setInstallment(json.toString());
                    rscmContractService.setComment(String.format("\u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0430. \u0412\u0437\u043d\u043e\u0441 [\u0447\u0430\u0441\u0442\u0435\u0439: %s/%s] => %s \u0438\u0437 %s ", paymentsArray.getInt(0) * amountUp2 / parts, rscmContractService.getAmountDown(), 1, paymentsArray.length()));
                    rscmContractService.setAmountUp(paymentsArray.getInt(0) * rscmContractService.getAmountUp());
                }
            }
            if ((checklowerbound = this.getModuleSetup().getBoolean("check.lower.bound", false)) && Utils.notBlankString((String)(error = contractServiceManager.checkBalanceForService(contractId, serviceId, amountUp = rscmContractService.getAmountUp(), amountDown = rscmContractService.getAmountDown(), date, rscmContractService.getCost(), this.getConnectionSet())))) {
                throw new BGMessageException(error);
            }
            if (rscmContractServiceInstallment != null) {
                contractServiceManager.updateRSCMContractServiceInstallment(rscmContractServiceInstallment);
                rscmContractService.setInstallmentId(rscmContractServiceInstallment.getId());
            }
            boolean publishAndHotCalc = false;
            if (rscmContractServiceInstallment == null) {
                publishAndHotCalc = true;
                contractServiceManager.updateContractService(rscmContractService);
            } else if (!date.isAfter(now)) {
                publishAndHotCalc = true;
                contractServiceManager.updateContractService(rscmContractService);
                if (rscmContractServiceInstallment != null) {
                    json = new JSONObject(rscmContractServiceInstallment.getInstallment());
                    JSONArray contractServiceIds = json.optJSONArray("contractServiceIds");
                    if (contractServiceIds == null) {
                        contractServiceIds = new JSONArray();
                        json.put("contractServiceIds", (Object)contractServiceIds);
                    }
                    contractServiceIds.put(rscmContractService.getId());
                    rscmContractServiceInstallment.setInstallment(json.toString());
                    contractServiceManager.updateRSCMContractServiceInstallment(rscmContractServiceInstallment);
                }
            }
            if (publishAndHotCalc) {
                this.context.publishAfterCommit((Event)new RSCMContractServiceUpdateEvent(this.userId, this.moduleId, contractId, rscmContractService));
                contractServiceManager.hotCalc(contractId, date, this.getConnectionSet());
            }
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateRSCMService(RSCMService rscmService) throws BGException {
        this.tryCall(() -> new RSCMServiceManager(this.getConnection(), this.moduleId).updateService(rscmService));
    }

    public void deleteRSCMContractService(int rscmContractServiceId, int contractId, LocalDate month) throws BGException {
        Connection con = this.getConnection();
        Calendar closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionContractServiceDelete", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (LocalDate)month, null);
        }
        try (RSCMContractServiceManager contractServiceManager = new RSCMContractServiceManager(con, this.moduleId);){
            contractServiceManager.deleteContractService(rscmContractServiceId, contractId, month);
            contractServiceManager.hotCalc(contractId, month, this.getConnectionSet());
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public void deleteRSCMService(int rscmServiceId) throws BGException {
        this.tryCall(() -> new RSCMServiceManager(this.getConnection(), this.moduleId).deleteService(rscmServiceId));
    }

    public void recalculate(Date startMonth, String email, List<Integer> contractIds) throws BGException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startMonth);
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new RSCMRecalculator(this.moduleId, calendar, email, Utils.toString(contractIds)));
    }

    public List<RSCMServiceDto> getRSCMContractServiceList(boolean isUsing) throws BGException {
        return (List)this.tryReturn(() -> {
            ArrayList idTitles = new ArrayList();
            new RSCMServiceManager(this.getConnection(), this.moduleId).getServiceList(isUsing).forEach(a -> {
                JSONObject json = new JSONObject(Optional.ofNullable(a.getInstallmentData()).orElse("{}"));
                idTitles.add(new RSCMServiceDto().setId(a.getServiceId()).setTitle(a.getServiceTitle() + " (" + a.getUnit() + ")").setInstallment(a.getInstallmentData() != null).setPayments(Optional.ofNullable(json.optJSONArray("paymentsArray")).orElse(new JSONArray()).length()).setPaymentMode(json.optString("paymentMode", "month")));
            });
            return idTitles;
        });
    }

    public List<IdTitle> getRSCMServiceList() throws BGException {
        return (List)this.tryReturn(() -> {
            ArrayList<IdTitle> items = new ArrayList<IdTitle>();
            List serviceList = ModuleCache.getInstance().getModuleServicesList(this.moduleId);
            List<RSCMService> rscmServiceList = new RSCMServiceManager(this.getConnection(), this.moduleId).getServiceList();
            int size_old = serviceList.size();
            int size_new = serviceList.size();
            for (Service service : serviceList) {
                for (RSCMService serv : rscmServiceList) {
                    if (service.getId() != serv.getServiceId()) continue;
                    size_new = size_old--;
                    break;
                }
                if (size_old < size_new) {
                    size_new = size_old;
                    continue;
                }
                items.add(new IdTitle(service.getId(), service.getTitle()));
            }
            return items;
        });
    }

    public SearchResult<RSCMContractServiceInstallment> searchRSCMContractServiceInstallment(int contractId, int status, String[] sort, Page page) throws BGException, BGMessageException {
        SearchResult searchResult = new SearchResult(page, sort);
        try (RSCMContractServiceManager contractServiceManager = new RSCMContractServiceManager(this.getConnection(), this.moduleId);){
            contractServiceManager.searchContractServiceInstallment((SearchResult<RSCMContractServiceInstallment>)searchResult, contractId, status, page);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return searchResult;
    }

    public void deleteRSCMContractServiceInstallment(int id, int contractId) throws BGException, BGMessageException {
        Connection con = this.getConnection();
        try (RSCMContractServiceManager rscmContractServiceManager = new RSCMContractServiceManager(con, this.moduleId);){
            RSCMContractServiceInstallment rscmContractServiceInstallment = rscmContractServiceManager.getContractServiceInstallment(id);
            if (rscmContractServiceInstallment != null) {
                if (rscmContractServiceInstallment.getDateFrom().isBefore(LocalDate.now().withDayOfMonth(1))) {
                    throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u0435\u043a \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0442\u0435\u043a\u0443\u0449\u0435\u043c \u043c\u0435\u0441\u044f\u0446\u0435");
                }
                if (rscmContractServiceInstallment.getPaymentCount() > 0) {
                    LocalDate now = LocalDate.now();
                    JSONObject json = new JSONObject(rscmContractServiceInstallment.getInstallment());
                    JSONArray serviceIds = json.optJSONArray("contractServiceIds");
                    if (serviceIds != null) {
                        for (int index = 0; index < serviceIds.length(); ++index) {
                            rscmContractServiceManager.deleteContractService(serviceIds.getInt(index), contractId, now);
                        }
                    }
                    rscmContractServiceManager.hotCalc(contractId, now, this.getConnectionSet());
                }
                rscmContractServiceManager.deleteContractServiceInstallment(id);
            }
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void infoRSCMContractServiceInstallment(int id) throws BGException, BGMessageException {
    }

    public void suspendRSCMContractServiceInstallment(int id) throws BGException, BGMessageException {
        Connection con = this.getConnection();
        try (RSCMContractServiceManager rscmContractServiceManager = new RSCMContractServiceManager(con, this.moduleId);){
            RSCMContractServiceInstallment rscmContractServiceInstallment = rscmContractServiceManager.getContractServiceInstallment(id);
            if (rscmContractServiceInstallment != null) {
                if (!rscmContractServiceInstallment.getStatus().equals((Object)RSCMContractServiceInstallmentStatus.IN_PROGRESS)) {
                    throw new BGMessageException("\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0443 \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u0442\u0435\u043a\u0443\u0449\u0430\u044f\"");
                }
                rscmContractServiceInstallment.setStatus(RSCMContractServiceInstallmentStatus.SUSPEND);
                rscmContractServiceInstallment.setDateNext(null);
                rscmContractServiceManager.updateRSCMContractServiceInstallment(rscmContractServiceInstallment);
            }
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void resumeRSCMContractServiceInstallment(int id) throws BGException, BGMessageException {
        Connection con = this.getConnection();
        try (RSCMContractServiceManager rscmContractServiceManager = new RSCMContractServiceManager(con, this.moduleId);){
            RSCMContractServiceInstallment rscmContractServiceInstallment = rscmContractServiceManager.getContractServiceInstallment(id);
            if (rscmContractServiceInstallment != null) {
                if (!rscmContractServiceInstallment.getStatus().equals((Object)RSCMContractServiceInstallmentStatus.SUSPEND)) {
                    throw new BGMessageException("\u0412\u043e\u0437\u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0443 \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u0430\u044f\"");
                }
                LocalDate dateNext = LocalDate.now();
                if (dateNext.getDayOfMonth() > rscmContractServiceInstallment.getDateFrom().getDayOfMonth()) {
                    dateNext = dateNext.withDayOfMonth(1).plusMonths(1L);
                }
                dateNext = dateNext.withDayOfMonth(Math.min(rscmContractServiceInstallment.getDateFrom().getDayOfMonth(), dateNext.lengthOfMonth()));
                rscmContractServiceInstallment.setDateNext(dateNext);
                rscmContractServiceInstallment.setStatus(RSCMContractServiceInstallmentStatus.IN_PROGRESS);
                rscmContractServiceManager.updateRSCMContractServiceInstallment(rscmContractServiceInstallment);
            }
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void cancelRSCMContractServiceInstallment(int id) throws BGException, BGMessageException {
        Connection con = this.getConnection();
        try (RSCMContractServiceManager rscmContractServiceManager = new RSCMContractServiceManager(con, this.moduleId);){
            RSCMContractServiceInstallment rscmContractServiceInstallment = rscmContractServiceManager.getContractServiceInstallment(id);
            if (rscmContractServiceInstallment != null) {
                if (!rscmContractServiceInstallment.getStatus().equals((Object)RSCMContractServiceInstallmentStatus.IN_PROGRESS)) {
                    throw new BGMessageException("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0443 \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u0442\u0435\u043a\u0443\u0449\u0430\u044f\"");
                }
                rscmContractServiceInstallment.setDateNext(null);
                rscmContractServiceInstallment.setStatus(RSCMContractServiceInstallmentStatus.CANCEL);
                rscmContractServiceManager.updateRSCMContractServiceInstallment(rscmContractServiceInstallment);
            }
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void closeRSCMContractServiceInstallment(int id) throws BGException, BGMessageException {
        Connection con = this.getConnection();
        try (RSCMContractServiceManager rscmContractServiceManager = new RSCMContractServiceManager(con, this.moduleId);){
            RSCMContractServiceInstallment contractServiceInstallment = rscmContractServiceManager.getContractServiceInstallment(id);
            if (contractServiceInstallment != null) {
                JSONArray contractServiceIds;
                if (!contractServiceInstallment.getStatus().equals((Object)RSCMContractServiceInstallmentStatus.IN_PROGRESS)) {
                    throw new BGMessageException("\u0414\u043e\u0441\u0440\u043e\u0447\u043d\u043e \u043f\u043e\u0433\u0430\u0441\u0438\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0443 \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u0442\u0435\u043a\u0443\u0449\u0430\u044f\"");
                }
                JSONObject jsonObject = new JSONObject(contractServiceInstallment.getInstallment());
                JSONArray paymentsArray = jsonObject.optJSONArray("paymentsArray");
                int number = contractServiceInstallment.getPaymentCount() + 1;
                int amountDown = contractServiceInstallment.getAmountDown();
                if (amountDown == 0) {
                    amountDown = 100;
                }
                int amount = 0;
                int len = paymentsArray.length();
                for (int i = number - 1; i < len; ++i) {
                    amount += paymentsArray.getInt(i);
                }
                int parts = 0;
                int len2 = paymentsArray.length();
                for (int i = 0; i < len2; ++i) {
                    parts += paymentsArray.getInt(i);
                }
                int amountUp = amount * contractServiceInstallment.getAmountUp() / parts;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("number = {}; amountUp = {}; amountDown = {}", new Object[]{number, amountUp, amountDown});
                }
                RSCMContractService contractService = new RSCMContractService().setContractId(contractServiceInstallment.getContractId()).setServiceId(contractServiceInstallment.getServiceId()).setInstallmentId(contractServiceInstallment.getId()).setDate(LocalDate.now()).setAmountUp(amountUp).setAmountDown(amountDown).setLast(true).setComment(String.format("\u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0430. \u0412\u0437\u043d\u043e\u0441 [\u0447\u0430\u0441\u0442\u0435\u0439: %s/%s] => %s-%s \u0438\u0437 %s ", amountUp, amountDown, number, paymentsArray.length(), paymentsArray.length()));
                rscmContractServiceManager.updateContractService(contractService);
                contractServiceInstallment.setPaymentCount(paymentsArray.length());
                contractServiceInstallment.setStatus(RSCMContractServiceInstallmentStatus.COMPLETED);
                contractServiceInstallment.setDateNext(null);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("set status = {}", (Object)contractServiceInstallment.getStatus());
                    this.getLogger().debug("set next date = {}", (Object)contractServiceInstallment.getDateNext());
                }
                if ((contractServiceIds = jsonObject.optJSONArray("contractServiceIds")) == null) {
                    contractServiceIds = new JSONArray();
                    jsonObject.put("contractServiceIds", (Object)contractServiceIds);
                }
                contractServiceIds.put(contractService.getId());
                contractServiceInstallment.setInstallment(jsonObject.toString());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("installment = {}", (Object)contractServiceInstallment.getInstallment());
                }
                rscmContractServiceManager.updateRSCMContractServiceInstallment(contractServiceInstallment);
                EventProcessor.getInstance().publish((Event)new RSCMContractServiceUpdateEvent(0, this.moduleId, contractService.getContractId(), contractService));
                rscmContractServiceManager.hotCalc(contractService.getContractId(), contractService.getDate(), this.getConnectionSet());
            }
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

