/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.chronopay.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Map;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.chronopay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.chronopay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.chronopay.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebServlet(name="ChronopayExecuter", urlPatterns={"/chronopay/*"})
public class ModuleExecuter
extends CommonExecutor {
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block17: {
            try {
                int moduleId = ModuleExecuter.getModuleId((HttpServletRequest)httpServletRequest);
                StringBuffer buf = new StringBuffer();
                for (Map.Entry entry : httpServletRequest.getParameterMap().entrySet()) {
                    for (String value : (String[])entry.getValue()) {
                        buf.append(buf.length() > 0 ? "\n" : "");
                        buf.append((String)entry.getKey()).append("=").append(value);
                    }
                }
                ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
                if (!this.doSign(httpServletRequest, moduleSetup).equals(httpServletRequest.getParameter("sign"))) {
                    httpServletResponse.sendError(400, "Sign error");
                    this.getLogger().error(buf.toString());
                    return;
                }
                String transactionType = httpServletRequest.getParameter("transaction_type");
                if (!"Purchase".equals(transactionType) && !"Rebill".equals(transactionType)) {
                    httpServletResponse.setStatus(200);
                    this.getLogger().info("Ignore Notification ");
                    return;
                }
                int transactionId = Utils.parseInt((String)httpServletRequest.getParameter("cs1"));
                Connection con = Setup.getSetup().getDBConnectionFromPool();
                try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                    TransactionManager transactionManager = new TransactionManager(con, moduleId);
                    Transaction transaction = (Transaction)transactionManager.get(transactionId);
                    if (transaction != null && transaction.getPaymentId() < 1) {
                        int contractId = transaction.getContractId();
                        Payment payment = new Payment().setDate(TimeUtils.parseDate((String)httpServletRequest.getParameter("date"), (String)"MM/dd/yyyy HH:mm:ss")).setTypeId(moduleSetup.getInt("chronopay.payment.type.id", 0)).setContractId(contractId).setSum(new BigDecimal(httpServletRequest.getParameter("total"))).setUserId(0).setModuleId(Integer.valueOf(moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(httpServletRequest.getParameter("payment_type") + " #" + transactionId + "/" + httpServletRequest.getParameter("transaction_id"));
                        new PaymentDao(con).update((Object)payment);
                        transaction.setPaymentId(payment.getId());
                        transaction.setStatus(TransactionStatus.OK.getCode());
                        transaction.setParameters(transaction.getParameters() + "\\n" + buf.toString());
                        transactionManager.update(transaction);
                        balanceUtils.updateBalance(payment.getDate(), contractId);
                        EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                        EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contractId, 3, payment.getSum()));
                        try {
                            String email;
                            String phone = httpServletRequest.getParameter("phone");
                            if (Utils.notBlankString((String)phone)) {
                                ContractUtils.savePaymentPhone((Connection)con, (int)moduleId, (int)contractId, (String)phone);
                            }
                            if (Utils.notBlankString((String)(email = httpServletRequest.getParameter("email")))) {
                                ContractUtils.savePaymentEmail((Connection)con, (int)moduleId, (int)contractId, (String)email);
                            }
                            break block17;
                        }
                        catch (Exception ex) {
                            this.logError(ex);
                        }
                        break block17;
                    }
                    this.getLogger().error("transaction=" + String.valueOf(transaction) + " for ID=" + transactionId);
                    if (transaction != null) {
                        this.getLogger().error("Reply transaction.getPaymentId()=" + transaction.getPaymentId());
                    }
                    this.getLogger().error(buf.toString());
                }
            }
            catch (Exception ex) {
                httpServletResponse.setStatus(500);
                this.logError(ex);
            }
        }
        httpServletResponse.setStatus(200);
    }

    private String doSign(HttpServletRequest httpServletRequest, ModuleSetup moduleSetup) {
        StringBuffer buf = new StringBuffer().append(moduleSetup.get("chronopay.sharedsec", "")).append(httpServletRequest.getParameter("customer_id")).append(httpServletRequest.getParameter("transaction_id")).append(httpServletRequest.getParameter("transaction_type")).append(httpServletRequest.getParameter("total"));
        return Utils.getDigest((String)buf.toString(), (String)"utf-8").toLowerCase();
    }
}

