/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.task;

import bitel.billing.server.contract.bean.LimitChangeTask;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.limit.server.bean.LimitManager;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskParameter;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class DebtMailSender
extends TaskBase {
    private int pid = 0;
    private String subject = "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e \u0437\u0430\u0434\u043e\u043b\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u0438";

    @Override
    public String getDescription() {
        return this.defaultDescription + "\u0417\u0430\u0434\u0430\u0447\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0434\u043e\u043b\u0436\u043d\u0438\u043a\u0430\u043c.";
    }

    @Override
    protected boolean initTask() {
        boolean result = true;
        this.pid = this.taskSetup.getInt("email.pid", -1);
        if (this.pid <= 0) {
            result = false;
            this.getLogger().error("Param pid not found!");
        }
        this.subject = this.taskSetup.get("email.subject", this.subject);
        return result;
    }

    @Override
    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();
             Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
             BalanceUtils bu = new BalanceUtils(con);
             ContractDao contractDao = new ContractDao(con, 0);){
            LimitManager moveTaskManager = new LimitManager(conSlave);
            List<LimitChangeTask> tasks = moveTaskManager.getFullTaskList();
            for (LimitChangeTask task : tasks) {
                Contract contract = (Contract)contractDao.get(task.getContractId());
                if (contract == null) {
                    this.getLogger().error("Contract " + task.getId() + " not found!");
                }
                BigDecimal limitAfterTaskDo = contract.getBalanceLimit().subtract(task.getDeltaSum());
                BigDecimal balance = bu.getBalance(this.getOperatingTime().getTime(), contract.getId());
                if (balance.compareTo(limitAfterTaskDo) >= 0) continue;
                String email = contractDao.optContractParameterTextAsString(contract.getId(), this.pid).orElse(contractDao.optContractParameterEmailAsString(contract.getId(), this.pid).orElse(null));
                if (Utils.notBlankString(email)) {
                    this.getLogger().info("Sending " + contract.getTitle() + " on " + email);
                    this.sendEmail(contract, balance, task, email);
                    continue;
                }
                this.getLogger().debug("Contract " + contract.getTitle() + " not email found");
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            this.error = ex;
        }
    }

    private void sendEmail(Contract contract, BigDecimal balance, LimitChangeTask task, String email) throws BGException {
        try {
            Document doc = XMLUtils.newDocument();
            Element data = doc.createElement("data");
            doc.appendChild(data);
            Element contractEl = XMLUtils.createElement(data, "contract");
            contractEl.setAttribute("title", contract.getTitle());
            contractEl.setAttribute("balance", Utils.formatBigDecimalSumm(balance));
            Element taskEl = XMLUtils.createElement(data, "task");
            taskEl.setAttribute("date", TimeUtils.formatDate(task.getDate()));
            XSLManager.getInstance().transformAndSend("debt_mail.xsl", new DOMSource(doc), null, "text/html", null, false, email.replaceAll("\n", ";"), this.subject);
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    @Override
    public List<TaskParameter> taskParameters() {
        List<TaskParameter> taskParameters = super.taskParameters();
        taskParameters.add(new TaskParameter().setKey("email.pid").setTitle("email.pid").setDefaultValue("-1"));
        taskParameters.add(new TaskParameter().setKey("email.subject").setTitle("email.subject").setDefaultValue(this.subject));
        return taskParameters;
    }
}

