/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDeviceType;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDaoSupport;
import ru.bitel.oss.kernel.entity.server.bean.VoiceDeviceEntityAttrDaoSupport;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceDao;

public class VoiceDeviceDao
extends DeviceDao<VoiceDevice, VoiceDeviceType> {
    private final String deviceTypeTable;

    public VoiceDeviceDao(Connection con, int moduleId) throws BGException {
        this(con, moduleId, 0);
    }

    public VoiceDeviceDao(Connection con, int moduleId, int userId) throws BGException {
        super(con, "voice_device", (EntityAttrDaoSupport)new VoiceDeviceEntityAttrDaoSupport(), moduleId, userId);
        this.deviceTypeTable = "voice_device_type_" + moduleId;
    }

    protected VoiceDevice newDevice() {
        return new VoiceDevice();
    }

    protected VoiceDeviceType newDeviceType(int id, String title) {
        return new VoiceDeviceType(id, title);
    }

    protected Directory<VoiceDeviceType> getTypeDir() throws BGException {
        return ServerDirectoryFactory.newUnmodifiableDirectory(VoiceDeviceType.class, (Connection)this.con, (int)this.moduleId, (boolean)false);
    }

    public List<VoiceDevice> list() throws BGException {
        return super.list("", "id", new Object[0]);
    }

    protected VoiceDevice getFromRSImpl(ResultSet rs) throws SQLException, BGException {
        VoiceDevice device = (VoiceDevice)super.getFromRSImpl(rs);
        device.setLogPath(rs.getString("logPath"));
        return device;
    }

    protected List<String> getValues() {
        List values = super.getValues();
        values.add("logPath");
        return values;
    }

    protected int setExtraParams(VoiceDevice device, PreparedStatement ps, int idx) throws SQLException {
        ps.setString(idx++, device.getLogPath());
        if (device.getDeviceTypeId() == 0) {
            ps.setNull(2, 4);
        }
        return idx;
    }

    protected String getQueryById() {
        String query = "SELECT d.*, t.entitySpecId AS entitySpecId FROM " + this.tableName + " AS d LEFT JOIN `" + this.deviceTypeTable + "` AS t ON d.deviceTypeId=t.id WHERE d.id=?";
        return query;
    }

    protected void updateImpl(VoiceDevice voiceDevice) throws BGException, SQLException {
        super.updateImpl((Device)voiceDevice);
    }

    public List<VoiceDevice> listSource() throws BGException {
        return super.list(true, null, null, "LEFT JOIN voice_device_type_" + this.moduleId + " as type ON type.id=" + this.tableName + ".deviceTypeId", null, "type.source=?", null, null, new Object[]{true});
    }

    public List<VoiceDevice> listNas() throws BGException {
        return super.list(true, null, null, "LEFT JOIN voice_device_type_" + this.moduleId + " as type ON type.id=" + this.tableName + ".deviceTypeId", null, "type.nas=?", null, null, new Object[]{true});
    }
}

