/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.client;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.modules.megogo.client.MegogoSetupTab;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoSubscription;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class SubscriptionSetupTab
extends MegogoSetupTab {
    private MegogoSubscriptionTableModel model;
    private BGUTable table;
    private JPanel editor;
    private JLabel serviceName;
    private BGComboBox<IdTitle> typeComboBox;
    private BGTextField keyField;
    private BGTextField commentField;

    public SubscriptionSetupTab() {
        this.table = new BGUTable((TableModel)((Object)this.model));
        this.editor = new JPanel(new GridBagLayout());
        this.serviceName = new JLabel();
        this.typeComboBox = new BGComboBox();
        this.keyField = new BGTextField(20);
        this.commentField = new BGTextField();
    }

    @Override
    protected void jbInit() throws BGException {
        this.model = new MegogoSubscriptionTableModel();
        this.table.setSelectionMode(0);
        BGSwingUtilites.handleLDMouseClicked((Component)this.table, e -> this.startEdit());
        this.editor.setVisible(false);
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        JPanel editorPanel = new JPanel(new GridBagLayout());
        editorPanel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        editorPanel.add((Component)this.serviceName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        editorPanel.add((Component)new JLabel("\u0422\u0438\u043f: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        editorPanel.add((Component)this.typeComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        editorPanel.add((Component)new JLabel("MegogoKey: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        editorPanel.add((Component)this.keyField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        editorPanel.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        editorPanel.add((Component)this.commentField, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        editorPanel.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
        this.editor.add((Component)editorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editor.add((Component)okCancel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.table.setModel((TableModel)((Object)this.model));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void startEdit() {
        MegogoSubscription service = (MegogoSubscription)this.model.getSelectedRow();
        if (service == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
            return;
        }
        if (this.typeComboBox.getModel() == null || this.typeComboBox.getModel().getSize() == 0) {
            IdTitle[] data = new IdTitle[]{new IdTitle(1, "\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f"), new IdTitle(2, "\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f")};
            this.typeComboBox.setModel(new DefaultComboBoxModel<IdTitle>(data));
        }
        this.serviceName.setText(service.getTitle());
        this.typeComboBox.setSelectedId((String)(service.getSid() > 0 ? "" + service.getSid() : "1"));
        this.keyField.setText(service.getKey() == null ? "" : service.getKey());
        this.commentField.setText(service.getComment() == null ? "" : service.getComment());
        this.table.setEnabled(false);
        this.editor.setVisible(true);
    }

    private void stopEdit(boolean save) {
        MegogoSubscription subscription;
        if (save && (subscription = (MegogoSubscription)this.model.getSelectedRow()) != null) {
            try {
                subscription.setType(((IdTitle)this.typeComboBox.getSelectedItem()).getId());
                subscription.setKey(this.keyField.getText());
                subscription.setComment(this.commentField.getText());
                this.getMegogoService().updateSubscription(subscription);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        this.table.setEnabled(true);
        this.editor.setVisible(false);
        this.performAction("refresh");
    }

    private void setTableData() throws Exception {
        this.model.setData(this.getMegogoService().subscriptionList((Boolean)null, -1));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionInit((AbstractBGUPanel)this, e -> this.setTableData());
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.setTableData());
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> ClientUtils.showErrorMessageDialog((String)"\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0443 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c. \u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443 \u0432 \u043c\u043e\u0434\u0443\u043b\u0435 \u0434\u043b\u044f \u043d\u0443\u0436\u043d\u043e\u0439 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438."));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.startEdit());
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> ClientUtils.showErrorMessageDialog((String)"\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0443 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c. \u041c\u043e\u0436\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u043e\u0441\u0442\u044c \u0432 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0435 \u043c\u043e\u0434\u0443\u043b\u0435\u0439 \u0438 \u0443\u0441\u043b\u0443\u0433."));
    }

    class MegogoSubscriptionTableModel
    extends BGTableModel<MegogoSubscription> {
        public MegogoSubscriptionTableModel() {
            super(MegogoSubscriptionTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", -1, 250, 600, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0438\u043f", 200, 200, 300, "type", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f", 120, 120, 120, "used", true);
            this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", -1, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 150, 200, 250, "user", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValueAt(MegogoSubscription val, int column) throws Exception {
            switch (column) {
                case 1: {
                    return val.getTitle() == null ? "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : val.getTitle();
                }
                case 2: {
                    String typeStr = "<\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f>";
                    if (val.getType() == 1) {
                        typeStr = "\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f";
                    } else if (val.getType() == 2) {
                        typeStr = "\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0435\u043c\u0430\u044f";
                    }
                    return typeStr;
                }
                case 5: {
                    return SubscriptionSetupTab.this.getUserDirectory().get(val.getUserId()) == null ? "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : ((UserInfo)SubscriptionSetupTab.this.getUserDirectory().get(val.getUserId())).getName();
                }
            }
            return super.getValue((Object)val, column);
        }
    }
}

