/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.server.upload.SormTransferFiles;
import ru.bitel.bgbilling.modules.sorm.server.upload.Upload;
import ru.bitel.bgbilling.modules.sorm.server.upload.UploadFiles;
import ru.bitel.common.Preferences;

public class SormSFTPTransferFiles
extends SormTransferFiles {
    private Session session;

    public SormSFTPTransferFiles(UploadFiles uploadFiles, Preferences config, Upload versionUpload) throws BGException {
        super(config);
        this.startUpload(this.getSFTPChannel(), uploadFiles, versionUpload, config);
    }

    private ChannelSftp getSFTPChannel() throws BGException {
        try {
            JSch jSch = new JSch();
            this.session = jSch.getSession(this.login, this.host, this.port);
            this.session.setPassword(this.password);
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.connect();
            this.getLogger().debug("Open SFTP channel");
            ChannelSftp channelSftp = (ChannelSftp)this.session.openChannel("sftp");
            channelSftp.connect();
            return channelSftp;
        }
        catch (JSchException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void startUpload(ChannelSftp channelSftp, UploadFiles uploadFiles, Upload versionUpload, Preferences config) throws BGException {
        this.getLogger().debug("startUpload");
        try {
            List<Path> files = uploadFiles.getFiles();
            for (Path file : files) {
                this.getLogger().info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043d\u0430 FTP \u0444\u0430\u0439\u043b\u0430: {}", (Object)file.getFileName());
                String remoteFilePath = this.getRemoteFilePath(uploadFiles, file, versionUpload, config);
                this.createRemoteDirectories(remoteFilePath, channelSftp);
                InputStream is = Files.newInputStream(file, new OpenOption[0]);
                try {
                    this.getLogger().debug("SFTP, \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0430 \u0444\u0430\u0439\u043b\u0430: {}", (Object)file);
                    channelSftp.put(is, file.getFileName().toString());
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0444\u0430\u0439\u043b\u043e\u0432 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440 \u0421\u041e\u0420\u041c";
            this.getLogger().error(text, (Throwable)ex);
            throw new BGException(text);
        }
        finally {
            channelSftp.disconnect();
            if (this.session != null) {
                this.session.disconnect();
            }
        }
    }

    private void createRemoteDirectories(String remoteFilePath, ChannelSftp channelSftp) throws BGException {
        String[] directories = remoteFilePath.split("/");
        Object current = "";
        for (String dir : directories) {
            if (dir.isEmpty()) continue;
            current = (String)current + "/" + dir;
            try {
                channelSftp.cd((String)current);
            }
            catch (SftpException e) {
                try {
                    channelSftp.mkdir((String)current);
                    channelSftp.cd((String)current);
                }
                catch (SftpException ex) {
                    throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438: " + String.valueOf((Object)ex));
                }
            }
        }
    }
}

