/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.tariff.client;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.field.BGFloatTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class AddCallCostTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon("coin");
    private JLabel view = new JLabel(icon, 2);
    private BGFloatTextField cost;
    private BGUComboBox<IdTitle> type;
    private BGUComboBox<IdTitle> nonZero;
    private String costValue;
    private int typeValue;
    private boolean nonZeroValue;
    private boolean isDefault;
    private String costSource;
    private String costType;

    @Override
    protected void loadData() {
        this.extractData();
        this.cost.setText(this.costValue);
        this.type.setSelectedItem(this.typeValue);
        this.nonZero.setSelectedItem(this.nonZeroValue ? 1 : 0);
    }

    private void extractData() {
        Map<String, String> data = this.getDataInHash();
        this.costValue = data.get("cost");
        if (this.costValue == null) {
            this.costValue = "";
        }
        this.typeValue = Utils.parseInt(data.get("type"), 0);
        this.nonZeroValue = Utils.parseInt(data.get("nonZero"), 0) == 1;
        this.isDefault = data.get("default") != null;
        this.costType = data.get("cost_type");
        if (Utils.isBlankString(this.costType)) {
            this.costType = "min";
        }
        this.costSource = data.get("cost_source");
        if (Utils.isBlankString(this.costSource)) {
            this.costSource = "node";
        }
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("cost", this.cost.getText());
        data.put("type", String.valueOf(((IdTitle)this.type.getSelectedItem()).getId()));
        data.put("nonZero", String.valueOf(((IdTitle)this.nonZero.getSelectedItem()).getId()));
        this.setDataInHash(data);
    }

    @Override
    public void loadFromXML(Element element) {
        this.loadHashFromXML(element);
    }

    @Override
    public void serializeToXML(Element element) {
        this.serializeHashToXML(element);
    }

    @Override
    protected JPanel getEditorPanel() {
        JPanel propsPanel = new JPanel();
        if (this.cost == null) {
            this.cost = new BGFloatTextField();
            this.cost.setColumns(10);
            ArrayList<IdTitle> data = new ArrayList<IdTitle>();
            data.add(new IdTitle(0, "\u0437\u0432\u043e\u043d\u043a\u0430"));
            data.add(new IdTitle(1, "\u043c\u0438\u043d\u0443\u0442\u044b"));
            this.type = new BGUComboBox();
            this.type.setData(data);
            data = new ArrayList();
            data.add(new IdTitle(0, "\u0432\u043a\u043b\u044e\u0447\u0430\u044f \u0437\u0432\u043e\u043d\u043a\u0438 \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0434\u043b\u0438\u043d\u044b"));
            data.add(new IdTitle(1, "\u0438\u0441\u043a\u043b\u044e\u0447\u0430\u044f \u0437\u0432\u043e\u043d\u043a\u0438 \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0434\u043b\u0438\u043d\u044b"));
            this.nonZero = new BGUComboBox();
            this.nonZero.setData(data);
            propsPanel.add(new JLabel(this.getLabelTitle()));
            propsPanel.add(this.type);
            propsPanel.add(this.cost);
            propsPanel.add(this.nonZero);
        }
        return propsPanel;
    }

    @Override
    public Component getView() {
        this.extractData();
        StringBuilder labelText = new StringBuilder(100);
        labelText.append(this.getLabelTitle());
        if (this.typeValue == 1) {
            labelText.append(" \u043c\u0438\u043d\u0443\u0442\u044b");
        } else {
            labelText.append(" \u0437\u0432\u043e\u043d\u043a\u0430");
        }
        if (this.nonZeroValue) {
            labelText.append(", \u0438\u0441\u043a\u043b\u044e\u0447\u0430\u044f \u0437\u0432\u043e\u043d\u043a\u0438 \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0434\u043b\u0438\u043d\u044b");
        } else {
            labelText.append(", \u0432\u043a\u043b\u044e\u0447\u0430\u044f \u0437\u0432\u043e\u043d\u043a\u0438 \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0434\u043b\u0438\u043d\u044b");
        }
        labelText.append(" = ");
        labelText.append(this.costValue);
        if (this.isDefault) {
            labelText.append(" *");
        }
        this.view.setText(labelText.toString());
        return this.view;
    }

    protected String getLabelTitle() {
        return "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438";
    }
}

