/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.range;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.TariffPanelEditor;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarType;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class RangeTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon("fugue/beaker");
    private JLabel _view = new JLabel();
    private String idMode;
    private ButtonGroup idButtonGroup = new ButtonGroup();
    private Directory tariffOptionDir;
    private BGIntTextField amount = new BGIntTextField();
    private BGIntTextField labelField = new BGIntTextField();
    private BGTextField treeNodeIdField = new BGTextField();
    private BGComboBox<ComboBoxItem> _type = new BGComboBox();
    private BGComboBox<ComboBoxItem> mode = new BGComboBox();
    private BGComboBox<ComboBoxItem> modeType = new BGComboBox();
    private BGUComboBox<TariffVar> tariffVars = new BGUComboBox();
    private BGUComboBox<IdTitle> tariffOptionCombo = new BGUComboBox();
    private JCheckBox tariffOptionDeactivate = new JCheckBox("\u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u043f\u0446\u0438\u044e \u043f\u0440\u0438 \u043f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0438");
    String typeMode = null;

    public RangeTariffTreeNode() {
        this._view.setIcon(icon);
        try {
            this.treeNodeIdField.setEditable(false);
            this.treeNodeIdField.setHorizontalAlignment(0);
            this.mode.addActionListener(e -> {
                String id = ClientUtils.getIdFromComboBox(this.mode);
                if ("5".equals(id) || "15".equals(id)) {
                    this.tariffOptionCombo.setEnabled(true);
                    this.tariffOptionDeactivate.setEnabled(true);
                } else {
                    this.tariffOptionCombo.setEnabled(false);
                    this.tariffOptionDeactivate.setEnabled(false);
                }
            });
            this.mode.addItem(new ComboBoxItem("1", "\u0437\u0430 \u0443\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434"));
            this.mode.addItem(new ComboBoxItem("2", "\u0437\u0430 \u043c\u0435\u0441\u044f\u0446"));
            this.mode.addItem(new ComboBoxItem("3", "\u0437\u0430 \u0434\u0435\u043d\u044c"));
            this.mode.addItem(new ComboBoxItem("4", "\u0437\u0430 \u0447\u0430\u0441"));
            this.mode.addItem(new ComboBoxItem("5", "\u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438"));
            this.mode.addItem(new ComboBoxItem("13", "\u0437\u0430 \u0434\u0435\u043d\u044c (\u0431\u0435\u0437 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f)"));
            this.mode.addItem(new ComboBoxItem("14", "\u0437\u0430 \u0447\u0430\u0441 (\u0431\u0435\u0437 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f)"));
            this.mode.addItem(new ComboBoxItem("15", "\u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438 (\u0431\u0435\u0437 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f)"));
            this.modeType.addItem(new ComboBoxItem("1", "\u0431\u0435\u0437\u0443\u0441\u043b\u043e\u0432\u043d\u043e"));
            this.modeType.addItem(new ComboBoxItem("2", "\u043f\u0440\u043e\u043f\u043e\u0440\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0443 \u0442\u0430\u0440\u0438\u0444\u0430"));
            this.modeType.addItem(new ComboBoxItem("3", "\u043f\u0440\u043e\u043f\u043e\u0440\u0446. \u043f\u0435\u0440\u0438\u043e\u0434\u0443 \u0442\u0430\u0440\u0438\u0444\u0430 (\u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432)"));
            this.modeType.addItem(new ComboBoxItem("5", "\u043f\u0440\u043e\u043f\u043e\u0440\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0443 \u043e\u043f\u0446\u0438\u0439"));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private JPanel getAmountTypeModePanel() {
        this.amount.setColumns(8);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.amount, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 3, 3), 0, 0));
        panel.add(this._type, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 3, 3), 0, 0));
        panel.add(this.mode, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        return panel;
    }

    private JPanel getTreeNodeIdPanel() {
        JRadioButton idFromConst = new JRadioButton("\u0438\u0437 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u044b -> ");
        idFromConst.setActionCommand("const");
        idFromConst.setSelected(true);
        JRadioButton idFromTariffVar = new JRadioButton("\u0438\u0437 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 -> ");
        idFromTariffVar.setActionCommand("var");
        this.idButtonGroup.add(idFromConst);
        this.idButtonGroup.add(idFromTariffVar);
        this.tariffVars.setData(this.vars);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(" ID \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 "));
        panel.add((Component)idFromConst, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.treeNodeIdField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)idFromTariffVar, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        panel.add(this.tariffVars, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        return panel;
    }

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        try {
            this.typeMode = "0";
            Element ref = config.getTypeElement(this.getType());
            if (ref != null) {
                this.typeMode = ref.getAttribute("mode");
            }
            if (!this.typeMode.equals("2")) {
                this._type.addItem(new ComboBoxItem("0", "\u0431\u0430\u0439\u0442"));
                this._type.addItem(new ComboBoxItem("1", "KB"));
                this._type.addItem(new ComboBoxItem("2", "MB"));
                this._type.addItem(new ComboBoxItem("3", "GB"));
            }
            if (!this.typeMode.equals("1")) {
                this._type.addItem(new ComboBoxItem("4", "\u0441\u0435\u043a\u0443\u043d\u0434"));
                this._type.addItem(new ComboBoxItem("5", "\u043c\u0438\u043d\u0443\u0442"));
                this._type.addItem(new ComboBoxItem("6", "\u0447\u0430\u0441\u043e\u0432"));
            }
            this.tariffOptionDir = this.getDirManager().getDirectory("tariff_option");
            ArrayList<IdTitle> tariffOptionList = new ArrayList<IdTitle>(this.tariffOptionDir.getItems());
            tariffOptionList.add(0, IdTitle.NO_SELECT);
            this.tariffOptionCombo.setData(tariffOptionList);
            this.vars.add(TariffVar.from(IdTitle.NO_SELECT));
            if (tree.getParent() instanceof TariffPanelEditor) {
                int moduleId = this.getModuleId(parent);
                TariffPanelEditor tariffPanelEditor = (TariffPanelEditor)tree.getParent();
                this.vars.addAll(tariffPanelEditor.getTariffService().tariffVars(this.getTariffVarType(), Arrays.asList(tariffPanelEditor.getTariffPlanId(), 0)).stream().filter(a -> a.getModuleId() == moduleId || a.getModuleId() == 0).collect(Collectors.toList()));
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    protected TariffVarType getTariffVarType() {
        return null;
    }

    @Override
    protected JPanel getEditorPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getAmountTypeModePanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 3, 3), 0, 0));
        panel.add(this.tariffOptionCombo, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        panel.add((Component)this.tariffOptionDeactivate, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        panel.add(this.modeType, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        panel.add((Component)this.getTreeNodeIdPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041c\u0435\u0442\u043a\u0430 \u0434\u043b\u044f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0432 \u041b\u041a:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 0, 3, 0), 0, 0));
        panel.add((Component)this.labelField, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public Component getView() {
        return this._view;
    }

    @Override
    protected void loadData() {
        Map<String, String> data = this.getDataInHash();
        String col = data.get("amount");
        if (col != null) {
            this.amount.setText(col);
        }
        ClientUtils.setComboBoxSelection(this._type, data.get("type"));
        ClientUtils.setComboBoxSelection(this.mode, data.get("mode"));
        ClientUtils.setComboBoxSelection(this.modeType, data.get("modeType"));
        this.tariffOptionCombo.setSelectedItem(Utils.parseInt(data.get("tariffOptionId")));
        this.tariffOptionDeactivate.setSelected(Utils.parseInt(data.get("tariffOptionDeactivate")) > 0);
        long treeNodeId = 0xFFFFFFFF00000000L & (long)this.tree.getTreeId() << 32 | 0xFFFFFFFFL & (long)this.getId();
        this.treeNodeIdField.setText(String.valueOf(treeNodeId));
        this.labelField.setText(Utils.maskNull(data.get("labelId")));
        this.idMode = data.getOrDefault("idMode", "const");
        int tariffVarId = Utils.parseInt(data.getOrDefault("tariffVarId", "0"), 0);
        this.tariffVar = this.vars.isEmpty() ? null : this.vars.stream().filter(a -> a.getId() == tariffVarId).findFirst().orElse((TariffVar)this.vars.get(0));
        this.idButtonGroup.getElements().asIterator().forEachRemaining(a -> {
            if (a.getActionCommand().equals(this.idMode)) {
                a.setSelected(true);
            }
        });
        this.tariffVars.setSelectedItem(this.tariffVar);
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("amount", this.amount.getText());
        data.put("type", ClientUtils.getIdFromComboBox(this._type));
        data.put("mode", ClientUtils.getIdFromComboBox(this.mode));
        data.put("modeType", ClientUtils.getIdFromComboBox(this.modeType));
        IdTitle item = (IdTitle)this.tariffOptionCombo.getSelectedItem();
        if (item != null) {
            data.put("tariffOptionId", String.valueOf(item.getId()));
        }
        data.put("tariffOptionDeactivate", this.tariffOptionDeactivate.isSelected() ? "1" : "0");
        data.put("labelId", this.labelField.getText());
        data.put("idMode", this.idButtonGroup.getSelection().getActionCommand());
        data.put("tariffVarId", String.valueOf(((TariffVar)this.tariffVars.getSelectedItem()).getId()));
        this.setDataInHash(data);
        this.updateView();
    }

    private void updateView() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.amount.getText());
        sb.append(" ");
        ComboBoxItem typeItem = this._type.getSelectedItem();
        sb.append(typeItem.toString());
        sb.append(" ");
        ComboBoxItem modeItem = this.mode.getSelectedItem();
        sb.append(modeItem.toString());
        ComboBoxItem modeTypeItem = this.modeType.getSelectedItem();
        if ("2".equals(modeTypeItem.getObject()) || "3".equals(modeTypeItem.getObject())) {
            sb.append(" ").append(modeTypeItem.toString());
        }
        if ("5".equals(modeItem.getObject()) || "15".equals(modeItem.getObject())) {
            sb.append(" ");
            IdTitle itemIdTitle = (IdTitle)this.tariffOptionCombo.getSelectedItem();
            sb.append(itemIdTitle.toString());
            if (this.tariffOptionDeactivate.isSelected()) {
                sb.append(" (\u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0438 \u043f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0438)");
            }
        }
        sb.append(" [ID#");
        if ("const".equals(this.idMode)) {
            long treeNodeId = 0xFFFFFFFF00000000L & (long)this.tree.getTreeId() << 32 | 0xFFFFFFFFL & (long)this.getId();
            sb.append(treeNodeId);
        } else if ("var".equals(this.idMode)) {
            sb.append((String)(this.tariffVar != null ? "< " + this.tariffVar.getTitle() + " [" + this.getTariffVarValue(this.tariffVar) + "] >" : "???"));
        }
        sb.append("]");
        this._view.setText(sb.toString());
    }

    @Override
    public void setData(String data) {
        super.setData(data);
        this.loadData();
        this.updateView();
    }

    @Override
    public void serializeToXML(Element el) throws Exception {
        this.serializeHashToXML(el);
        this.serializeChildsToXML(el);
    }

    @Override
    public void loadFromXML(Element el) throws Exception {
        this.loadHashFromXML(el);
        this.loadChildsFromXML(el);
        this.loadData();
        this.updateView();
    }

    @Override
    protected void editOk() {
        if ("var".equals(this.idButtonGroup.getSelection().getActionCommand()) && ((TariffVar)this.tariffVars.getSelectedItem()).getId() == 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e");
            return;
        }
        super.editOk();
    }
}

