/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Templater {
    private static Pattern VAR_PATTERN = Pattern.compile("(\\{\\$(.+?)\\})");
    private static Logger logger = LogManager.getLogger();
    private StringBuilder sb;
    private List<VarIdx> templateVarIdx = new ArrayList<VarIdx>();
    private Map<String, String> varToReplaces = new HashMap<String, String>();

    public Templater(String input) {
        this.sb = new StringBuilder(input);
        Matcher m = VAR_PATTERN.matcher(input);
        while (m.find()) {
            if (m.groupCount() != 2) continue;
            this.templateVarIdx.add(new VarIdx(m.group(2), m.start(1), m.end(1)));
        }
    }

    public Templater replaceFields(String varPrefix, Object object) {
        for (VarIdx varIdx : this.templateVarIdx) {
            String var = varIdx.var;
            if (!var.startsWith(varPrefix)) continue;
            String methodName = var.substring(varPrefix.length());
            try {
                Method method = object.getClass().getMethod(methodName, new Class[0]);
                Object value = method.invoke(object, new Object[0]);
                this.varToReplaces.put(var, value.toString());
            }
            catch (NoSuchMethodException e) {
                logger.warn("template error: unknown getter \"" + methodName + "\" in object \"" + String.valueOf(object.getClass()) + "\" for key \"" + var + "\"");
            }
            catch (Exception e) {
                logger.warn("template error: object \"" + String.valueOf(object.getClass()) + "\"; key \"" + var + "\";", (Throwable)e);
            }
        }
        return this;
    }

    public Templater replaceString(String var, String string) {
        this.varToReplaces.put(var, string);
        return this;
    }

    public String getString() {
        Collections.sort(this.templateVarIdx, new ReverseIdxPairComparator());
        for (VarIdx varIdx : this.templateVarIdx) {
            String varName = varIdx.var;
            String replace = this.varToReplaces.get(varName);
            if (replace != null) {
                this.sb.replace(varIdx.start, varIdx.stop, replace);
                continue;
            }
            logger.warn("template error: unknown key \"" + varName + "\"");
        }
        return this.sb.toString();
    }

    private static class VarIdx {
        String var;
        int start;
        int stop;

        private VarIdx(String var, int start, int stop) {
            this.var = var;
            this.start = start;
            this.stop = stop;
        }
    }

    private static class ReverseIdxPairComparator
    implements Comparator<VarIdx> {
        private ReverseIdxPairComparator() {
        }

        @Override
        public int compare(VarIdx var1, VarIdx var2) {
            int var1idx = var1.start;
            int var2idx = var2.start;
            return var1idx != var2idx ? (var1idx < var2idx ? 1 : -1) : 0;
        }
    }
}

