/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.news.client;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelDate;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.plugins.news.common.bean.News;
import ru.bitel.bgbilling.plugins.news.common.bean.NewsFilter;
import ru.bitel.bgbilling.plugins.news.common.bean.NewsItem;
import ru.bitel.bgbilling.plugins.news.common.service.NewsService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.SearchResult;

public class NewsEditor
extends BGUPanel {
    public static final String TAB_ID = "newsEditor";
    private News current = null;
    private BGButtonPanelRestoreOkCancelHelp restoreOkCancelHelpPanel = new BGButtonPanelRestoreOkCancelHelp();
    private BGControlPanelPages pagesPanel = new BGControlPanelPages();
    private JLabel recordsLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e: 0");
    private ContractLabelTree contractLabelTree = new ContractLabelTree();
    private BGControlPanelDate datePanel = new BGControlPanelDate();
    private BGTextField newsTitle = new BGTextField();
    private CardLayout cardLayout = new CardLayout();
    private JPanel cardPanel = new JPanel(this.cardLayout);
    private JTextArea source = new JTextArea();
    private NewsService newsService = null;
    private NewsListTableModel newsListTableModel = null;
    private CardLayout filterCardLayout = new CardLayout();
    private JPanel filterCardPanel = new JPanel(this.filterCardLayout);
    private BGTextArea sqlQuery = new BGTextArea(10, 10);
    private BGUComboBox<IdTitle> filterMode = new BGUComboBox();
    private List<IdTitle> filterModeItes = Stream.of(NewsFilter.values()).map(NewsFilter::toIdTitle).toList();

    public void jbInit() throws Exception {
        this.cardPanel.setLayout(this.cardLayout);
        this.cardPanel.add((Component)this.getEditorPanel(), "editor");
        this.cardPanel.add((Component)this.getInfoPanel(), "info");
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(0, (Component)this.getNewsListPanel(), (Component)this.cardPanel, 200L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getEditorPanel() {
        this.restoreOkCancelHelpPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.restoreOkCancelHelpPanel.addActionListener(e -> this.bGControlPanel_02_actionPerformed(e));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getMiddlePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.restoreOkCancelHelpPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getInfoPanel() {
        JLabel infoLabel = new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u043e\u0432\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
        infoLabel.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)infoLabel, "Center");
        return panel;
    }

    private JPanel getNewsListPanel() {
        this.newsListTableModel = new NewsListTableModel();
        BGUTable table = new BGUTable((TableModel)((Object)this.newsListTableModel));
        table.setSelectionMode(0);
        BGSwingUtilites.handleLDMouseClicked((Component)table, e -> this.getNews(((NewsItem)this.newsListTableModel.getSelectedRow()).getId()));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u0421\u043f\u0438\u0441\u043e\u043a \u043d\u043e\u0432\u043e\u0441\u0442\u0435\u0439 "));
        panel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getFilterPanel() {
        this.pagesPanel.addToHandler(a -> this.performAction("refresh"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)this.recordsLabel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 3, 15), 0, 0));
        panel.add((Component)this.pagesPanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getMiddlePanel() {
        JCheckBox checkBox = new JCheckBox(" \u043f\u0435\u0440\u0435\u043d\u043e\u0441 \u0441\u0442\u0440\u043e\u043a");
        checkBox.addActionListener(e -> this.source.setLineWrap(checkBox.isSelected()));
        checkBox.setSelected(true);
        this.source.setLineWrap(true);
        this.source.setWrapStyleWord(true);
        this.source.setMargin(new Insets(3, 3, 3, 3));
        JPanel newsTextPanel = new JPanel(new GridBagLayout());
        newsTextPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        newsTextPanel.add((Component)this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        newsTextPanel.add((Component)new JScrollPane(this.source), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        newsTextPanel.add((Component)checkBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)newsTextPanel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getNewsFilterPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getNewsFilterPanel() {
        JScrollPane scrollPane = BGSwingUtilites.wrapScrollPane((JComponent)this.contractLabelTree, (int)600, (int)200);
        this.filterCardPanel.add((Component)new JPanel(), "0");
        this.filterCardPanel.add((Component)scrollPane, "1");
        this.filterCardPanel.add((Component)this.getSqlPanel(), "2");
        this.filterCardPanel.add((Component)this.getHandlerPanel(), "3");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("\u0424\u0438\u043b\u044c\u0442\u0440 \u043d\u043e\u0432\u043e\u0441\u0442\u0438"));
        panel.add((Component)this.getFilterModePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.filterCardPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getSqlPanel() {
        BGTextArea help = new BGTextArea(10, 10);
        help.setEditable(false);
        help.setText("\u041f\u0440\u0438\u043c\u0435\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432:\n\nselect id from contract where date1>'2023-09-01'\nselect id from contract where fc=1\n\n\u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043e\u043b\u0436\u0435\u043d \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0442\u044c ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0434\u043b\u044f \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0440\u0430\u0437\u0440\u0435\u0449\u0435\u043d \u043f\u043e\u043a\u0430\u0437 \u0434\u0430\u043d\u043d\u043e\u0439 \u043d\u043e\u0432\u043e\u0441\u0442\u0438");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("SQL \u0437\u0430\u043f\u0440\u043e\u0441: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)this.sqlQuery, (int)200, (int)200), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041f\u043e\u0434\u0441\u043a\u0430\u0437\u043a\u0430: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 5, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)help), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getHandlerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        return panel;
    }

    private JPanel getFilterModePanel() {
        this.filterMode.setData(this.filterModeItes);
        this.filterMode.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.filterCardLayout.show(this.filterCardPanel, String.valueOf(((IdTitle)e.getItem()).getId()));
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.filterMode, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTopPanel() {
        JPanel newsTitlePanel = new JPanel(new GridBagLayout());
        newsTitlePanel.setBorder((Border)new BGTitleBorder(" \u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a "));
        newsTitlePanel.add((Component)this.newsTitle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.datePanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)newsTitlePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        return panel;
    }

    private void getNews(int id) {
        try {
            this.current = ((NewsService)((ClientContext)this.getContext()).getPort(NewsService.class)).newsGet(id);
            this.setNewsData();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void setNewsData() {
        this.setLabelSelected(Collections.emptyList());
        this.sqlQuery.setText(this.current.getFilterData());
        this.newsTitle.setText(Utils.maskBlank((String)this.current.getTitle(), (String)"\u0411\u0435\u0437 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430"));
        this.datePanel.setDate(this.current.getDate() == null ? new Date() : this.current.getDate());
        this.source.setText(this.current.getBody());
        this.cardLayout.show(this.cardPanel, "editor");
        this.filterMode.setSelectedItem((Object)this.filterModeItes.stream().filter(a -> a.getId() == this.current.getFilter().getCode()).findFirst().orElse(this.filterModeItes.get(1)));
        switch (this.current.getFilter()) {
            case LABEL: {
                this.setLabelSelected(Utils.toIntegerList((String)this.current.getFilterData()));
                break;
            }
            case SQL: {
                this.sqlQuery.setText(this.current.getFilterData());
                break;
            }
            case HANDLER: {
                break;
            }
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            try {
                this.contractLabelTree.setData(((ContractLabelService)((ClientContext)this.getContext()).getPort(ContractLabelService.class)).getContractLabelTreeItemList(-1, false));
                SearchResult searchResult = this.getNewsService().newsSearch(this.pagesPanel.getPage());
                this.newsListTableModel.setData(searchResult.getList());
                this.pagesPanel.setPage(searchResult.getPage());
                this.recordsLabel.setText("\u0412\u0441\u0435\u0433\u043e: " + Utils.formatInteger((int)searchResult.getPage().getRecordCount()));
                this.cardLayout.show(this.cardPanel, "info");
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.current = new News();
            this.setNewsData();
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.newsListTableModel.optSelectedRow().ifPresentOrElse(news -> this.getNews(news.getId()), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u043e\u0432\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!")));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            NewsItem news = (NewsItem)this.newsListTableModel.getSelectedRow();
            if (news == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u043e\u0432\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
                return;
            }
            if (!ClientUtils.confirmDelete((Object)news)) {
                return;
            }
            try {
                this.getNewsService().newsDelete(news.getId());
                this.performAction("refresh");
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
    }

    void bGControlPanel_02_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.setNewsData();
        } else if ("ok".equals(actionCommand)) {
            this.current.setDate(this.datePanel.getDate());
            this.current.setTitle(this.newsTitle.getText().trim());
            this.current.setBody(this.source.getText().trim());
            NewsFilter newsFilter = NewsFilter.getNewsFilter((int)((IdTitle)this.filterMode.getSelectedItem()).getId());
            this.current.setFilter(newsFilter);
            switch (newsFilter) {
                case LABEL: {
                    this.current.setFilterData(Utils.toString(this.getLabelSelected()));
                    break;
                }
                case SQL: {
                    this.current.setFilterData(this.sqlQuery.getText());
                    break;
                }
                case HANDLER: {
                    this.current.setFilterData("");
                    break;
                }
                default: {
                    this.current.setFilterData("");
                }
            }
            try {
                this.getNewsService().newsUpdate(this.current);
                this.performAction("refresh");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        } else if ("cancel".equals(actionCommand)) {
            this.cardLayout.show(this.cardPanel, "info");
        }
    }

    private NewsService getNewsService() {
        if (this.newsService == null) {
            this.newsService = (NewsService)((ClientContext)this.getContext()).getPort(NewsService.class);
        }
        return this.newsService;
    }

    private List<Integer> getLabelSelected() {
        return this.contractLabelTree.getSelectedIds();
    }

    private void setLabelSelected(List<Integer> ids) {
        this.contractLabelTree.setSelectedIds(ids);
        this.contractLabelTree.revalidate();
        this.contractLabelTree.repaint();
    }

    class NewsListTableModel
    extends BGTableModel<NewsItem> {
        public NewsListTableModel() {
            super(NewsListTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", 150, 150, 150, "date", true, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 200, 200, "period", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

