// jQuery(document).ready( 
function ready() 
{ 
	setPageTitle("HelpDesk");
	getHelpDeskMode();
	var currentTopicId = jQuery( "form#currentTopicId" )[0].currentTopicId.value;
	if ( currentTopicId == '' ) 
		showTopicTable( 'active' );
	else 
		showTopic( currentTopicId ); 
	setInterval( getHelpDeskMode, 600 * 1000 );
}
//);

var webexecuter = "webexecuter";
var modes = [ "не оповещать",  "по телефону", "по e-mail", "по sms", "по telegram" ];
var lastMessageSize = 5;
var numfinput = 1;
var commMode = 0;
var commPhoneValue = "";
var commEmailValue = "";
var commSmsValue = "";
var commTelegramValue = "";
var mode = "active";
var sendandclose = false;
var currentTopic;
var currentTopicList;
var currentStatusMap;
var userNameMap;
var subcategoryMap;

function filechange()
{
	++numfinput;
	var g=document.getElementById('tdwithfileinput');
	var bre=document.createElement('br');
	g.appendChild(bre);
	var inpt=document.createElement('input');
	inpt.type="file";
	inpt.size=70;
	inpt.name="message_file_"+numfinput;
	inpt.onchange=filechange;
	g.appendChild(inpt);
}

function getHelpDeskMode()
{
	jQuery.get( webexecuter, { action: 'GetMode', module: helpdeskModule, mid: 0, contractId: contractId, ct: 'json' }, function( data )
	{
		if ( data.packages )
		{
			jQuery("input#helpDeskButtonPackages").show();
		}
	} );
}

function addHelpDeskTopic()
{
	setPageTitle("HelpDesk - Создание новой темы");
	jQuery.get( webexecuter, { action: 'AddTopic', module: helpdeskModule, mid: 0, contractId: contractId, ct: 'json' }, function( data )
	{
		var helpDeskAddTopic = hdShowBlock("helpDeskAddTopic").html( data );
		var form = jQuery( "form", helpDeskAddTopic )[0];
		form.topic_title.focus();// Для удобства установим фокус на теме
	} );
}

/** Создаем тему. Все данные в форме, тут только проверим категории и добавленный текст(версия биллинга). */
function updateHelpDeskTopic(form)
{
	if ( form.elements['topic.comm.category'] !== undefined )
	{
		var idCategory = form.elements['topic.comm.category'].value;
		
		if ( idCategory == -1 )
		{
			showHelpDeskTopicError('didNotSetCategory');
			return;
		}
	}
	
	if ( document.getElementById('additionalTextDiv') )
	{
		var idAddText = form.elements['topic.additionalTextToSubject.values'].value;
		if ( idAddText == 'Не выбрано' )
		{
			var title = document.getElementById('topic.additionalTextToSubject.title').innerHTML;
			alert( "Не выбрано: \"" + title.substring(0, title.length-1) + "\"" );//предпологаем что на последнем месте стоит ":"
			return;
		}
	}
	
	jQuery.ajax( webexecuter, { method: "POST", dataType: "json", data: jQuery(form).serialize() } )
		.done( function( data ) 
		{
			if ( data.result )
				showTopic( data.topic.id );
			else
				showHelpDeskTopicError( data.error );
		} );	
}

function showHelpDeskTopicError(error)
{
	if ( error == 'offMode' ) alert( "У Вас нет доступа к этой функции" ); 
	else if ( error == 'activePackageNotFound' ) alert( "Ошибка: Функция создания новой темы - НЕДОСТУПНА, т.к. нет активных пакетов." ); 
	else if ( error == 'bodyNotEmpty' ) alert( "Ошибка: Cообщение должно быть непустым." ); 
	else if ( error == 'noStatusNoClose' ) alert( "Ошибка: К сожалению, Вы не можете закрыть тему, статус которой не установлен менеджером." );
	else if ( error == 'subjectNotEmpty' ) alert( "Дайте название теме !" );
	else if ( error == 'didNotSetCategory' ) alert( "Не выбрана категория/подкатегория" );
	else alert( "Ошибка:" + error ); 
}

function setTopicCommValue( elem )
{
	var form = elem.form;
	var mode = form.elements['topicCommMode'].value;
	form.elements['topicCommValue'].value = jQuery( "option[value="+mode+"]", elem ).attr('commValue'); 
	
	if ( mode == "0" )
	{
		jQuery(form.elements['topicCommValue']).hide('fast');
	}
	else
	{
		jQuery(form.elements['topicCommValue']).show('fast');
	}
}

function setTopicListFilter( form )
{
	var rp = { action: 'GetTopicList', module: helpdeskModule, mode: mode, mid: 0, ct: 'json' }
	if ( form )
	{
		rp.tid = form.topicId.value;
		rp.topic = form.topicTitle.value;
		rp.date1 = form.date1.value;
		rp.date2 = form.date2.value;
		rp.searchString = form.searchString.value;
		rp.contractId = form.contractId.value;
	} 
	getTopicList( rp );
}

function resetTopicListFilter( form )
{
	jQuery(form).clearForm();
	setTopicListFilter( form );
}

function getTopicList( requestParam )
{
	//jQuery("div#topicItemParam").hide();
	var infoMessage = jQuery("<div class=\"alert alert-primary\">Выполняется запрос, пожалуйста подождите.</div>").appendTo( jQuery("body") );
	//var tbody = jQuery("table#topicTable tbody", topicListDiv).empty()[0];
	//var topicItemList = jQuery("div#topicItemList", topicListDiv);
	//topicItemList[0].innerHTML="";
	jQuery.get( webexecuter, requestParam, function( data ) 
	{ 
		hdShowBlock("topicList").html( data );
		//currentTopicList = data.topicList;
		//currentStatusMap = data.statusMap;
		infoMessage.remove();
	} );
}

function topicItemShowHideParam( index, tag )
{
	var topic = currentTopicList[index];
	var item = jQuery("div#topicItemParam").hide();
	jQuery("span#topicItemId",item).html("#"+topic.id);
	jQuery("span#topicItemNotify",item).html(getComm(topic.comm,topic.commValue));
	jQuery("span#topicItemStatus",item).html(checkValue( currentStatusMap[topic.status], "-" ));
	jQuery("span#topicItemState",item).html(topic.closed?"закрыта":"открыта");
	jQuery("span#topicItemDateCreate",item).html(parseDate(topic.date));
	jQuery("span#topicItemDateClose",item).html(parseDate(topic.dateClose));
	jQuery("span#topicItemCost",item).html(checkValue(topic.cost,"-"));
	jQuery("span#topicItemInPackage",item).html(checkValue(topic.inpackage,"-"));
	var objLeft = tag.offsetLeft;
	var objTop  = tag.offsetTop;
	var objParent = tag.offsetParent;
	while ( objParent.tagName.toUpperCase() != "BODY" )
	{
		objLeft  += objParent.offsetLeft;
		objTop   += objParent.offsetTop;
		objParent = objParent.offsetParent;
	}
	var xPos=objLeft;
	var yPos=objTop + tag.offsetHeight;
	item[0].style.display = "";
	item[0].style.top = yPos + "px";
	item[0].style.left = xPos + "px";
	item[0].style.visibility = "visible";
	return false;
}

function showPopupMenu( tag, menuId )
{
	hideAllPopup();
	var objLeft = tag.offsetLeft;
	var objTop  = tag.offsetTop;
	var objParent = tag.offsetParent;
	while ( objParent.tagName.toUpperCase() != "BODY" )
	{
		objLeft  += objParent.offsetLeft;
		objTop   += objParent.offsetTop;
		objParent = objParent.offsetParent;
	}
	var xPos=objLeft;
	var yPos=objTop + tag.offsetHeight;
	var menu = document.getElementById( menuId );
	if ( menu != null )
	{
		menu.style.display = "";
		menu.style.top = yPos + "px";
		menu.style.left = xPos + "px";
		menu.style.visibility = "visible";
	}
}

function showTopic( topicId )
{
	jQuery.get( webexecuter, { action: 'GetTopic', module: helpdeskModule, id: topicId, mid: 0, contractId: contractId, ct: 'json' }, function(data) { initTopicData( data, false ) } );
}

function initTopicData( data, showNew )
{
	var topicData = hdShowBlock("topicData")[0];
	jQuery( topicData ).hide();
	//
	currentTopic = data.topic;
	userNameMap = data.userNameMap;
	messageFileMap = data.messageFileMap;
	jQuery("span#topicDate", topicData).html( parseDate( currentTopic.date ) );
	jQuery("span#topicComm", topicData).html( getComm( currentTopic.comm, currentTopic.commValue ) + "<a href='#' onclick='return editTopicComm(this);'>[изменить]</a>" );
	jQuery("span#topicUser", topicData).html( userNameMap[ currentTopic.userId ] );
	jQuery("a#topicURL", topicData).attr( "href", "?action=HelpDeskAJAX&mid=0&module=ru.bitel.bgbilling.plugins.helpdesk&contractId=" + contractId + "&topicId=" + currentTopic.id ).html( "ссылка" );
	jQuery("span#topicTitle", topicData).html( currentTopic.title );
	jQuery("span#topicCost", topicData).html( currentTopic.cost );
	setHelpDeskTopicMessageList( topicData );
	if ( currentTopic.closed )
	{
		jQuery("div#topicReplyButton", topicData).hide();
	}
	else
	{
		jQuery("div#topicReplyButton", topicData).show();
	}
	if ( showNew )
	{
		topicMessageNew( "", topicData );
	}
	else
	{
		jQuery("div#topicMessageNew", topicData).hide();
		jQuery("div#topicMesssageList", topicData).show();
		jQuery("div#topicMesssageFilter", topicData).show();
	}
	jQuery( topicData ).show();
}

function setHelpDeskTopicMessageList( topicData )
{
	if ( !topicData ) topicData = jQuery("div#topicData");
	var messageListPoint = jQuery("div#topicMesssageList", topicData).empty().show()[0];
	var messageTable = jQuery("table#topicMessage", topicData )[0];
	var topicMessagesLength = currentTopic.messages.length;
 	for (i=0; i<topicMessagesLength; i++)
	{
		var message = currentTopic.messages[i];
		if ( lastMessageSize > 0 && i < currentTopic.messages.length - lastMessageSize ) continue;
		if ( lastMessageSize == -2 && message.userIdFrom == 0 ) continue;
		if ( lastMessageSize == -3 && message.userIdFrom != 0 ) continue;
		var cl = jQuery(messageTable).clone();
		if (message.userIdFrom > 0 && message.userIdTo == -1 ) jQuery( "span#messageNew", cl ).html( "НОВОЕ!!!" );
		var messageText = message.body.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
		if ( messageText.length > 200 ) messageText = messageText.substring( 0, 200 ) + "<span id='showNextText' style='padding-left: 1em; font-size: 70%;'>[<a href='#' onclick='showNextText(this); return false;' style='padding: 0px 3px;'>показать далее</a>]</span><span style='display: none'>" + messageText.substring( 200 ) + "</span>";
		if ( message.userIdFrom != 0 )
		{
			jQuery( "div.HelpDeskTopicMessageText", cl ).css( "padding-left", "50px" );
			if ( mode == 'active' ) jQuery( "span#messageReply", cl ).html( "[<a href=\"#\" onclick=\"replyHelpDeskTopicMessage( " + message.id + " ); return false;\">ответить</a>]" );
		}
		//
		var files = messageFileMap[message.id];
		if ( files.length > 0 )
		{
			var str = "";
			for (f=0; f<files.length; f++)
			{
				var file = files[f];
				str = str + "<span id=\"topicMessageFile_" + file.id + "\" style='padding-right: 2em;'>";
				str = str + "<img src=\"img/attach.png\" alt=\"прикреплено\"/>";
				str = str + "<a href=\"?action=FileDownload&mid=0&module="+helpdeskModule+"&id=" + file.id + "&contractId=" + contractId +"\" style=\"text-decoration: underline;\">";
				str = str + file.title;
				str = str + "</a> (" + file.size + " байт) ";
				if ( message.userIdFrom == 0 ) str = str + "<a href=\"#\" onclick=\"return deleteHelpDeskMessageFile( " + file.id + " )\">Удалить</a>";
				str = str + "</span>";
			}
			jQuery( "div#messageFile", cl ).html( str );
		}
		cl.css( { position: "static" } );
		cl.appendTo( messageListPoint );
	}
}

function helpDeskTopicMessageFilter( tag, size )
{
	lastMessageSize = size;
	setHelpDeskTopicMessageList();
	jQuery(tag).parent().find("a").css("font-weight","normal").end().end().css("font-weight","bold");
}

function helpDeskTopicClose()
{
	if ( confirm( "Вы уверены, что хотите закрыть тему?" ) )
	{
		jQuery.get( webexecuter, { action: 'UpdateTopicClose', module: helpdeskModule, topicId: currentTopic.id, mid: 0, contractId: contractId, ct: 'json' }, function(data)
		{
			if ( data.result ) showTopicTable( 'active' ); else showHelpDeskTopicError( data.error );
		} );
	}
}

function deleteHelpDeskMessageFile( fileId )
{
	if ( confirm( "Вы уверены, что хотите удалить файл?" ) )
	{
		jQuery.get( webexecuter, { action: 'FileDelete', module: helpdeskModule, id: fileId, mid: 0, ct: 'json' }, function( data ) 
		{
			if ( data.result ) jQuery("div#topicData span#topicMessageFile_" + fileId ).empty();
		} );
	}
	return false;
}

function showHelpDeskParamSaveButton( form )
{
	var showButton = false;
	showButton = form.elements['default.comm.mode'].value != commMode;
	if ( !showButton ) showButton = form.elements['comm.phone.value'].value != commPhoneValue;
	if ( !showButton ) showButton = form.elements['comm.email.value'].value != commEmailValue;
	if ( !showButton ) showButton = form.elements['comm.sms.value'].value != commSmsValue;
	if ( !showButton ) showButton = form.elements['comm.telegram.value'].value != commTelegramValue;
	if ( showButton ) jQuery(form.save).show(); else jQuery(form.save).hide();
}

function saveHelpDeskParam( form )
{
	jQuery.ajax( webexecuter, { method: "POST", dataType: "json", data: jQuery(form).serialize() } )
		.done( function( data ) 
		{
			if ( data.result ) 
				showHelpDeskParam( form.contractId.value ); 
		} );
}

/** Редактирование оповещение для темы */
function editTopicComm( form ) 
{
	val = "e-mail";
	comm = 2;
	if ( currentTopic.comm == 1 )
	{
		val = "телефон";
		comm = 1;
	}
	else if ( currentTopic.comm == 3 )
	{
		val = "sms";
		comm = 3;
	}
	else if ( currentTopic.comm == 4 )
	{
		val = "telegram";
		comm = 4;
	}
	var com_val = prompt ( "Отредактируйте " + val, currentTopic.commValue );
	if ( com_val == "" )
		comm = 0;
	else if ( com_val == null || com_val == currentTopic.commValue )
		return;
	jQuery.get( webexecuter, { action: 'UpdateTopicComm', module: helpdeskModule, mid: 0, contractId: contractId, ct: 'json', id: currentTopic.id, 'topic.comm.mode': comm, 'topic.comm.value': com_val }, function( data )
	{
		if ( data.result )
		{
			currentTopic.comm = data.comm;
			currentTopic.commValue = data.commValue;
			jQuery("span#topicComm", topicData).html( getComm( currentTopic.comm, currentTopic.commValue ) + "<a href='#' onclick='return editTopicComm(this);'>[изменить]</a>" );
		}
		else
			showHelpDeskTopicError( "Произошла ошибка при попытке сохранить!" );
	} );
}

function replyHelpDeskTopicMessage( messageId )
{
	for (i=0; i<currentTopic.messages.length; i++)
	{
		var message = currentTopic.messages[i];
		if ( message.id != messageId ) continue;
		topicMessageNew( message.body );
		break;
	}
}

function topicMessageNew( messageBodyText, topicData )
{
	if ( !topicData ) topicData = jQuery("div#topicData");
	jQuery("div#topicMesssageFilter", topicData).hide();
	jQuery("div#topicMesssageList", topicData).hide();
	jQuery("div#topicReplyButton", topicData).hide();
	var topicMessageNew = jQuery("div#topicMessageNew", topicData).show();
	
	var form = jQuery("form", topicMessageNew)[0];
	if ( !messageBodyText ) messageBodyText = "";
	if ( messageBodyText != "" ) messageBodyText = ">" + messageBodyText.replace(/\n/g, "\n>") + "\n\n";
	form.message_body.value = messageBodyText;
	form.topicId.value = currentTopic.id;
	
	numfinput = 1;
	jQuery("input:file", topicMessageNew).remove();
	jQuery("div#tdwithfileinput", topicMessageNew).append( "<input type=\"file\" name=\"message_file_1\" size=\"70\" onchange=\"filechange();\" />" );
}

function sendTopicMessageNew( form )
{
    jQuery.ajax(
    {
		url: webexecuter,
		type: 'POST',
		dataType: 'json',    
		contentType: false, // важно - убираем форматирование данных по умолчанию
		processData: false, // важно - убираем преобразование строк по умолчанию
		data: new FormData(form),
		success: function(json) { if (json) { alert( 'ok' ); } }
     });
	//jQuery("div#topicMessageNew iframe").load(function() { finishTopicMessageNew(); } );
	return false;
}

function finishTopicMessageNew()
{
	var form = jQuery("div#topicMessageNew form")[0];
}

function showHelpDeskPackage( contractId )
{
	setPageTitle("HelpDesk - Пакеты");
	var packageDiv = hdShowBlock( "helpDeskPackage" );
	jQuery.get( webexecuter, { action: 'GetPackage', module: helpdeskModule, mid: 0, contractId: contractId, ct: 'json' }, function( data ) 
	{
		var tbody = jQuery("div.report table tbody",packageDiv).empty();
		for (i=0; i<data.contractPackageList.length; i++)
		{
			var pkg = data.contractPackageList[i];
			var tr = jQuery("<tr/>");
			jQuery("<td/>").css("text-align","right").html(pkg.id).appendTo(tr);
			jQuery("<td/>").html(formatDate(pkg.dateFrom)+"-"+formatDate(pkg.dateTo)).appendTo(tr);
			jQuery("<td/>").css("text-align","right").html(pkg.summa).appendTo(tr);
			jQuery("<td/>").css("text-align","right").html(pkg.count+" ["+pkg.countUse+"]").appendTo(tr);
			jQuery("<td/>").css("text-align","center").html(data.activePackageMap[pkg.id]?"да":"нет").appendTo(tr);
			jQuery("<td/>").css("text-align","center").html(pkg.userId>0?"Администратор":"Пользователь").appendTo(tr);
			tr.appendTo(tbody);
		}
		var list = jQuery("div#helpDeskPackageList",packageDiv).empty();
		var listItem = jQuery("div#helpDeskPackageListItem",packageDiv);
		for (i=0; i<data.packageList.length; i++)
		{
			var pkg = data.packageList[i];
			var item = listItem.clone();
			var a = jQuery("<a/>").attr("href","#").attr("onclick","return addHelpDeskPackage("+pkg.id+","+contractId+")").html(pkg.title);
			jQuery("div#packageItemTitle",item).html(a);
			jQuery("span#packageItemPeriod",item).html(data.periodPackageMap[pkg.id]+" ["+pkg.period+"]");
			jQuery("span#packageItemCount",item).html(pkg.count);
			jQuery("span#packageItemSumma",item).html(pkg.summa);
			item.appendTo(list).show();
		}
	} );
}

function addHelpDeskPackage( packageId, contractId )
{
	if ( confirm( 'Вы уверены, что хотите активировать выбранный пакет?' ) )
	{
		jQuery.get( webexecuter, { action: 'AddPackage', module: helpdeskModule, mid: 0, packageId: packageId, contractId: contractId, ct: 'json' }, function( data ) 
		{
			if ( data.result ) { showHelpDeskPackage( contractId ); } else
			{
				if ( data.error == 'packageIdNotFound' ) alert( "Пакет не выбран" ); 
				else if ( data.error == 'packageNotFound' ) alert( "Пакет не существует" ); 
				else if ( data.error == 'packageStatusDisabled' ) alert( "packageStatusDisabled" ); 
				else if ( data.error == 'balanceNotValid' ) alert( "На счете не достаточно средств для активации пакета" ); 
				else if ( data.error == 'chargeNotFound' ) alert( "Расход не существует" ); 
			}	
		} );
	}
	return false;
}

function hdShowBlock( name )
{
	jQuery("div.hdBlock").hide();
	return jQuery("div#"+name).show('slow');
}

function getComm( comm, commValue )
{
	var result = "";
	if ( comm == 0 ) { result = result + "-"; }
	else if ( comm < 3 ) { result = result + modes[comm] + ": " + commValue; }
	return result;
}

function checkValue( value, defaultValue )
{
	var result = defaultValue;
	if ( value != undefined )
	{
		result = value;
	}
	return result;
}

function parseDate( inDate )
{
	var result = "н/д";
	if ( inDate != undefined )
	{
		var arr = inDate.split( " " );
		var date = Date.parse( arr[0] + ", " + arr[2] + " " + arr[1] + " " + arr[5] + " " + arr[3] );
		if ( date != undefined )
		{
			var dd = new Date();
			dd.setTime(date);
			result = dd.toLocaleString();
		}
	}
	return result;
}

function formatDate( date )
{
	return date.substring(8)+"."+date.substring(5,7)+"."+date.substring(0,4);
}

function showNextText( tag )
{
	jQuery(tag).parent().next().show().end().remove();
}

function showNextTextAll()
{
	jQuery( "span#showNextText" ).remove();
	jQuery( "div.HelpDeskTopicMessageText span" ).show();
}
