/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.card.server.bean.DealerManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class ActionDealerList
extends ActionBase {
    public void doAction() throws Exception {
        int mid = this.getIntParameter("mid", -1);
        int type = this.getIntParameter("type", 0);
        String title = this.getParameter("title");
        Date from = this.getDateParameter("date1");
        Date until = this.getDateParameter("date2");
        if (mid < 0) {
            throw new BGIllegalArgumentException();
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (Dealer dealer : new DealerManager(this.con, mid).getDealerList(title, new Period(from, until), type)) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(dealer.getId()));
            row.setAttribute("title", dealer.getTitle());
            row.setAttribute("period", TimeUtils.formatPeriod((Period)dealer.getPeriod()));
            row.setAttribute("comment", dealer.getComment());
            row.setAttribute("payment_type", String.valueOf(dealer.getPt()));
            row.setAttribute("statistics", dealer.getStatRequest() + "/" + dealer.getStatFinded() + "/" + dealer.getStatPayed());
            row.setAttribute("block", dealer.getError() > 5 ? "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d" : "\u0430\u043a\u0442\u0438\u0432\u0435\u043d");
        }
    }
}

